/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api.query;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import jet.formula.AggDesc;

public class AggregationKey
implements Externalizable {
    private static final long serialVersionUID = 62019791902L;
    int aggFunctionType;
    String baseColumn;
    private String SEDU;

    public AggregationKey(int n, String string) {
        this.aggFunctionType = n;
        this.baseColumn = string.toUpperCase();
    }

    public AggregationKey() {
    }

    public int getAggFunctionType() {
        return this.aggFunctionType;
    }

    public String getBaseColumn() {
        return this.baseColumn;
    }

    public int hashCode() {
        return this.aggFunctionType * 13 + this.baseColumn.hashCode() * 7;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AggregationKey)) {
            return false;
        }
        AggregationKey aggregationKey = (AggregationKey)object;
        return this.aggFunctionType == aggregationKey.aggFunctionType && this.baseColumn.equals(aggregationKey.baseColumn);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(AggDesc.mapCodeToString(this.aggFunctionType)).append('(').append(this.baseColumn).append(')');
        return stringBuilder.toString();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.aggFunctionType);
        objectOutput.writeObject(this.baseColumn);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.aggFunctionType = objectInput.readInt();
        this.baseColumn = (String)objectInput.readObject();
    }

    public String getMeasureName() {
        return this.SEDU;
    }

    public void setMeasureName(String string) {
        this.SEDU = string;
    }
}

