/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api.query;

import java.sql.Connection;
import java.util.Properties;
import jet.dataengine.api.DSException;
import jet.dataengine.util.DSLog;
import jet.dataengine.util.StringTools;
import jet.formula.JetRptFormula;

public class DataDescription
implements Cloneable {
    private static String logTitle = "DataDescription";
    public static final String CONSTANTFORMULACONNKEY = "";
    private final DSLog log = DSLog.getDSLog(this.getClass().getName());
    private final int type;
    private String sql;
    private Connection connection;
    private String driver;
    private String URL;
    private String username;
    private String password;
    private JetRptFormula[] constantFormulas;
    private Properties jndi;
    static final String[] JDNIKEYS = new String[]{"jrs.jdbc_driver", "jrs.ds_pswd", "jrs.catalog_connection_name", "jrs.ds_user", "jrs.catalog_connection_type", "jrs.jdbc_url"};

    public static DataDescription create(JetRptFormula[] constantFormulas) throws DSException {
        if (constantFormulas == null || constantFormulas.length < 1) {
            throw new DSException(1016);
        }
        DataDescription dataDesc = new DataDescription(6);
        dataDesc.constantFormulas = (JetRptFormula[])constantFormulas.clone();
        return dataDesc;
    }

    public static DataDescription create(Properties jndi) throws DSException {
        if (jndi == null) {
            throw new DSException(1022);
        }
        DataDescription dataDesc = new DataDescription(0x20000B);
        dataDesc.jndi = jndi;
        return dataDesc;
    }

    public Properties getJNDI() throws DSException {
        this.checkType("JNDI", 0x200000);
        return this.jndi;
    }

    public static DataDescription create(String driver, String url, String userName, String pwd) throws DSException {
        if (StringTools.isEmptyStringWithTrim(driver) || StringTools.isEmptyStringWithTrim(url)) {
            throw new DSException(1149);
        }
        DataDescription dataDesc = new DataDescription(122888);
        dataDesc.driver = driver;
        dataDesc.URL = url;
        dataDesc.username = userName;
        dataDesc.password = pwd;
        return dataDesc;
    }

    public static DataDescription create(Connection connection) throws DSException {
        if (connection == null) {
            throw new DSException(1150);
        }
        DataDescription dataDesc = new DataDescription(4103);
        dataDesc.connection = connection;
        return dataDesc;
    }

    private DataDescription(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public Connection getConnection() throws DSException {
        this.checkType("connection", 4096);
        return this.connection;
    }

    public String getDriver() throws DSException {
        this.checkType("driver", 8192);
        return this.driver;
    }

    public String getURL() throws DSException {
        this.checkType("URL", 16384);
        return this.URL;
    }

    public String getUsername() throws DSException {
        this.checkType("user name", 32768);
        return this.username;
    }

    public String getPassword() throws DSException {
        this.checkType("password", 65536);
        return this.password;
    }

    public JetRptFormula[] getConstantFormulas() throws DSException {
        this.checkType("constant formula", 6);
        return (JetRptFormula[])this.constantFormulas.clone();
    }

    @Deprecated
    private void checkType(String name2, int type) throws DSException {
        if ((this.type & type) != type) {
            throw new DSException(1116, new Object[]{name2, String.valueOf(this.type & 0xF)});
        }
    }

    public void dump() {
        if (!DSLog.isAdhoc() || !this.log.isDebugEnabled()) {
            return;
        }
        this.log.debug("DataDescription:");
        this.log.indent(logTitle);
        String typeName = this.getTypeName();
        switch (this.type) {
            case 6: {
                this.log.debug("type: " + typeName);
                int len = this.constantFormulas.length;
                for (int i = 0; i < len; ++i) {
                    this.log.debug("constant formula: " + this.constantFormulas[i]);
                }
                break;
            }
            case 4103: {
                this.log.debug("type: " + typeName);
                this.log.debug("Connection: " + this.connection);
                break;
            }
            case 122888: {
                this.log.debug("type: " + typeName);
                this.log.debug("Driver: " + this.driver);
                this.log.debug("URL: " + this.URL);
                this.log.debug("username: *****");
                this.log.debug("password: *****");
                break;
            }
            case 0x20000B: {
                this.log.debug("type: " + typeName);
                this.log.debug("jndi: " + this.jndi);
                break;
            }
            default: {
                assert (false) : "unknow data description type: " + this.type;
                this.log.debug("unknow data description type: " + this.type);
            }
        }
        this.log.deIndent(logTitle);
        this.log.debug("End DataDescription:");
    }

    public String getTypeName() {
        return Types.Names[this.type & 0xF];
    }

    public Object clone() {
        DataDescription dataDesc = new DataDescription(this.type);
        if (this.constantFormulas != null) {
            dataDesc.constantFormulas = (JetRptFormula[])this.constantFormulas.clone();
        }
        dataDesc.sql = this.sql;
        dataDesc.connection = this.connection;
        dataDesc.jndi = this.jndi;
        dataDesc.driver = this.driver;
        dataDesc.URL = this.URL;
        dataDesc.username = this.username;
        dataDesc.password = this.password;
        return dataDesc;
    }

    public boolean equalsDataDescription(DataDescription dataDescription) {
        if (this == dataDescription) {
            return true;
        }
        if (dataDescription == null) {
            return false;
        }
        if (this.getType() != dataDescription.getType()) {
            return false;
        }
        try {
            switch (this.getType()) {
                case 4103: {
                    return this.getConnection() == dataDescription.getConnection();
                }
                case 122888: {
                    return this.getURL().equals(dataDescription.getURL()) && this.getDriver().equals(dataDescription.getDriver()) && this.getPassword().equals(dataDescription.getPassword()) && this.getUsername().equals(dataDescription.getUsername());
                }
                case 0x20000B: {
                    return this.equalJNDI(this.getJNDI(), dataDescription.getJNDI());
                }
            }
            return false;
        }
        catch (DSException e) {
            return false;
        }
    }

    private boolean equalJNDI(Properties a, Properties b) {
        for (int i = 0; i < JDNIKEYS.length; ++i) {
            if (a.get(JDNIKEYS[i]).equals(b.get(JDNIKEYS[i]))) continue;
            return false;
        }
        return true;
    }

    public static class Types {
        public static final int CONNECTION = 4096;
        public static final int DRIVER = 8192;
        public static final int URL = 16384;
        public static final int USERNAME = 32768;
        public static final int PASSWORD = 65536;
        public static final int MAPPINGBIND = 131072;
        public static final int JNDI = 0x200000;
        public static final int ConstantFormula = 6;
        public static final int Connection = 4103;
        public static final int Driver = 122888;
        public static final int Jndi = 0x20000B;
        public static final int TypeMark = 15;
        public static final String[] Names = new String[]{"ResultSet, datasourcename, queryname, catalog object, Mapping Name Bind Info", "HDSResultSet", "Catalog Object, Data Source Name, SQL Statement", "Connection Object, SQL Statement, datasourcename, queryname, catalog object,  Mapping Name Bind Info ", "Driver, URL, User, Password, SQL Statement, datasourcename, queryname, catalog object,  Mapping Name Bind Info", "External Query Runner Object, Catalog Object, Data Source Name, Query Name", "Constant formulas", "connection, catalog, data source name, query name, Where Portion String,  Where String , Policy String", "Driver, URL, User, Password, catalog object, data source name, query name, Where Portion String,  Where String , Policy String", "DemandConnectionInfo, Driver, URL,UserName , PassWord", "DemandConnectionObject, Connect", "JNDI,CATALOG, DATA_SOURCE_NAME,QUERY_NAME , WherePortionString , WhereString , PolicyString", "JNDI, SQL, MAPPINGBIND , CATALOG , DATA_SOURCE_NAME , QUERY_NAME", "DemandJNDI = 13 | JNDI", "CrdDataWithBasedRawQuery = 14 | BasedRawQuery | CATALOG | DATA_SOURCE_NAME | QUERY_NAME | ResultSet_flag|BVData"};
    }
}

