/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api.query;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.ACanBeChange;
import jet.dataengine.util.DSLog;
import jet.formula.ParamDesc;

public class ParameterValueList
extends ACanBeChange {
    private static String SEDU = "ParameterValues";
    public static final ParameterValueList NULL_ParameterList = new ParameterValueList();
    private final DSLog Z = DSLog.getDSLog(this.getClass().getName());
    private Hashtable addParameterValue = new Hashtable();
    private Hashtable append = new Hashtable();

    public void addParameterValue(ParamDesc paramDesc) throws DSException {
        super.checkCanBeChange();
        ParamDesc paramDesc2 = (ParamDesc)paramDesc.clone();
        this.addParameterValue.put(paramDesc2.getName(), paramDesc2);
        this.append.put(paramDesc2.getName().toUpperCase(), paramDesc2);
    }

    public void addAll(ParameterValueList parameterValueList) throws DSException {
        super.checkCanBeChange();
        for (ParamDesc paramDesc : parameterValueList.addParameterValue.values()) {
            if (this.append.containsKey(paramDesc.getName().toUpperCase())) continue;
            ParamDesc paramDesc2 = (ParamDesc)paramDesc.clone();
            this.addParameterValue.put(paramDesc2.getName(), paramDesc2);
            this.append.put(paramDesc2.getName().toUpperCase(), paramDesc2);
        }
    }

    public ParamDesc[] getParameterDescriptions() {
        Collection collection = this.addParameterValue.values();
        ParamDesc[] paramDescArray = new ParamDesc[collection.size()];
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ParamDesc paramDesc;
            paramDescArray[n] = paramDesc = (ParamDesc)iterator.next();
            ++n;
        }
        return paramDescArray;
    }

    public ParamDesc getParameterDescription(String string) {
        ParamDesc paramDesc = (ParamDesc)this.addParameterValue.get(string);
        if (paramDesc == null) {
            paramDesc = (ParamDesc)this.append.get(string.toUpperCase());
        }
        return paramDesc;
    }

    public DbValue getValue(String string) {
        ParamDesc paramDesc = this.getParameterDescription(string);
        return paramDesc.getValue();
    }

    public DbValue getValue(ParamDesc paramDesc) {
        return this.getValue(paramDesc.getName());
    }

    public void clear() throws DSException {
        super.checkCanBeChange();
        this.addParameterValue.clear();
        this.append.clear();
    }

    public int size() {
        return this.addParameterValue.size();
    }

    public void dump() {
        if (!this.Z.isDebugEnabled()) {
            return;
        }
        this.Z.debug("Parameter valus list:");
        this.Z.indent(SEDU);
        Collection collection = this.addParameterValue.values();
        this.Z.debug("Size: " + collection.size());
        int n = 0;
        for (ParamDesc paramDesc : collection) {
            this.Z.debug(n++ + ") name: " + paramDesc.getName() + " value: " + paramDesc.getValue());
        }
        this.Z.deIndent(SEDU);
        this.Z.debug("End Parameter valus list:");
    }

    public ParameterValueList copy() throws DSException {
        ParameterValueList parameterValueList = new ParameterValueList();
        for (ParamDesc paramDesc : this.addParameterValue.values()) {
            parameterValueList.addParameterValue(paramDesc);
        }
        return parameterValueList;
    }

    public boolean contains(String string) {
        return this.addParameterValue.containsKey(string) || this.append.containsKey(string.toUpperCase());
    }

    public Hashtable getJavaFormulaParameters() {
        Hashtable<String, DbValue> hashtable = new Hashtable<String, DbValue>(this.size());
        for (ParamDesc paramDesc : this.getParameterDescriptions()) {
            hashtable.put(paramDesc.getName().toUpperCase(), this.getValue(paramDesc));
        }
        return hashtable;
    }

    public boolean isEquals(ParameterValueList parameterValueList) {
        if (this.size() != parameterValueList.size()) {
            return false;
        }
        for (String string : this.addParameterValue.keySet()) {
            DbValue dbValue;
            DbValue dbValue2 = this.getValue(string);
            if (dbValue2.equals(dbValue = parameterValueList.getValue(string))) continue;
            return false;
        }
        return true;
    }

    public boolean isSubset(ParameterValueList parameterValueList) {
        if (this.size() < parameterValueList.size()) {
            return false;
        }
        for (String string : parameterValueList.addParameterValue.keySet()) {
            DbValue dbValue;
            DbValue dbValue2 = this.getValue(string);
            if (dbValue2.equals(dbValue = parameterValueList.getValue(string))) continue;
            return false;
        }
        return true;
    }

    public boolean isSuperset(ParameterValueList parameterValueList) {
        if (this.size() > parameterValueList.size()) {
            return false;
        }
        for (String string : this.addParameterValue.keySet()) {
            DbValue dbValue;
            DbValue dbValue2 = this.getValue(string);
            if (dbValue2.equals(dbValue = parameterValueList.getValue(string))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (String string : this.addParameterValue.keySet()) {
            DbValue dbValue = this.getValue(string);
            stringBuilder.append(string).append(" = ").append(dbValue.toString()).append(';');
        }
        stringBuilder.append('}');
        stringBuilder.append("  hashCode: ").append(Integer.toHexString(this.hashCode()));
        return stringBuilder.toString();
    }

    public Hashtable getParameterValues_upperCase() {
        return this.append;
    }

    static {
        ParameterValueList.NULL_ParameterList.canBeChange = false;
    }
}

