/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api.schema.olap;

import com.jinfonet.dataservice.api.AObjectType;
import com.jinfonet.dataservice.api.schema.DataSchemaObjectType;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.schema.ASchemaObjectContainer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.ADimensionKeyDescription;
import jet.dataengine.api.query.AggResultInfo;
import jet.dataengine.api.query.AggregationKey;
import jet.dataengine.api.query.MeasureMember;
import jet.dataengine.api.schema.olap.JCube;
import jet.dataengine.api.schema.olap.JCubeMetaData;
import jet.dataengine.api.schema.olap.metadata.DimensionImpl;
import jet.dataengine.api.schema.olap.metadata.JDimension;
import jet.dataengine.api.schema.olap.metadata.JMeasure;
import jet.dataengine.api.schema.olap.metadata.MeasureImpl;
import jet.dataengine8.olap.core.BitKey;

public class CubeImpl
extends ASchemaObjectContainer
implements JCube {
    private static final long serialVersionUID = 62019791802L;
    private static final String CUBE = "CubeImpl";
    private List DIMENSION = new ArrayList();

    public CubeImpl() throws DSException {
        super("", DataSchemaObjectType.CUBE);
        this.addTypedNameSpace(DataSchemaObjectType.DIMENSION);
        this.addTypedNameSpace(DataSchemaObjectType.MEASURE);
    }

    public CubeImpl(String string) throws DSException {
        super(string, DataSchemaObjectType.CUBE);
        this.addTypedNameSpace(DataSchemaObjectType.DIMENSION);
        this.addTypedNameSpace(DataSchemaObjectType.MEASURE);
    }

    public CubeImpl(CubeImpl cubeImpl) throws DSException {
        this(cubeImpl.getName());
        this.addCubeMetaDatas(cubeImpl.getDimensions());
        this.addCubeMetaDatas(cubeImpl.getMeasures());
    }

    @Override
    public void setCubeMetaDatas(JCubeMetaData[] jCubeMetaDataArray) throws DSException {
        this.removeAllCubeMetaDatas();
        for (JCubeMetaData jCubeMetaData : jCubeMetaDataArray) {
            super.addContentElement(jCubeMetaData.copy());
        }
    }

    @Override
    public void addCubeMetaDatas(JCubeMetaData[] jCubeMetaDataArray) throws DSException {
        for (JCubeMetaData jCubeMetaData : jCubeMetaDataArray) {
            super.addContentElement(jCubeMetaData.copy());
        }
    }

    @Override
    public void addCubeMetaData(JCubeMetaData jCubeMetaData) throws DSException {
        super.addContentElement(jCubeMetaData.copy());
    }

    @Override
    public void removeAllCubeMetaDatas() throws DSException {
        super.removeAllContentElementsInTypedNameSpace(DataSchemaObjectType.DIMENSION);
        super.removeAllContentElementsInTypedNameSpace(DataSchemaObjectType.MEASURE);
    }

    @Override
    public void removeCubeMetaData(JCubeMetaData jCubeMetaData) throws DSException {
        super.removeContentElement(jCubeMetaData);
    }

    @Override
    public JDimension[] getDimensions() throws DSException {
        JDimension[] jDimensionArray = (JDimension[])super.getAllContentElementsInTypedNameSpace(DataSchemaObjectType.DIMENSION, new JDimension[0]);
        int n = jDimensionArray.length;
        for (int i = 0; i < n; ++i) {
            jDimensionArray[i] = jDimensionArray[i];
        }
        return jDimensionArray;
    }

    @Override
    public JDimension getDimension(String string) throws DSException {
        JCubeMetaData jCubeMetaData = (JCubeMetaData)super.getContentElementInTypedNameSpace(DataSchemaObjectType.DIMENSION, string);
        if (jCubeMetaData != null) {
            return (JDimension)jCubeMetaData.copy();
        }
        return null;
    }

    @Override
    public JMeasure[] getMeasures() throws DSException {
        JMeasure[] jMeasureArray = (JMeasure[])super.getAllContentElementsInTypedNameSpace(DataSchemaObjectType.MEASURE, new JMeasure[0]);
        int n = jMeasureArray.length;
        for (int i = 0; i < n; ++i) {
            jMeasureArray[i] = jMeasureArray[i];
        }
        return jMeasureArray;
    }

    @Override
    public JMeasure getMeasure(String string) throws DSException {
        JCubeMetaData jCubeMetaData = (JCubeMetaData)super.getContentElementInTypedNameSpace(DataSchemaObjectType.MEASURE, string);
        if (jCubeMetaData != null) {
            return (JMeasure)jCubeMetaData.copy();
        }
        return null;
    }

    @Override
    public JCube copy() throws DSException {
        return new CubeImpl(this);
    }

    @Override
    public void dump() {
        this.log.debug("---- benig Cube metaData");
        this.log.indent(CUBE);
        super.dump();
        this.log.deIndent(CUBE);
        this.log.debug("---- end Cube metaData");
    }

    @Override
    public boolean contain(JCube jCube) throws DSException {
        if (this == jCube) {
            return true;
        }
        if (jCube == null) {
            return false;
        }
        HashMap<String, JCubeMetaData> hashMap = new HashMap<String, JCubeMetaData>();
        JCubeMetaData[] jCubeMetaDataArray = (JCubeMetaData[])this.getAllContentElements(new JCubeMetaData[0]);
        int n = jCubeMetaDataArray.length;
        for (int i = 0; i < n; ++i) {
            JCubeMetaData jCubeMetaData = jCubeMetaDataArray[i];
            hashMap.put(jCubeMetaData.getName(), jCubeMetaData);
        }
        for (JCubeMetaData jCubeMetaData : (JCubeMetaData[])jCube.getAllContentElements(new JCubeMetaData[0])) {
            JCubeMetaData jCubeMetaData2 = (JCubeMetaData)hashMap.remove(jCubeMetaData.getName());
            if (jCubeMetaData2 != null && jCubeMetaData2.equals(jCubeMetaData)) continue;
            return false;
        }
        return hashMap.size() >= 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CubeImpl)) {
            return false;
        }
        HashMap<String, JCubeMetaData> hashMap = new HashMap<String, JCubeMetaData>();
        CubeImpl cubeImpl = (CubeImpl)object;
        JCubeMetaData[] jCubeMetaDataArray = (JCubeMetaData[])this.getAllContentElements(new JCubeMetaData[0]);
        int n = jCubeMetaDataArray.length;
        for (int i = 0; i < n; ++i) {
            JCubeMetaData jCubeMetaData = jCubeMetaDataArray[i];
            hashMap.put(jCubeMetaData.getName(), jCubeMetaData);
        }
        for (JCubeMetaData jCubeMetaData : (JCubeMetaData[])cubeImpl.getAllContentElements(new JCubeMetaData[0])) {
            JCubeMetaData jCubeMetaData2 = (JCubeMetaData)hashMap.remove(jCubeMetaData.getName());
            if (jCubeMetaData2 != null && jCubeMetaData2.equals(jCubeMetaData)) continue;
            return false;
        }
        return hashMap.isEmpty();
    }

    public boolean dimensionsEquals(Object object) throws DSException {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CubeImpl)) {
            return false;
        }
        HashMap<String, JDimension> hashMap = new HashMap<String, JDimension>();
        CubeImpl cubeImpl = (CubeImpl)object;
        JDimension[] jDimensionArray = this.getDimensions();
        int n = jDimensionArray.length;
        for (int i = 0; i < n; ++i) {
            JDimension jDimension = jDimensionArray[i];
            hashMap.put(jDimension.getName(), jDimension);
        }
        for (JDimension jDimension : cubeImpl.getDimensions()) {
            JDimension jDimension2 = (JDimension)hashMap.remove(jDimension.getName());
            if (jDimension2 != null && jDimension2.equals(jDimension)) continue;
            return false;
        }
        return hashMap.isEmpty();
    }

    @Override
    public int comapreDimensions(JCube jCube) throws DSException {
        if (this == jCube) {
            return 0;
        }
        if (jCube == null) {
            return 1;
        }
        if (!(jCube instanceof CubeImpl)) {
            return -1;
        }
        HashMap<String, JDimension> hashMap = new HashMap<String, JDimension>();
        JDimension[] jDimensionArray = this.getDimensions();
        int n = jDimensionArray.length;
        for (int i = 0; i < n; ++i) {
            JDimension jDimension = jDimensionArray[i];
            hashMap.put(jDimension.getName(), jDimension);
        }
        for (JDimension jDimension : jCube.getDimensions()) {
            JDimension jDimension2 = (JDimension)hashMap.remove(jDimension.getName());
            if (jDimension2 != null && jDimension2.equals(jDimension)) continue;
            return -1;
        }
        if (hashMap.isEmpty()) {
            return 0;
        }
        return 1;
    }

    @Override
    public List getMeasureMembers() throws DSException {
        return this.getMeasureMembers();
    }

    @Override
    public void setMeasureMembers(MeasureMember[] measureMemberArray) throws DSException {
        for (MeasureMember measureMember : measureMemberArray) {
            for (int n : measureMember.getAggregationType()) {
                AggregationKey aggregationKey = new AggregationKey(n, measureMember.getMappingName());
                if (this.DIMENSION.contains(aggregationKey)) continue;
                this.DIMENSION.add(aggregationKey);
            }
        }
    }

    @Override
    public boolean hasMeasureMember(AggregationKey aggregationKey) throws DSException {
        return this.DIMENSION.contains(aggregationKey);
    }

    @Override
    public JDimension getDimensionByKey(ADimensionKeyDescription aDimensionKeyDescription) throws DSException {
        for (JDimension jDimension : this.getDimensions()) {
            if (!jDimension.getDimensionKeyDescription().equals(aDimensionKeyDescription)) continue;
            return jDimension;
        }
        throw new DSException(6115);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            this.contentTypeSet.add((AObjectType)objectInput.readObject());
        }
        try {
            JCubeMetaData[] jCubeMetaDataArray = new DimensionImpl[objectInput.readInt()];
            for (int i = 0; i < jCubeMetaDataArray.length; ++i) {
                jCubeMetaDataArray[i] = (DimensionImpl)objectInput.readObject();
            }
            this.addCubeMetaDatas(jCubeMetaDataArray);
            JCubeMetaData[] jCubeMetaDataArray2 = new MeasureImpl[objectInput.readInt()];
            for (int i = 0; i < jCubeMetaDataArray2.length; ++i) {
                jCubeMetaDataArray2[i] = (MeasureImpl)objectInput.readObject();
            }
            this.addCubeMetaDatas(jCubeMetaDataArray2);
        }
        catch (DSException dSException) {
            this.log.debug(dSException.getMessage());
        }
        int n2 = objectInput.readInt();
        this.DIMENSION = new ArrayList(n2);
        for (int i = 0; i < n2; ++i) {
            AggregationKey aggregationKey = (AggregationKey)objectInput.readObject();
            this.DIMENSION.add(aggregationKey);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.contentTypeSet.size());
        for (Object object : this.contentTypeSet) {
            objectOutput.writeObject(object);
        }
        try {
            Object object;
            object = this.getDimensions();
            objectOutput.writeInt(((JDimension[])object).length);
            for (JDimension jDimension : object) {
                objectOutput.writeObject((DimensionImpl)jDimension);
            }
            JMeasure[] jMeasureArray = this.getMeasures();
            objectOutput.writeInt(jMeasureArray.length);
            for (JMeasure jMeasure : jMeasureArray) {
                objectOutput.writeObject((MeasureImpl)jMeasure);
            }
        }
        catch (DSException dSException) {
            this.log.debug(dSException.getMessage());
        }
        objectOutput.writeInt(this.DIMENSION.size());
        for (AggregationKey aggregationKey : this.DIMENSION) {
            objectOutput.writeObject(aggregationKey);
        }
    }

    @Override
    public Set getDimensionMappingNames() throws DSException {
        HashSet<String> hashSet = new HashSet<String>();
        for (JDimension jDimension : this.getDimensions()) {
            hashSet.add(jDimension.getDimensionKeyDescription().getMappingName());
        }
        return hashSet;
    }

    public void generateMeasureMetaData(boolean bl, JRelationMetaData jRelationMetaData, AggResultInfo aggResultInfo) throws DSException {
        for (JMeasure jMeasure : this.getMeasures()) {
            jMeasure.generateMetaData(bl, jRelationMetaData, aggResultInfo);
        }
    }

    @Override
    public BitKey calculateCuboidKey(JCube jCube) throws DSException {
        int n = this.getDimensions().length;
        if (n < 1) {
            n = 1;
        }
        BitKey bitKey = BitKey.Factory.makeBitKey(n);
        for (JDimension jDimension : jCube.getDimensions()) {
            for (int i = 0; i < this.getDimensions().length; ++i) {
                if (!this.getDimensions()[i].equals(jDimension)) continue;
                bitKey.set(i);
            }
        }
        return bitKey;
    }
}

