/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api.schema.olap.metadata;

import com.jinfonet.dataservice.api.schema.DataSchemaObjectType;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jet.connect.DbColDesc;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.AggResultInfo;
import jet.dataengine.api.schema.olap.ACubeMetaData;
import jet.dataengine.api.schema.olap.JCubeMetaData;
import jet.dataengine.api.schema.olap.JCubeMetaDataType;
import jet.dataengine.api.schema.olap.metadata.DetailInformationImpl;
import jet.dataengine.api.schema.olap.metadata.DimensionImpl;
import jet.dataengine.api.schema.olap.metadata.JMeasure;
import jet.formula.AggDesc;
import jet.formula.Aggregation;

public class MeasureImpl
extends ACubeMetaData
implements JMeasure {
    private static final long serialVersionUID = 62019791812L;
    private static final String MEASURE = "MeasureImpl";
    private List SEDU = new LinkedList();
    private List add = new ArrayList();
    private List addAggregationType = new ArrayList();

    public MeasureImpl() throws DSException {
        super("", DataSchemaObjectType.MEASURE);
    }

    public MeasureImpl(String string) throws DSException {
        super(string, DataSchemaObjectType.MEASURE);
    }

    @Override
    public JCubeMetaDataType getCubeMetaDataType() throws DSException {
        return JCubeMetaDataType.MEASURE;
    }

    @Override
    public JCubeMetaData convertToDimension() throws DSException {
        DimensionImpl dimensionImpl = new DimensionImpl(this.getName());
        dimensionImpl.setRelation(this.relation);
        dimensionImpl.setDefaultAttribute(this.defaultAttribute);
        return dimensionImpl;
    }

    @Override
    public JCubeMetaData convertToMeasure() throws DSException {
        return this.copy();
    }

    @Override
    public JCubeMetaData convertToDetailInfo() throws DSException {
        DetailInformationImpl detailInformationImpl = new DetailInformationImpl(this.getName());
        detailInformationImpl.setRelation(this.relation);
        detailInformationImpl.setDefaultAttribute(this.defaultAttribute);
        return detailInformationImpl;
    }

    @Override
    public JCubeMetaData copy() throws DSException {
        MeasureImpl measureImpl = new MeasureImpl(this.getName());
        measureImpl.relation = this.relation;
        measureImpl.defaultAttribute = this.defaultAttribute;
        measureImpl.SEDU.addAll(this.SEDU);
        measureImpl.add.addAll(this.add);
        measureImpl.addAggregationType.addAll(this.addAggregationType);
        return measureImpl;
    }

    @Override
    public Integer[] getAggregationTypes() throws DSException {
        return this.SEDU.toArray(new Integer[this.SEDU.size()]);
    }

    @Override
    public void setAggregationTypes(Integer[] integerArray) throws DSException {
        this.SEDU.clear();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            this.SEDU.add(integerArray[i]);
        }
    }

    @Override
    public void addAggregationType(Integer n) throws DSException {
        this.SEDU.add(n);
    }

    @Override
    public boolean removeAggregationType(Integer n) throws DSException {
        return this.SEDU.remove(n);
    }

    @Override
    public void dump() {
        this.log.debug("---- benig measure");
        this.log.indent(MEASURE);
        super.dump();
        this.log.debug("AggregationTypes: " + this.SEDU.size());
        this.log.indent(MEASURE);
        for (Integer n : this.SEDU) {
            this.log.debug(n.toString());
        }
        this.log.deIndent(MEASURE);
        this.log.deIndent(MEASURE);
        this.log.debug("---- end measure");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof MeasureImpl)) {
            return false;
        }
        MeasureImpl measureImpl = (MeasureImpl)object;
        return ((Object)this.defaultAttribute).equals(measureImpl.getDefaultAttribute());
    }

    @Override
    public boolean existAggregationType(Integer n) throws DSException {
        return this.SEDU.contains(n);
    }

    @Override
    public int getAggSize() {
        return this.SEDU.size();
    }

    @Override
    public Integer getAggType(int n) {
        return (Integer)this.SEDU.get(n);
    }

    @Override
    public AggDesc getAggDesc(int n) {
        return (AggDesc)this.add.get(n);
    }

    @Override
    public DbColDesc getColDesc(int n) {
        return (DbColDesc)this.addAggregationType.get(n);
    }

    @Override
    public void mergeAggregationType(int[] nArray) throws DSException {
        for (int n : nArray) {
            if (this.existAggregationType(n)) continue;
            this.addAggregationType(n);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        this.name = (String)objectInput.readObject();
        this.SEDU = (List)objectInput.readObject();
        int n2 = objectInput.readInt();
        for (n = 0; n < n2; ++n) {
            this.add.add((AggDesc)objectInput.readObject());
        }
        n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            this.addAggregationType.add((DbColDesc)objectInput.readObject());
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.name);
        objectOutput.writeObject(this.SEDU);
        objectOutput.writeInt(this.add.size());
        for (Externalizable externalizable : this.add) {
            objectOutput.writeObject(externalizable);
        }
        objectOutput.writeInt(this.addAggregationType.size());
        for (Externalizable externalizable : this.addAggregationType) {
            objectOutput.writeObject(externalizable);
        }
    }

    public void setColDescs(List list) {
        this.addAggregationType = list;
    }

    @Override
    public List getColDescs() {
        return this.addAggregationType;
    }

    public void setAggDescs(List list) {
        this.add = list;
    }

    @Override
    public List getAggDescs() {
        return this.add;
    }

    @Override
    public void generateMetaData(boolean bl, JRelationMetaData jRelationMetaData, AggResultInfo aggResultInfo) throws DSException {
        this.addAggregationType = new LinkedList();
        this.add = new LinkedList();
        for (Integer n : this.SEDU) {
            this.add.add(new AggDesc(this.getName(), this.getName(), n));
            if (bl) {
                if (Aggregation.isCompondAggregation(n)) {
                    this.addAggregationType.add(Aggregation.getColDesc(n, this.getDefaultAttribute().getDataType(), this.getDefaultAttribute().isCurrency()));
                    continue;
                }
                int n2 = aggResultInfo.getAggInfo4Relation(n, this.getName());
                JAttribute jAttribute = jRelationMetaData.getAttribute(n2);
                this.addAggregationType.add(new DbColDesc(this.getName(), jAttribute.getDataType(), jAttribute.getPrecision(), jAttribute.getScale(), jAttribute.isNullable(), jAttribute.isCurrency()));
                continue;
            }
            this.addAggregationType.add(Aggregation.getColDesc(n, this.getDefaultAttribute().getDataType(), this.getDefaultAttribute().isCurrency()));
        }
    }
}

