/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.groupengine;

import com.jinfonet.util.JRLog;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JDbBufferData;
import jet.dataengine.api.dbbuffer.JParallelDbBuffer;
import jet.dataengine.api.query.GroupQueryExtender;
import jet.dataengine.api.query.JGroupQuery;
import jet.dataengine.api.query.JHDSQuery;
import jet.dataengine.groupengine.AggGroupEngine;
import jet.dataengine.groupengine.DataBuffer;
import jet.dataengine.groupengine.DetailTreeEngine;
import jet.dataengine.groupengine.JGroupEngine;
import jet.dataengine.groupengine.ParallelGroupEngine;

public class GroupEngineFactory {
    public static synchronized JGroupEngine createGroupEngine(JHDSQuery jHDSQuery, JParallelDbBuffer jParallelDbBuffer) throws DSException {
        return new ParallelGroupEngine(jParallelDbBuffer, jHDSQuery);
    }

    public static synchronized JGroupEngine createGroupEngine(JGroupQuery jGroupQuery, JDbBufferData jDbBufferData) throws DSException {
        GroupQueryExtender groupQueryExtender = jGroupQuery.getExtender();
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "GroupEngine Factory log info, group query is org chart: " + jGroupQuery.isOrgChartQuery() + " can push down agg: " + groupQueryExtender.isCanPushDownAgg());
        }
        if (jGroupQuery.isOrgChartQuery()) {
            return new DetailTreeEngine(jGroupQuery, jDbBufferData);
        }
        if (groupQueryExtender.isCanPushDownAgg()) {
            return new AggGroupEngine(jDbBufferData, groupQueryExtender.getAggResultInfo(), jGroupQuery);
        }
        return new DataBuffer(jGroupQuery, jDbBufferData);
    }
}

