/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.groupengine;

import java.util.Vector;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JParallelDbBuffer;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.groupengine.DataBuffer;
import jet.dataengine.groupengine.GroupBreaker;
import jet.dataengine.groupengine.GroupModel;
import jet.dataengine.groupengine.NormalGroupBreaker;
import jet.dataengine.groupengine.ParaLeafGroupModel;
import jet.dataengine.groupengine.RangGroupBreaker;
import jet.dataengine.util.DSLog;
import jet.formula.AggDesc;
import jet.formula.Aggregation;
import jet.formula.CompondAggregation;
import jet.formula.FormulaQueue;
import jet.formula.JavaFormula;
import jet.formula.JetRptFormula;

public class ParaGroupModel
extends GroupModel {
    String branchName;
    Vector siblingNames;
    Vector siblings;
    int[] aggsBranchIdx = null;
    int iShared = -1;
    int branchIdx = -1;
    Vector childBranchIdx;
    int[] filtersBranchIdx;
    int[] grouplevelsBranchIdx;
    private ParaGroupModel SEDU;
    private Vector Z;
    private static DSLog add = DSLog.getDSLog(ParaGroupModel.class.getName());

    public ParaGroupModel(DbColDesc dbColDesc, DbColDesc[] dbColDescArray, ParaGroupModel paraGroupModel, int n, int n2, int n3, int[] nArray, String string, int n4) {
        super(dbColDesc, dbColDescArray, paraGroupModel, n, n2, n3, nArray, string, n4);
    }

    public ParaGroupModel(DbColDesc dbColDesc, DbColDesc[] dbColDescArray, ParaGroupModel paraGroupModel, int n, int n2, int n3, int[] nArray, String string) {
        super(dbColDesc, dbColDescArray, paraGroupModel, n, n2, n3, nArray, string);
    }

    public boolean isShared() {
        if (this.iShared != -1) {
            return this.iShared > 0;
        }
        if (this.buffer.paraBuffer != null && this.buffer.recordModel.isParallel()) {
            ParaGroupModel paraGroupModel = (ParaGroupModel)this.next;
            while (paraGroupModel != null) {
                if (paraGroupModel.siblingNames != null && paraGroupModel.siblingNames.size() > 0) {
                    this.iShared = 1;
                    return true;
                }
                paraGroupModel = (ParaGroupModel)paraGroupModel.next;
            }
        }
        this.iShared = 0;
        return false;
    }

    @Override
    public Aggregation[] createAggregations() {
        Vector vector;
        Aggregation[] aggregationArray = null;
        if (this.aggs != null) {
            aggregationArray = new Aggregation[this.aggs.length];
            for (int i = 0; i < this.aggs.length; ++i) {
                aggregationArray[i] = (Aggregation)this.aggs[i].clone();
                if (!(aggregationArray[i] instanceof CompondAggregation)) continue;
                Aggregation[] aggregationArray2 = ((CompondAggregation)aggregationArray[i]).getUsedAggs();
                for (int j = 1; j < aggregationArray2.length; ++j) {
                    AggDesc aggDesc = aggregationArray2[j].getAggDesc();
                    if (aggDesc.calIndex == -1 && this.buffer.formulaQueue != null) {
                        Vector vector2 = this.buffer.formulaQueue.getSumFuncQueue(0, this.groupIndex);
                        aggDesc.calIndex = vector2.indexOf(aggregationArray2[j]);
                    }
                    aggregationArray2[j] = aggregationArray[aggDesc.calIndex];
                }
            }
            return aggregationArray;
        }
        if (this.buffer.formulaQueue != null && (vector = this.buffer.formulaQueue.getSumFuncQueue(0, this.groupIndex)) != null) {
            boolean bl = this.isShared();
            JParallelDbBuffer jParallelDbBuffer = null;
            if (bl) {
                jParallelDbBuffer = this.buffer.paraBuffer;
                this.aggsBranchIdx = new int[vector.size()];
            }
            aggregationArray = new Aggregation[vector.size()];
            for (int i = 0; i < aggregationArray.length; ++i) {
                aggregationArray[i] = (Aggregation)((Aggregation)vector.elementAt(i)).clone();
                if (aggregationArray[i] instanceof CompondAggregation) {
                    Aggregation[] aggregationArray3 = ((CompondAggregation)aggregationArray[i]).getUsedAggs();
                    for (int j = 1; j < aggregationArray3.length; ++j) {
                        AggDesc aggDesc = aggregationArray3[j].getAggDesc();
                        aggDesc.calIndex = vector.indexOf(aggregationArray3[j]);
                        aggregationArray3[j] = aggregationArray[aggDesc.calIndex];
                    }
                }
                if (!bl) continue;
                this.aggsBranchIdx[i] = jParallelDbBuffer.getIndexByField(aggregationArray[i].getFName());
            }
        }
        this.aggs = aggregationArray;
        this.setAggBaseGroup();
        return aggregationArray;
    }

    public int getColIndex(String string) {
        if (this.isShared()) {
            if (this.Z == null) {
                GroupModel groupModel = this;
                do {
                    if (!(groupModel instanceof ParaLeafGroupModel)) continue;
                    if (this.Z == null) {
                        this.Z = new Vector();
                    }
                    this.Z.add(groupModel.recordModelInfo);
                } while ((groupModel = ((GroupModel)groupModel).nextToMe()) != null);
            }
            int n = this.Z.size();
            for (int i = 0; i < n; ++i) {
                RecordModelInfo recordModelInfo = (RecordModelInfo)this.Z.elementAt(i);
                int n2 = recordModelInfo.indexOfCell(string);
                if (n2 == -1) continue;
                return n2;
            }
        }
        return this.recordModelInfo.indexOfCell(string);
    }

    private void SEDU(int n, Vector vector) {
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            DbColDesc dbColDesc = ((JetRptFormula)vector.elementAt(i)).getColDesc();
            this.groupLevelValues[i + n] = DbValue.makeDbValue(dbColDesc);
            if (this.isShared()) {
                dbColDesc.setColIndex(this.getColIndex(dbColDesc.colName));
                continue;
            }
            dbColDesc.setColIndex(this.recordModelInfo.indexOfCell(dbColDesc.colName));
        }
    }

    public int[] getGrouplevelsBranchIdx() {
        return this.grouplevelsBranchIdx;
    }

    @Override
    DbValue[] createGroupLevelValues() {
        if (this.groupLevelValues == null) {
            Object object;
            if (this.buffer.formulaQueue != null) {
                Vector vector = this.buffer.formulaQueue.getSumFmlQueue(1, this.groupIndex);
                object = this.buffer.formulaQueue.getGlobalHSumQueue(this.groupIndex);
                Vector vector2 = this.buffer.formulaQueue.getGlobalFSumQueue(this.groupIndex);
                this.groupLev = vector == null ? 0 : vector.size();
                this.globalH = object == null ? 0 : ((Vector)object).size();
                int n = vector2 == null ? 0 : vector2.size();
                int n2 = this.groupLev + this.globalH + n;
                if (n2 != 0) {
                    this.groupLevelValues = new DbValue[n2];
                    if (this.groupLev != 0) {
                        this.SEDU(0, vector);
                    }
                    if (this.globalH != 0) {
                        this.SEDU(this.groupLev, (Vector)object);
                    }
                    if (n != 0) {
                        this.SEDU(this.groupLev + this.globalH, vector2);
                    }
                }
            }
            if (this.groupLevelValues != null && this.groupLevelValues.length > 0) {
                boolean bl = this.isShared();
                object = null;
                if (bl) {
                    object = this.buffer.paraBuffer;
                    this.grouplevelsBranchIdx = new int[this.groupLevelValues.length];
                    for (int i = 0; i < this.groupLevelValues.length; ++i) {
                        this.grouplevelsBranchIdx[i] = object.getIndexByField(this.groupLevelValues[i].getColDesc());
                    }
                }
            }
        } else {
            DbValue[] dbValueArray = new DbValue[this.groupLevelValues.length];
            for (int i = 0; i < this.groupLevelValues.length; ++i) {
                dbValueArray[i] = (DbValue)this.groupLevelValues[i].clone();
            }
            this.groupLevelValues = dbValueArray;
        }
        return this.groupLevelValues;
    }

    public Vector getChildBranches() {
        return this.childBranchIdx;
    }

    public void addChildBranch(int n) {
        Integer n2 = new Integer(n);
        if (this.childBranchIdx == null) {
            this.childBranchIdx = new Vector();
        }
        if (!this.childBranchIdx.contains(n2)) {
            this.childBranchIdx.add(n2);
        }
    }

    public boolean isChildBranch(int n) {
        Integer n2 = new Integer(n);
        if (this.childBranchIdx != null && this.childBranchIdx.contains(n2)) {
            return true;
        }
        return n == this.branchIdx;
    }

    public int getBranchIdx() {
        return this.branchIdx;
    }

    @Override
    void setDataBuffer(DataBuffer dataBuffer) {
        this.buffer = dataBuffer;
        if (dataBuffer.paraBuffer != null && dataBuffer.recordModel.isParallel()) {
            try {
                if (this.preprocess != null) {
                    this.branchIdx = dataBuffer.paraBuffer.getIndexByField(this.preprocess.colName, this.branchName);
                    if (this.recordModelInfo == null) {
                        this.recordModelInfo = dataBuffer.recordModel.getSubRecordModel(this.branchIdx);
                    }
                    this.preprocess.setColIndex(this.recordModelInfo.indexOfCell(this.preprocess.colName));
                } else if (this.branchName != null && this.branchIdx == -1) {
                    this.branchIdx = dataBuffer.paraBuffer.getIndexByName(this.branchName);
                    if (this.branchIdx == -2) {
                        this.branchIdx = dataBuffer.paraBuffer.getIndexRev(this.branchName);
                    }
                }
                if (this.branchIdx != -1 && this.branchIdx != -2) {
                    ParaGroupModel paraGroupModel = (ParaGroupModel)this.prev;
                    while (paraGroupModel != null) {
                        paraGroupModel.addChildBranch(this.branchIdx);
                        paraGroupModel = (ParaGroupModel)paraGroupModel.prev;
                    }
                    if (this.recordModelInfo == null) {
                        this.recordModelInfo = dataBuffer.recordModel.getSubRecordModel(this.branchIdx);
                    }
                }
            }
            catch (DSException dSException) {
                add.error(4067, dSException);
            }
        }
        if (this.next != null) {
            this.next.setDataBuffer(dataBuffer);
        }
        int n = this.siblings == null ? 0 : this.siblings.size();
        for (int i = 0; i < n; ++i) {
            ((GroupModel)this.siblings.elementAt(i)).setDataBuffer(dataBuffer);
        }
    }

    @Override
    void setDataBuffer(DataBuffer dataBuffer, FormulaQueue formulaQueue, JavaFormula javaFormula) {
        this.buffer = dataBuffer;
        this.formulaQueue = formulaQueue;
        this.javaFormula = javaFormula;
        if (dataBuffer.paraBuffer != null && dataBuffer.recordModel.isParallel()) {
            try {
                if (this.preprocess != null) {
                    this.branchIdx = dataBuffer.paraBuffer.getIndexByField(this.preprocess.colName, this.branchName);
                    if (this.recordModelInfo == null) {
                        this.recordModelInfo = dataBuffer.recordModel.getSubRecordModel(this.branchIdx);
                    }
                    this.preprocess.setColIndex(this.recordModelInfo.indexOfCell(this.preprocess.colName));
                } else if (this.branchName != null && this.branchIdx == -1) {
                    this.branchIdx = dataBuffer.paraBuffer.getIndexByName(this.branchName);
                    if (this.branchIdx == -2) {
                        this.branchIdx = dataBuffer.paraBuffer.getIndexRev(this.branchName);
                    }
                }
                if (this.branchIdx != -1 && this.branchIdx != -2) {
                    ParaGroupModel paraGroupModel = (ParaGroupModel)this.prev;
                    while (paraGroupModel != null) {
                        paraGroupModel.addChildBranch(this.branchIdx);
                        paraGroupModel = (ParaGroupModel)paraGroupModel.prev;
                    }
                    if (this.recordModelInfo == null) {
                        this.recordModelInfo = dataBuffer.recordModel.getSubRecordModel(this.branchIdx);
                    }
                }
            }
            catch (DSException dSException) {
                add.error(4067, dSException);
            }
        }
        if (this.next != null) {
            this.next.setDataBuffer(dataBuffer, formulaQueue, javaFormula);
        }
        int n = this.siblings == null ? 0 : this.siblings.size();
        for (int i = 0; i < n; ++i) {
            ((GroupModel)this.siblings.elementAt(i)).setDataBuffer(dataBuffer, formulaQueue, javaFormula);
        }
    }

    @Override
    public void setDataBuffer(DataBuffer dataBuffer, RecordModelInfo recordModelInfo) {
        this.buffer = dataBuffer;
        this.recordModelInfo = recordModelInfo;
        if (dataBuffer.paraBuffer != null && dataBuffer.recordModel.isParallel() && this.preprocess != null) {
            this.preprocess.setColIndex(this.recordModelInfo.indexOfCell(this.preprocess.colName));
            this.branchIdx = dataBuffer.paraBuffer.getIndexByField(this.preprocess.colName, this.branchName);
        }
        if (this.next != null) {
            ((ParaGroupModel)this.next).setDataBuffer(dataBuffer, recordModelInfo);
        }
    }

    @Override
    Vector[] getRecordFormulas2() {
        return this.buffer.recordFormulas2;
    }

    @Override
    Aggregation[] createGroupFilter() {
        int n;
        Aggregation[] aggregationArray = null;
        int n2 = n = this.groupfilter == null ? 0 : this.groupfilter.size();
        if (n > 0) {
            boolean bl = this.isShared();
            JParallelDbBuffer jParallelDbBuffer = null;
            if (bl) {
                jParallelDbBuffer = this.buffer.paraBuffer;
                this.filtersBranchIdx = new int[n];
            }
            aggregationArray = new Aggregation[n];
            for (int i = 0; i < aggregationArray.length; ++i) {
                aggregationArray[i] = (Aggregation)((Aggregation)this.groupfilter.elementAt(i)).clone();
                if (!bl) continue;
                this.filtersBranchIdx[i] = jParallelDbBuffer.getIndexByField(aggregationArray[i].getFName());
            }
        }
        return aggregationArray;
    }

    public void setBranchName(String string) {
        if (this.branchName == null) {
            this.branchName = string;
        }
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void addSibling(String string, ParaGroupModel paraGroupModel) {
        if (this.siblingNames == null) {
            this.siblingNames = new Vector();
            this.siblings = new Vector();
        }
        this.siblingNames.add(string);
        paraGroupModel.setBranchName(string);
        this.siblings.add(paraGroupModel);
    }

    public void addSibling(String string, ParaGroupModel paraGroupModel, int n) {
        if (this.siblingNames == null) {
            this.siblingNames = new Vector();
            this.siblings = new Vector();
        }
        if (n >= this.siblingNames.size()) {
            this.siblingNames.add(string);
            paraGroupModel.setBranchName(string);
            this.siblings.add(paraGroupModel);
        } else {
            this.siblingNames.add(n, string);
            paraGroupModel.setBranchName(string);
            this.siblings.add(n, paraGroupModel);
        }
    }

    public ParaGroupModel get(String string) {
        if (string == null) {
            return this;
        }
        Vector vector = null;
        Vector vector2 = null;
        if (this.siblings != null) {
            vector = this.siblings;
            vector2 = this.siblingNames;
        } else if (this.prev == null) {
            if (this.SEDU != null) {
                if (this.SEDU.branchName != null && (string.equals(this.SEDU.branchName) || string.startsWith(this.SEDU.branchName + "."))) {
                    return this.SEDU;
                }
                vector = this.SEDU.siblings;
                vector2 = this.SEDU.siblingNames;
            }
        } else {
            ParaGroupModel paraGroupModel = (ParaGroupModel)this.prev.next;
            if (paraGroupModel.branchName != null && (string.equals(paraGroupModel.branchName) || string.startsWith(paraGroupModel.branchName + "."))) {
                return paraGroupModel;
            }
            vector = paraGroupModel.siblings;
            vector2 = paraGroupModel.siblingNames;
        }
        int n = vector2 == null ? 0 : vector2.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)vector2.elementAt(i);
            if (!string.equals(string2) && !string.startsWith(string2 + ".")) continue;
            return (ParaGroupModel)vector.elementAt(i);
        }
        return this;
    }

    public GroupModel nextGroupModel(String string) {
        if (string == null) {
            return this.next;
        }
        return ((ParaGroupModel)this.next).get(string);
    }

    public void setBrother(ParaGroupModel paraGroupModel) {
        this.SEDU = paraGroupModel;
    }

    public ParaGroupModel getBrother() {
        return this.SEDU;
    }

    @Override
    public GroupModel nextToMe() {
        if (this.next != null) {
            return this.next;
        }
        GroupModel groupModel = this;
        while (groupModel != null) {
            int n;
            Vector vector = groupModel.getSiblings();
            int n2 = n = vector == null ? 0 : vector.size();
            if (n == 0) {
                groupModel = groupModel.prev;
                continue;
            }
            int n3 = vector.indexOf(groupModel);
            if (n3 + 1 < n) {
                return (ParaGroupModel)vector.elementAt(n3 + 1);
            }
            groupModel = groupModel.prev;
        }
        return null;
    }

    public Vector getSiblings() {
        if (this.siblings != null) {
            return this.siblings;
        }
        if (this.prev == null) {
            if (this.SEDU != null) {
                return this.SEDU.siblings;
            }
            return null;
        }
        return ((ParaGroupModel)this.prev.next).siblings;
    }

    @Override
    public GroupModel getLastLeaf() {
        ParaGroupModel paraGroupModel = this;
        while (paraGroupModel.prev != null) {
            paraGroupModel = (ParaGroupModel)paraGroupModel.prev;
        }
        while (!(paraGroupModel instanceof ParaLeafGroupModel) || paraGroupModel.siblings != null) {
            if (paraGroupModel.siblings != null) {
                paraGroupModel = (ParaGroupModel)paraGroupModel.siblings.lastElement();
                continue;
            }
            if (paraGroupModel.next == null) continue;
            paraGroupModel = (ParaGroupModel)paraGroupModel.next;
        }
        return (ParaLeafGroupModel)paraGroupModel;
    }

    @Override
    public GroupModel getLeaf() {
        GroupModel groupModel = this;
        while (groupModel.next != null) {
            groupModel = groupModel.next;
        }
        return (ParaLeafGroupModel)groupModel;
    }

    boolean removeSibling(GroupModel groupModel) {
        int n;
        if (this.siblingNames != null && (n = this.siblings.indexOf(groupModel)) > -1) {
            this.siblings.removeElementAt(n);
            this.siblingNames.removeElementAt(n);
            if (this.siblings.size() == 0) {
                this.siblings = null;
                this.siblingNames = null;
            }
            return true;
        }
        return false;
    }

    public ParaGroupModel removeMain() {
        ParaGroupModel paraGroupModel = null;
        if (this.siblingNames != null) {
            if (this.siblingNames.size() > 0) {
                paraGroupModel = (ParaGroupModel)this.siblings.elementAt(0);
                this.siblings.removeElementAt(0);
                this.siblingNames.removeElementAt(0);
                paraGroupModel.SEDU = null;
            }
            if (this.siblings.size() == 0) {
                this.siblings = null;
                this.siblingNames = null;
            } else {
                int n = this.siblings.size();
                for (int i = 0; i < n; ++i) {
                    ParaGroupModel paraGroupModel2 = (ParaGroupModel)this.siblings.elementAt(i);
                    if (paraGroupModel2.SEDU == null) continue;
                    paraGroupModel2.SEDU = paraGroupModel;
                }
            }
            paraGroupModel.siblings = this.siblings;
            paraGroupModel.siblingNames = this.siblingNames;
        }
        return paraGroupModel;
    }

    @Override
    public GroupModel copyGroupModel() {
        DbColDesc[] dbColDescArray = null;
        DbColDesc dbColDesc = null;
        if (this.reprocess != null) {
            dbColDescArray = new DbColDesc[this.reprocess.length];
            for (int i = 0; i < this.reprocess.length; ++i) {
                dbColDescArray[i] = (DbColDesc)this.reprocess[i].clone();
            }
        }
        if (this.preprocess != null) {
            dbColDesc = (DbColDesc)this.preprocess.clone();
        }
        ParaGroupModel paraGroupModel = new ParaGroupModel(dbColDesc, dbColDescArray, null, this.groupIndex, this.topN, this.preOrder, this.reOrder, this.otherName, this.bottomN);
        paraGroupModel.branchName = this.branchName;
        if (this.specfunc != null) {
            paraGroupModel.setSpecFunc((DbColDesc)this.specfunc.clone());
        }
        if (this.specFuncName != null) {
            paraGroupModel.specFuncName = this.specFuncName;
        }
        paraGroupModel.bSortByServer = this.bSortByServer;
        GroupBreaker groupBreaker = null;
        groupBreaker = this.isSpecifiedOrder() ? new RangGroupBreaker(paraGroupModel) : new NormalGroupBreaker(paraGroupModel);
        paraGroupModel.setBreaker(groupBreaker);
        paraGroupModel.keepSpecOther = this.keepSpecOther;
        if (this.recordModelInfo != null) {
            paraGroupModel.recordModelInfo = (RecordModelInfo)this.recordModelInfo.clone();
        }
        paraGroupModel.modelCreater = this.modelCreater;
        paraGroupModel.id = this.id;
        if (this.groupfilter != null && this.groupfilter.size() > 0) {
            Aggregation[] aggregationArray = this.createGroupFilter();
            paraGroupModel.groupfilter = new Vector(aggregationArray.length);
            for (int i = 0; i < aggregationArray.length; ++i) {
                paraGroupModel.groupfilter.addElement(aggregationArray[i]);
            }
        }
        if (this.gfLogic != null) {
            paraGroupModel.gfLogic = (Vector)this.gfLogic.clone();
        }
        return paraGroupModel;
    }

    @Override
    public GroupModel dup() {
        DbColDesc[] dbColDescArray = null;
        DbColDesc dbColDesc = null;
        if (this.reprocess != null) {
            dbColDescArray = new DbColDesc[this.reprocess.length];
            for (int i = 0; i < this.reprocess.length; ++i) {
                dbColDescArray[i] = (DbColDesc)this.reprocess[i].clone();
            }
        }
        if (this.preprocess != null) {
            dbColDesc = (DbColDesc)this.preprocess.clone();
        }
        ParaGroupModel paraGroupModel = new ParaGroupModel(dbColDesc, dbColDescArray, null, this.groupIndex, this.topN, this.preOrder, this.reOrder, this.otherName, this.bottomN);
        paraGroupModel.branchName = this.branchName;
        if (this.specfunc != null) {
            paraGroupModel.setSpecFunc((DbColDesc)this.specfunc.clone());
        }
        if (this.specFuncName != null) {
            paraGroupModel.specFuncName = this.specFuncName;
        }
        paraGroupModel.bSortByServer = this.bSortByServer;
        GroupBreaker groupBreaker = null;
        groupBreaker = this.isSpecifiedOrder() ? new RangGroupBreaker(paraGroupModel) : new NormalGroupBreaker(paraGroupModel);
        paraGroupModel.setBreaker(groupBreaker);
        paraGroupModel.keepSpecOther = this.keepSpecOther;
        if (this.recordModelInfo != null) {
            paraGroupModel.recordModelInfo = (RecordModelInfo)this.recordModelInfo.clone();
        }
        paraGroupModel.modelCreater = this.modelCreater;
        paraGroupModel.id = this.id;
        if (this.groupfilter != null && this.groupfilter.size() > 0) {
            Aggregation[] aggregationArray = this.createGroupFilter();
            paraGroupModel.groupfilter = new Vector(aggregationArray.length);
            for (int i = 0; i < aggregationArray.length; ++i) {
                paraGroupModel.groupfilter.addElement(aggregationArray[i]);
            }
        }
        if (this.gfLogic != null) {
            paraGroupModel.gfLogic = (Vector)this.gfLogic.clone();
        }
        return paraGroupModel;
    }

    @Override
    public int getType() {
        return 5;
    }
}

