/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.groupengine;

import com.jinfonet.dataservice.expression.executor.conditiontools.TupleFilterFactory;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.DetailTupleFilter;
import com.jinfonet.util.JRLog;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbInteger;
import jet.connect.Record;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JParallelDbBuffer;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.dbbuffer.JRecordModel;
import jet.dataengine.api.dbbuffer.ParallelRecordModel;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.api.query.HDSBranchDescription;
import jet.dataengine.api.query.HDSQueryOption;
import jet.dataengine.api.query.JHDSQuery;
import jet.dataengine.groupengine.DataBuffer;
import jet.dataengine.groupengine.GroupImpl;
import jet.dataengine.groupengine.GroupModel;
import jet.dataengine.groupengine.LeafGroup;
import jet.dataengine.groupengine.LeafGroupList;
import jet.dataengine.groupengine.ParaGroupModel;
import jet.dataengine.util.DSLog;
import jet.dataengine8.dbbuffer.MetaDataTool;
import jet.dataengine8.dbbuffer.ParallelDbBuffer;
import jet.dataengine8.dbbuffer.TupleAdapterRecord;
import jet.formula.JetRptFormula;
import jet.log.JRLoggingUtil;

class ParallelGroupEngine
extends DataBuffer {
    private long I = -1L;
    private static DSLog SEDU = DSLog.getDSLog(ParallelGroupEngine.class.getName());

    ParallelGroupEngine(JParallelDbBuffer jParallelDbBuffer, JHDSQuery jHDSQuery) throws DSException {
        try {
            this.javaFormula = jHDSQuery.getJavaFormula();
            this.formulaQueue = jHDSQuery.getFormulaQueue();
            HDSQueryOption hDSQueryOption = jHDSQuery.getOption();
            this.singleThread = hDSQueryOption.isSingleThread();
            this.I = hDSQueryOption.getMaxRecords();
            this.logKey = JRLoggingUtil.getNDC();
            if (SEDU.isDebugEnabled()) {
                this.start = System.currentTimeMillis();
                SEDU.debug("Trace info\nsingle-thread is " + this.singleThread);
            }
            this.paraBuffer = jParallelDbBuffer;
            this.rootModel = jHDSQuery.getGroupModel();
            this.id = this.rootModel.id;
            this.recordModel = this.paraBuffer.getRecordModel();
            JDbBufferCursor[] jDbBufferCursorArray = this.paraBuffer.getBuffers();
            int n = jDbBufferCursorArray.length;
            this.fetchedLeafGroupCounts = new int[n];
            this.recordForGroupBreak = new JRecord[n];
            this.globalRecord = new JRecord[n];
            this.fetchRecord = new JRecord[n];
            for (int i = 0; i < n; ++i) {
                this.fetchedLeafGroupCounts[i] = 0;
                JDbBufferCursor jDbBufferCursor = jDbBufferCursorArray[i];
                this.recordForGroupBreak[i] = jDbBufferCursor.createRecord();
                this.globalRecord[i] = jDbBufferCursor.createRecord();
                this.fetchRecord[i] = jDbBufferCursor.createRecord();
            }
            this.setGroupLevels(this.recordModel.getGroupables());
            this.rootModel.setDataBuffer(this, this.formulaQueue, this.javaFormula);
            GroupModel groupModel = this.rootModel;
            this.travelGroupModel(true);
            this.bNeedCount = hDSQueryOption.getNeedCountTotalRecord();
            this.jgrpl = hDSQueryOption.getGroupListeners();
            this.dtf = this.getBrowserFilters(jHDSQuery);
        }
        catch (DSException dSException) {
            SEDU.error(4069, dSException);
        }
    }

    DetailTupleFilter[] getBrowserFilters(JHDSQuery jHDSQuery) throws DSException {
        int n;
        HDSBranchDescription[] hDSBranchDescriptionArray = jHDSQuery.getBranchDescriptions();
        ParallelRecordModel parallelRecordModel = jHDSQuery.getRecordModel();
        Vector vector = parallelRecordModel.getBranchNames();
        DetailTupleFilter[] detailTupleFilterArray = new DetailTupleFilter[vector.size()];
        RecordModelInfo[] recordModelInfoArray = parallelRecordModel.getSubRecordModels();
        HDSBranchDescription[] hDSBranchDescriptionArray2 = new HDSBranchDescription[vector.size()];
        for (n = 0; n < hDSBranchDescriptionArray.length; ++n) {
            hDSBranchDescriptionArray2[hDSBranchDescriptionArray[n].getBranchIndex()] = hDSBranchDescriptionArray[n];
        }
        for (n = 0; n < detailTupleFilterArray.length; ++n) {
            if (hDSBranchDescriptionArray2[n].getAfterMaxRecordFilter() == null) {
                detailTupleFilterArray[n] = null;
                continue;
            }
            RecordModelInfo recordModelInfo = (RecordModelInfo)recordModelInfoArray[n].clone();
            recordModelInfo.getColDesc(0).setColName("");
            detailTupleFilterArray[n] = TupleFilterFactory.getFilter(hDSBranchDescriptionArray2[n].getAfterMaxRecordFilter(), MetaDataTool.convert2RelationMetaData(recordModelInfo), jHDSQuery.getParameterValues());
        }
        return detailTupleFilterArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws DSException, JRStopEngineException {
        Object object;
        try {
            if (SEDU.isDebugEnabled()) {
                this.startRun = System.currentTimeMillis();
                object = new Timestamp(this.startRun);
                String string = this.toString();
                SEDU.debug("Trace info\n" + string + "@start at@" + object + "@initiate time@" + (this.startRun - this.start) + "ms");
                SEDU.debug("Trace info\nsingle-thread is " + this.singleThread);
            }
            if (!this.recordModel.isParallel()) {
                this.root = this.rootModel.createGroup(null, null, true);
            }
            if (this.formulaQueue != null) {
                if (this.recordModel.isParallel()) {
                    object = this.paraBuffer.getRecordModels();
                    int n = ((JRecordModel[])object).length;
                    this.recordFormulas2 = new Vector[n];
                    Vector vector = this.formulaQueue.getByRecordQueue(1);
                    int n2 = vector == null ? 0 : vector.size();
                    JetRptFormula jetRptFormula = null;
                    String string = null;
                    block14: for (int i = 0; i < n2; ++i) {
                        jetRptFormula = (JetRptFormula)vector.elementAt(i);
                        string = jetRptFormula.name.get().toUpperCase();
                        for (int j = 0; j < n; ++j) {
                            int n3 = object[j].indexOfCell(string);
                            if (n3 == -1) continue;
                            if (this.recordFormulas2[j] == null) {
                                this.recordFormulas2[j] = new Vector();
                            }
                            this.recordFormulas2[j].addElement(jetRptFormula);
                            jetRptFormula.getColDesc().setColIndex(n3);
                            continue block14;
                        }
                    }
                } else if (this.recordFormulas2 == null) {
                    this.recordFormulas2 = new Vector[1];
                    this.recordFormulas2[0] = this.formulaQueue.getByRecordQueue(1);
                }
            } else {
                this.recordFormulas2 = new Vector[1];
                this.recordFormulas2[0] = null;
            }
            this.I();
        }
        catch (Throwable throwable) {
            this.isError = true;
            this.errorException = new DSException(4257, throwable);
        }
        finally {
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
            if (this.isError) {
                this.paraBuffer.finish();
                if (this.root != null) {
                    this.root.doBreakedErr();
                }
                throw this.errorException;
            }
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "Group Engine start finnaly, this group engine is " + this + " group root is " + this.root);
            }
            if (this.bStopping) {
                throw new JRStopEngineException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void I() {
        String string;
        Object object;
        block63: {
            Object object2;
            boolean bl;
            block59: {
                bl = false;
                try {
                    int n = 0;
                    while (this.paraBuffer.next()) {
                        block61: {
                            block62: {
                                object2 = this.paraBuffer.getCurrentRecord();
                                bl = ((ParallelDbBuffer)this.paraBuffer).isEmpty();
                                if (bl) {
                                    object = (DbInteger)object2.getCell(0);
                                    ((DbInteger)object).set(0);
                                    object2.update(0);
                                }
                                if (this.root != null && !bl && this.root.isDiscard((Record)object2)) continue;
                                if (this.bNeedCount && !bl) {
                                    ++this.iTotalRecCnt;
                                }
                                if (this.I != -1L && this.I <= (long)n) break block61;
                                ++n;
                                if (!this.recordModel.isParallel()) break block62;
                                int n2 = this.paraBuffer.getCurrentBranceIndex();
                                if (this.dtf[n2] == null || this.dtf[n2].filterTuple(new TupleAdapterRecord((JRecord)object2))) {
                                    ++this.count;
                                    this.addRecord((JRecord)object2, this.paraBuffer.getReadGroup(), this.paraBuffer.getCurrentBranceIndex(), this.paraBuffer.getCurrentBranceName());
                                    if (this.bNeedCount && !bl) {
                                        ++this.iTotalFecRecCnt;
                                    }
                                }
                                break block61;
                            }
                            if (this.dtf[0] == null || this.dtf[0].filterTuple(new TupleAdapterRecord((JRecord)object2))) {
                                ++this.count;
                                this.addRecord((JRecord)object2, this.paraBuffer.getReadGroup());
                                if (this.bNeedCount && !bl) {
                                    ++this.iTotalFecRecCnt;
                                }
                            }
                        }
                        if (this.I == -1L || (long)n < this.I || this.bNeedCount) continue;
                    }
                    if (bl) {
                        this.bNoRecord = true;
                    }
                    if (this.count != 0) break block59;
                    if (this.bNeedCount) {
                        this.iTotalRecCnt = 0;
                        this.iTotalFecRecCnt = 0;
                    }
                    this.bNoRecord = true;
                    if (this.javaFormula != null) {
                        this.javaFormula.setNoRecord(true);
                    }
                }
                catch (DSException dSException) {
                    this.isError = true;
                    this.errorException = dSException;
                    SEDU.error(4004, dSException);
                }
                try {
                    JRecord jRecord = ((ParallelDbBuffer)this.paraBuffer).getFakeRecord();
                    object2 = (DbInteger)jRecord.getCell(0);
                    ((DbInteger)object2).set(0);
                    jRecord.update(0);
                    ++this.count;
                    int n = 0;
                    string = this.paraBuffer.getBranch(0);
                    if (this.recordModel.isParallel()) {
                        this.addRecord(jRecord, this.paraBuffer.getReadGroup(), n, string);
                    } else {
                        this.addRecord(jRecord, this.paraBuffer.getReadGroup());
                    }
                }
                catch (DSException dSException) {
                    SEDU.error(4004, dSException);
                }
            }
            this.paraBuffer.finish();
            if (this.bStopping) {
                SEDU.warn(4002, new JRStopEngineException());
                ParallelGroupEngine parallelGroupEngine = this;
                synchronized (parallelGroupEngine) {
                    this.notifyAll();
                }
                this.root.doBreakedErr();
            } else {
                try {
                    this.breaking();
                }
                catch (Throwable throwable) {
                    if (this.bStopping) {
                        SEDU.warn(4002, new JRStopEngineException());
                    } else {
                        SEDU.error(4003, throwable);
                    }
                    object2 = this;
                    synchronized (object2) {
                        this.notifyAll();
                    }
                    this.root.doBreakedErr();
                }
            }
            this.bFin = true;
            if (this.bNeedCount) {
                for (int i = 0; this.jgrpl != null && i < this.jgrpl.length; ++i) {
                    if (this.jgrpl[i] == null) continue;
                    this.jgrpl[i].endFectchingRecords(this.iTotalRecCnt, this.iTotalFecRecCnt);
                }
            }
            break block63;
            finally {
                Object object3;
                Object object4;
                if (bl) {
                    this.bNoRecord = true;
                }
                if (this.count == 0) {
                    if (this.bNeedCount) {
                        this.iTotalRecCnt = 0;
                        this.iTotalFecRecCnt = 0;
                    }
                    this.bNoRecord = true;
                    if (this.javaFormula != null) {
                        this.javaFormula.setNoRecord(true);
                    }
                    try {
                        object4 = ((ParallelDbBuffer)this.paraBuffer).getFakeRecord();
                        object3 = (DbInteger)object4.getCell(0);
                        ((DbInteger)object3).set(0);
                        object4.update(0);
                        ++this.count;
                        int n = 0;
                        string = this.paraBuffer.getBranch(0);
                        if (this.recordModel.isParallel()) {
                            this.addRecord((JRecord)object4, this.paraBuffer.getReadGroup(), n, string);
                        } else {
                            this.addRecord((JRecord)object4, this.paraBuffer.getReadGroup());
                        }
                    }
                    catch (DSException dSException) {
                        SEDU.error(4004, dSException);
                    }
                }
                this.paraBuffer.finish();
                if (this.bStopping) {
                    SEDU.warn(4002, new JRStopEngineException());
                    object4 = this;
                    synchronized (object4) {
                        this.notifyAll();
                    }
                    this.root.doBreakedErr();
                } else {
                    try {
                        this.breaking();
                    }
                    catch (Throwable throwable) {
                        if (this.bStopping) {
                            SEDU.warn(4002, new JRStopEngineException());
                        } else {
                            SEDU.error(4003, throwable);
                        }
                        object3 = this;
                        synchronized (object3) {
                            this.notifyAll();
                        }
                        this.root.doBreakedErr();
                    }
                }
                this.bFin = true;
                if (this.bNeedCount) {
                    for (int i = 0; this.jgrpl != null && i < this.jgrpl.length; ++i) {
                        if (this.jgrpl[i] == null) continue;
                        this.jgrpl[i].endFectchingRecords(this.iTotalRecCnt, this.iTotalFecRecCnt);
                    }
                }
            }
        }
        if (!SEDU.isDebugEnabled()) return;
        long l = System.currentTimeMillis();
        object = new Timestamp(l);
        string = this.toString() + '@';
        SEDU.debug("Trace info\n" + string + "end run at@" + object + "@elapsed time@" + (l - this.startRun) + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecord(JRecord jRecord, int n) throws DSException {
        try {
            if (!this.singleThread && this.count == 1) {
                ParallelGroupEngine parallelGroupEngine = this;
                synchronized (parallelGroupEngine) {
                    this.notifyAll();
                }
            }
            this.root.grouping(jRecord, this.groupLevels[0] - n);
            if (this.bStopping) {
                throw new JRStopEngineException();
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof DSException && ((DSException)throwable).getPartMessKey() == 4005) {
                throw new DSException(4005);
            }
            SEDU.error(4006, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecord(JRecord jRecord, int n, int n2, String string) throws DSException {
        try {
            GroupImpl groupImpl;
            if (!this.singleThread && this.count == 1) {
                ParallelGroupEngine parallelGroupEngine = this;
                synchronized (parallelGroupEngine) {
                    this.notifyAll();
                }
            }
            int n3 = this.branchIdxs.length;
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                if (this.branchIdxs[i] != n2) continue;
                n4 = i;
                break;
            }
            if (this.root == null) {
                ParaGroupModel paraGroupModel = ((ParaGroupModel)this.rootModel).get(string);
                groupImpl = this.root = paraGroupModel.createGroup(null, null, true);
                groupImpl.branchIdx = n2;
                if (!this.singleThread) {
                    ParallelGroupEngine parallelGroupEngine = this;
                    synchronized (parallelGroupEngine) {
                        this.notifyAll();
                    }
                }
            } else if (this.root.branchIdx == n2) {
                groupImpl = this.root;
            } else {
                groupImpl = this.root;
                if (n2 != -1 && !((ParaGroupModel)this.root.getGroupModel()).isChildBranch(n2) && ((ParaGroupModel)this.rootModel).siblingNames != null && (groupImpl = this.root.getSibling(n2)) == null) {
                    groupImpl = ((ParaGroupModel)this.rootModel).get(string).createGroup(null, null, true);
                    groupImpl.branchIdx = n2;
                    this.root.addSibling(n2, groupImpl);
                    groupImpl.brother = this.root;
                }
            }
            groupImpl.grouping(jRecord, this.groupLevels[n4] - n, n2, string);
            if (this.bStopping) {
                throw new JRStopEngineException();
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof DSException && ((DSException)throwable).getPartMessKey() == 4007) {
                throw new DSException(4007);
            }
            SEDU.error(4008, throwable);
        }
    }

    @Override
    void setGroupLevels(Hashtable hashtable) {
        int n;
        int n2 = n = hashtable == null ? 0 : hashtable.size();
        if (n > 0) {
            this.branchIdxs = new int[n];
            this.groupLevels = new int[n];
            int n3 = 0;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                GroupModel groupModel = ((LeafGroupList)hashtable.get(string)).getLeafModel();
                this.branchIdxs[n3] = this.recordModel.isParallel() ? this.paraBuffer.getIndexByName(string) : n3;
                this.groupLevels[n3++] = groupModel.getGroupIndex();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isNoRecord() {
        ParallelGroupEngine parallelGroupEngine;
        if (!this.singleThread) {
            parallelGroupEngine = this;
            synchronized (parallelGroupEngine) {
                try {
                    while (!this.bNoRecord && this.count == 0 && (this.recordModel != null && this.recordModel.isParallel() || this.srcCursor.getCurrentEnd() == 0)) {
                        this.wait(200L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    SEDU.error(4016, interruptedException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    SEDU.error(4017, illegalArgumentException);
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    SEDU.error(4018, illegalMonitorStateException);
                }
            }
        }
        parallelGroupEngine = this;
        synchronized (parallelGroupEngine) {
            try {
                while (this.bNeedWait && !this.root.isBreak() && !this.bStopping) {
                    this.wait(200L);
                }
            }
            catch (InterruptedException interruptedException) {
                SEDU.error(4016, interruptedException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                SEDU.error(4017, illegalArgumentException);
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                SEDU.error(4018, illegalMonitorStateException);
            }
        }
        if (this.bNeedWait) {
            int n = this.root.getGroupType();
            if (n == 0) {
                this.bNoRecord = this.root.getAvailSubgroups().size() == 0;
            } else if (n == 1) {
                boolean bl = this.bNoRecord = ((LeafGroup)this.root).getRecordIndexs().size() == 0;
            }
        }
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "GroupEngine(ParallelGroupEngine) isNoRecord result is:" + this.bNoRecord);
        }
        return this.bNoRecord;
    }

    @Override
    public void clearMem() {
        if (this.paraBuffer != null) {
            try {
                this.paraBuffer.close();
            }
            catch (DSException dSException) {
                SEDU.error(4020, dSException);
            }
        }
        if (this.rootModel != null) {
            this.rootModel.clear();
        }
        this.root = null;
        this.formulaQueue = null;
        this.recordFormulas = null;
        this.recordFormulas2 = null;
        this.javaFormula = null;
        this.recordForGroupBreak = null;
        this.globalRecord = null;
        this.fetchRecord = null;
        this.leafRecord = null;
        this.groupQueryTask = null;
        this.jgrpl = null;
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "Group Engine clear memory! this group engine is " + this);
        }
    }

    @Override
    public void clear() {
        if (this.paraBuffer != null) {
            try {
                this.paraBuffer.close();
            }
            catch (DSException dSException) {
                SEDU.error(4021, dSException);
            }
        }
        this.formulaQueue = null;
        this.recordFormulas = null;
        this.recordFormulas2 = null;
        this.javaFormula = null;
        this.recordForGroupBreak = null;
        this.globalRecord = null;
        this.fetchRecord = null;
        this.leafRecord = null;
        if (this.rootModel != null) {
            this.rootModel.clear();
        }
        if (this.root != null) {
            this.root.clear();
        }
        this.groupQueryTask = null;
        this.jgrpl = null;
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "Group Engine clear! this group engine is " + this);
        }
    }
}

