/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.groupengine;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import jet.connect.DbChar;
import jet.connect.DbInteger;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.dataengine.groupengine.GroupBreaker;
import jet.dataengine.groupengine.GroupModel;
import jet.dataengine.util.DSLog;

public class RangGroupBreaker
implements GroupBreaker {
    public static final int BETWEEN = 0;
    public static final int IN = 1;
    public static final int GREATER = 2;
    public static final int LESS = 3;
    public static final int EQUAL = 4;
    public static final int NOT = Integer.MIN_VALUE;
    private static final String CHAR_DESC = "between";
    private static final String INTEGER_DESC = "in";
    private static final String SEDU = ">";
    private static final String Z = "<";
    private static final String append = "=";
    private static final String clone = "not between";
    private static final String compareTo = "not in";
    private static final String elementAt = "<=";
    private static final String equals = ">=";
    private static final String equalsIgnoreCase = "!=";
    GroupModel model;
    int[] oper;
    String[] values;
    String[][] rang;
    DbInteger orderValue = new DbInteger(DbValue.INTEGER_DESC);
    DbChar groupName = new DbChar(DbValue.CHAR_DESC);
    DbValue temp = null;
    private static DSLog error = DSLog.getDSLog(RangGroupBreaker.class.getName());
    private static String execGroupName = ",";

    public RangGroupBreaker(GroupModel groupModel) {
        this.model = groupModel;
    }

    public static int getDefaultOperator() {
        return 4;
    }

    public static int[] getAvailableOperators() {
        int[] nArray = new int[]{0, 2, 3, 4, Integer.MIN_VALUE, -2147483646, -2147483645, -2147483644};
        return nArray;
    }

    public static int getOperatorByName(String string) {
        int n;
        if (string.equals(CHAR_DESC)) {
            n = 0;
        } else if (string.equals(INTEGER_DESC)) {
            n = 1;
        } else if (string.equals(SEDU)) {
            n = 2;
        } else if (string.equals(Z)) {
            n = 3;
        } else if (string.equals(append)) {
            n = 4;
        } else if (string.equals(clone)) {
            n = Integer.MIN_VALUE;
        } else if (string.equals(compareTo)) {
            n = -2147483647;
        } else if (string.equals(elementAt)) {
            n = -2147483646;
        } else if (string.equals(equals)) {
            n = -2147483645;
        } else if (string.equals(equalsIgnoreCase)) {
            n = -2147483644;
        } else {
            throw new RuntimeException("Illegal operator name:" + string);
        }
        return n;
    }

    public static String getPresentationName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = CHAR_DESC;
                break;
            }
            case 1: {
                string = INTEGER_DESC;
                break;
            }
            case 2: {
                string = SEDU;
                break;
            }
            case 3: {
                string = Z;
                break;
            }
            case 4: {
                string = append;
                break;
            }
            case -2147483648: {
                string = clone;
                break;
            }
            case -2147483647: {
                string = compareTo;
                break;
            }
            case -2147483646: {
                string = elementAt;
                break;
            }
            case -2147483645: {
                string = equals;
                break;
            }
            case -2147483644: {
                string = equalsIgnoreCase;
                break;
            }
            default: {
                throw new RuntimeException("Illegal operator type:" + n);
            }
        }
        return string;
    }

    public static int getOprandCount(int n) {
        int n2;
        switch (n) {
            case -2147483648: 
            case 0: {
                n2 = 2;
                break;
            }
            case -2147483647: 
            case -2147483646: 
            case -2147483645: 
            case -2147483644: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 1;
                break;
            }
            default: {
                throw new RuntimeException("Illegal operator type:" + n);
            }
        }
        return n2;
    }

    public static String[] getStringForOprands(int n, Vector vector) {
        String[] stringArray = new String[RangGroupBreaker.getOprandCount(n)];
        switch (n) {
            case -2147483648: 
            case 0: {
                stringArray[0] = vector.elementAt(0).toString();
                stringArray[1] = vector.elementAt(1).toString();
                break;
            }
            case -2147483647: 
            case 1: {
                for (int i = 0; i < vector.size(); ++i) {
                    stringArray[0] = stringArray[0] + (i > 0 ? execGroupName : "") + vector.elementAt(i).toString();
                }
                break;
            }
            case -2147483646: 
            case -2147483645: 
            case -2147483644: 
            case 2: 
            case 3: 
            case 4: {
                stringArray[0] = vector.firstElement().toString();
                break;
            }
            default: {
                throw new RuntimeException("Illegal operator type:" + n);
            }
        }
        return stringArray;
    }

    public static boolean checkString(int n, String string) {
        boolean bl = false;
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                try {
                    Integer.parseInt(string);
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                    error.error(4072, numberFormatException);
                }
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                try {
                    Double.valueOf(string);
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                    error.error(4073, numberFormatException);
                }
                break;
            }
            case -7: {
                bl = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false");
                break;
            }
            case 91: {
                try {
                    Date date = new SimpleDateFormat("yyyy-MM-dd").parse(string);
                    bl = date != null;
                }
                catch (ParseException parseException) {
                    error.error(4074, parseException);
                }
                break;
            }
            case 92: {
                try {
                    Date date = new SimpleDateFormat("hh:mm:ss").parse(string);
                    bl = date != null;
                }
                catch (ParseException parseException) {
                    error.error(4075, parseException);
                }
                break;
            }
            case 93: {
                try {
                    Date date = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse(string);
                    bl = date != null;
                }
                catch (ParseException parseException) {
                    error.error(4076, parseException);
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                bl = string.length() > 1 && string.indexOf(34) == 0 && string.indexOf(34, 1) == string.length() - 1;
                break;
            }
            default: {
                throw new RuntimeException("Unknown sqlType : " + n);
            }
        }
        return bl;
    }

    @Override
    public DbValue execOrderValue(Record record) {
        DbValue dbValue = this.model.specfunc != null ? record.getCell(this.model.specfunc) : record.getCell(this.model.preprocess);
        if (this.model.isGroupByDeny()) {
            dbValue.setNull();
        }
        this.orderValue.set(this.oper.length);
        block7: for (int i = 0; i < this.oper.length; ++i) {
            boolean bl = false;
            int n = this.oper[i] & Integer.MAX_VALUE;
            if ((this.oper[i] & Integer.MIN_VALUE) != 0) {
                bl = true;
            }
            switch (n) {
                case 2: {
                    int n2 = this.CHAR_DESC(i, 0, dbValue);
                    if (n2 == 1) {
                        if (bl) continue block7;
                        this.orderValue.set(i);
                        return this.orderValue;
                    }
                    if (!bl) continue block7;
                    this.orderValue.set(i);
                    return this.orderValue;
                }
                case 3: {
                    int n2 = this.CHAR_DESC(i, 0, dbValue);
                    if (n2 == -1) {
                        if (bl) continue block7;
                        this.orderValue.set(i);
                        return this.orderValue;
                    }
                    if (!bl) continue block7;
                    this.orderValue.set(i);
                    return this.orderValue;
                }
                case 4: {
                    int n2 = this.CHAR_DESC(i, 0, dbValue);
                    if (n2 == 0) {
                        if (bl) continue block7;
                        this.orderValue.set(i);
                        return this.orderValue;
                    }
                    if (!bl) continue block7;
                    this.orderValue.set(i);
                    return this.orderValue;
                }
                case 1: {
                    int n2;
                    for (int j = 0; j < this.rang[i].length; ++j) {
                        n2 = this.CHAR_DESC(i, j, dbValue);
                        if (n2 != 0 || bl) continue;
                        this.orderValue.set(i);
                        return this.orderValue;
                    }
                    if (!bl) continue block7;
                    this.orderValue.set(i);
                    return this.orderValue;
                }
                case 0: {
                    int n2 = this.CHAR_DESC(i, 0, dbValue);
                    if (!(n2 != 0 && n2 != 1 || (n2 = this.CHAR_DESC(i, 1, dbValue)) != 0 && n2 != -1)) {
                        if (bl) continue block7;
                        this.orderValue.set(i);
                        return this.orderValue;
                    }
                    if (!bl) continue block7;
                    this.orderValue.set(i);
                    return this.orderValue;
                }
                default: {
                    throw new RuntimeException("Error operator : " + this.oper[i]);
                }
            }
        }
        return this.orderValue;
    }

    @Override
    public DbValue execGroupName(Record record) {
        DbValue dbValue = this.model.specfunc != null ? record.getCell(this.model.specfunc) : record.getCell(this.model.preprocess);
        if (this.model.isGroupByDeny()) {
            dbValue.setNull();
        }
        this.groupName.set(this.values[this.oper.length]);
        block7: for (int i = 0; i < this.oper.length; ++i) {
            boolean bl = false;
            int n = this.oper[i] & Integer.MAX_VALUE;
            if ((this.oper[i] & Integer.MIN_VALUE) != 0) {
                bl = true;
            }
            switch (n) {
                case 2: {
                    int n2 = this.CHAR_DESC(i, 0, dbValue);
                    if (n2 == 1) {
                        if (bl) continue block7;
                        this.groupName.set(this.values[i]);
                        return this.groupName;
                    }
                    if (!bl) continue block7;
                    this.groupName.set(this.values[i]);
                    return this.groupName;
                }
                case 3: {
                    int n2 = this.CHAR_DESC(i, 0, dbValue);
                    if (n2 == -1) {
                        if (bl) continue block7;
                        this.groupName.set(this.values[i]);
                        return this.groupName;
                    }
                    if (!bl) continue block7;
                    this.groupName.set(this.values[i]);
                    return this.groupName;
                }
                case 4: {
                    int n2 = this.CHAR_DESC(i, 0, dbValue);
                    if (n2 == 0) {
                        if (bl) continue block7;
                        this.groupName.set(this.values[i]);
                        return this.groupName;
                    }
                    if (!bl) continue block7;
                    this.groupName.set(this.values[i]);
                    return this.groupName;
                }
                case 1: {
                    int n2;
                    for (int j = 0; j < this.rang[i].length; ++j) {
                        n2 = this.CHAR_DESC(i, j, dbValue);
                        if (n2 != 0 || bl) continue;
                        this.groupName.set(this.values[i]);
                        return this.groupName;
                    }
                    if (!bl) continue block7;
                    this.groupName.set(this.values[i]);
                    return this.groupName;
                }
                case 0: {
                    int n2 = this.CHAR_DESC(i, 0, dbValue);
                    if (!(n2 != 0 && n2 != 1 || (n2 = this.CHAR_DESC(i, 1, dbValue)) != 0 && n2 != -1)) {
                        if (bl) continue block7;
                        this.groupName.set(this.values[i]);
                        return this.groupName;
                    }
                    if (!bl) continue block7;
                    this.groupName.set(this.values[i]);
                    return this.groupName;
                }
                default: {
                    throw new RuntimeException("Error operator : " + this.oper[i]);
                }
            }
        }
        return this.groupName;
    }

    @Override
    public DbValue getLastOrderValue() {
        return this.orderValue;
    }

    @Override
    public String otherName() {
        return this.values[this.oper.length];
    }

    @Override
    public boolean isDiscard(Record record) {
        return !this.model.keepSpecOther && this.values[this.oper.length].equals(this.execGroupName(record).toString());
    }

    private final synchronized int CHAR_DESC(int n, int n2, DbValue dbValue) {
        try {
            this.temp.setValue(this.rang[n][n2]);
        }
        catch (NullPointerException nullPointerException) {
            this.temp = (DbValue)dbValue.clone();
            this.temp.setValue(this.rang[n][n2]);
        }
        return dbValue.compareTo(this.temp);
    }

    public void setProperties(int[] nArray, String[] stringArray, String[][] stringArray2) {
        this.oper = nArray;
        this.values = stringArray;
        this.rang = stringArray2;
    }
}

