/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.groupengine.group;

import jet.dataengine.groupengine.group.IndexNode;
import jet.dataengine.groupengine.group.Key;

public class SortBlock {
    int length;
    boolean[] mode;
    Key[] keys = new Key[512];
    SortBlock prev;
    SortBlock next;
    IndexNode parent;

    SortBlock(boolean[] blArray) {
        this.mode = blArray;
    }

    public SortBlock getNext() {
        return this.next;
    }

    public int length() {
        return this.length;
    }

    public Key[] getKeys() {
        return this.keys;
    }

    void insert(Key key, int n) {
        boolean bl;
        if (n < 0 || n > this.length || n > 512) {
            throw new IndexOutOfBoundsException("Index " + n + " out of bound " + this.length);
        }
        if (n != this.length) {
            System.arraycopy(this.keys, n, this.keys, n + 1, this.length - n);
            bl = false;
        } else {
            bl = true;
        }
        this.keys[n] = key;
        ++this.length;
        if (bl && this.parent != null) {
            this.parent.update(this);
        }
    }

    SortBlock split() {
        if (this.length == 512) {
            SortBlock sortBlock = new SortBlock(this.mode);
            sortBlock.length = this.length = 256;
            System.arraycopy(this.keys, this.length, sortBlock.keys, 0, this.length);
            sortBlock.next = this.next;
            sortBlock.prev = this;
            if (this.next != null) {
                this.next.prev = sortBlock;
            }
            this.next = sortBlock;
            if (this.parent != null) {
                this.parent.update(this);
            }
            return sortBlock;
        }
        return null;
    }

    boolean isFull() {
        return this.length == 512;
    }

    int getIndex(Key key) {
        int n = 0;
        int n2 = this.length - 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = key.compare(this.keys[0], this.mode);
        if (n5 == -1) {
            return 0;
        }
        while (n <= n2) {
            n5 = key.compare(this.keys[n], this.mode);
            if (n5 == -1) {
                return n;
            }
            n5 = key.compare(this.keys[n2], this.mode);
            if (n5 == 0) {
                return -1;
            }
            if (n5 == 1) {
                return n2 + 1;
            }
            n3 = (n + n2) / 2;
            n5 = key.compare(this.keys[n3], this.mode);
            switch (n5) {
                case -1: {
                    n2 = --n3;
                    n4 = n5;
                    break;
                }
                case 0: {
                    return -1;
                }
                case 1: {
                    n = ++n3;
                    n4 = n5;
                }
            }
        }
        return n3;
    }
}

