/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.util;

import com.jinfonet.util.JRLog;
import java.io.InputStream;
import java.io.PrintStream;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import jet.dataengine.api.DSException;
import jet.dataengine.util.DSLog;
import jet.xml.model.ElementNode;
import jet.xml.model.FetchXMLStruct;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLTool {
    private static final String SEDU = "org.apache.xerces.parsers.SAXParser";
    private static final String append = "http://xml.org/sax/features/validation";
    private static final String createXMLReader = "http://apache.org/xml/features/validation/schema";
    private static final String equals = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String err = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static DSLog fetch = DSLog.getDSLog(XMLTool.class.getName());

    public static boolean isValid(String string, QName qName, String string2) throws DSException {
        ElementNode elementNode = FetchXMLStruct.fetch(string2);
        if (elementNode == null || qName == null) {
            throw new DSException(4112, new Object[]{string2, qName});
        }
        boolean bl = qName.getLocalPart().equals(elementNode.getName());
        return bl;
    }

    public static boolean validate(String string, String string2) throws DSException {
        boolean bl = true;
        try {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "XMLTool validate, schemaURI is :" + string + " instanceURI is: " + string2);
            }
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(new StreamSource(string));
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new ErrorHandlerImpl(System.err));
            validator.validate(new StreamSource(string2));
            return true;
        }
        catch (Exception exception) {
            throw new DSException(4125, new Object[]{exception.getMessage()});
        }
    }

    public static boolean validate(String string, InputStream inputStream) throws DSException {
        boolean bl = true;
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader(SEDU);
            xMLReader.setFeature(append, true);
            xMLReader.setFeature(createXMLReader, true);
            xMLReader.setFeature(equals, true);
            xMLReader.setProperty(err, string);
            xMLReader.setContentHandler(new DefaultHandler());
            xMLReader.setErrorHandler(new ErrorHandlerImpl(System.err));
            xMLReader.parse(new InputSource(inputStream));
            return true;
        }
        catch (Exception exception) {
            throw new DSException(2141, new Object[]{"An IOException  was thrown when do xml instance validate.Detail:" + exception.getMessage()});
        }
    }

    private static class ErrorHandlerImpl
    implements ErrorHandler {
        private PrintStream SEDU;

        ErrorHandlerImpl(PrintStream printStream) {
            this.SEDU = printStream;
        }

        private String SEDU(SAXParseException sAXParseException) {
            String string = sAXParseException.getSystemId();
            if (string == null) {
                string = "null";
            }
            String string2 = "URI=" + string + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
            return string2;
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.SEDU.println("Warning: " + this.SEDU(sAXParseException));
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            String string = "Error: " + this.SEDU(sAXParseException);
            throw new SAXException(string);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            String string = "Fatal Error: " + this.SEDU(sAXParseException);
            throw new SAXException(string);
        }
    }
}

