/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.util.dbresource.types;

import java.io.File;
import java.util.Hashtable;
import jet.dataengine.api.DSException;
import jet.dataengine.util.dbresource.types.CompareTool;
import jet.dataengine.util.dbresource.types.DBResourceCache;
import jet.dataengine.util.dbresource.types.DBResourceImpl;
import jet.dataengine.util.dbresource.types.DBVersion;
import jet.dataengine.util.dbresource.types.JDBResource;
import jet.dataengine.util.dbresource.types.LoadAndSaveXmlResource;
import jet.dataengine.util.dbresource.types.ResourceContain;

public class DBResourceFactory {
    public static DBVersion getDBVersion(String string, String string2, String string3, String string4) throws DSException {
        return new DBVersion(string, string2, string3, string4);
    }

    public static JDBResource getDBResource(DBVersion dBVersion) throws DSException {
        DBResourceImpl dBResourceImpl = new DBResourceImpl(dBVersion);
        String string = dBVersion.getFileName();
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        dBResourceImpl.load();
        return dBResourceImpl;
    }

    public static JDBResource createDBResource(DBVersion dBVersion) throws DSException {
        String string = dBVersion.getFileName();
        DBResourceCache dBResourceCache = new DBResourceCache(dBVersion);
        return new DBResourceImpl(dBVersion, dBResourceCache);
    }

    public static void modifyDBResource(DBVersion dBVersion, DBVersion dBVersion2) throws DSException {
        if (!CompareTool.equal(dBVersion.getDatabaseName(), dBVersion2.getDatabaseName())) {
            throw new DSException(2603, new String[]{"" + dBVersion.getDatabaseName() + " and " + dBVersion2.getDatabaseName() + " not equal"});
        }
        LoadAndSaveXmlResource loadAndSaveXmlResource = new LoadAndSaveXmlResource();
        dBVersion.readFileList();
        ResourceContain resourceContain = new ResourceContain(dBVersion);
        resourceContain.readFileList();
        String string = dBVersion.getFileName();
        File file = new File(string);
        if (!file.exists()) {
            throw new DSException(2604);
        }
        DBResourceCache dBResourceCache = loadAndSaveXmlResource.loadResource(string);
        dBResourceCache.modify(dBVersion2.getKey());
        dBVersion.modifyResource(dBVersion2);
        resourceContain.modify(dBVersion2);
        loadAndSaveXmlResource.saveResource(string);
    }

    public static void remove(DBVersion dBVersion) throws DSException {
        ResourceContain resourceContain = new ResourceContain(dBVersion);
        dBVersion.readFileList();
        resourceContain.readFileList();
        String string = dBVersion.getFileName();
        File file = new File(string);
        if (!file.exists()) {
            throw new DSException(2605);
        }
        file.delete();
        dBVersion.remove();
        resourceContain.remove();
    }

    public static DBVersion[] getDatabaseResource(String string) throws DSException {
        ResourceContain resourceContain = new ResourceContain();
        return resourceContain.getDBVersionList(string);
    }

    public static Hashtable getAllDatabaseResource() throws DSException {
        ResourceContain resourceContain = new ResourceContain();
        return resourceContain.getResource();
    }
}

