/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.util.dbresource.types;

import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import jet.dataengine.api.DSException;
import jet.dataengine.util.dbresource.types.DBResourceCache;
import jet.dataengine.util.dbresource.types.DBVersion;
import jet.dataengine.util.dbresource.types.JDBResource;
import jet.dataengine.util.dbresource.types.LoadAndSaveXmlResource;
import jet.dataengine.util.dbresource.types.Mapping;
import jet.dataengine.util.dbresource.types.ResourceContain;

public class DBResourceImpl
implements JDBResource {
    private DBResourceCache SEDU;
    private DBVersion add;
    private ResourceContain append;
    private LoadAndSaveXmlResource get;
    private String getDBResourceCache;

    public DBResourceImpl(DBVersion dBVersion) throws DSException {
        this.add = dBVersion;
        this.add.readFileList();
        this.getDBResourceCache = dBVersion.getFileName();
        this.get = new LoadAndSaveXmlResource();
        this.append = new ResourceContain();
        this.append.readFileList();
    }

    public DBResourceImpl(DBVersion dBVersion, DBResourceCache dBResourceCache) throws DSException {
        this.SEDU = dBResourceCache;
        this.add = dBVersion;
        this.add.readFileList();
        this.getDBResourceCache = dBVersion.getFileName();
        this.get = new LoadAndSaveXmlResource();
        this.get.setDBResourceCache(dBResourceCache);
        this.append = new ResourceContain(dBVersion);
        this.append.readFileList();
    }

    @Override
    public void save() throws DSException {
        this.get.saveResource(this.getDBResourceCache);
    }

    private void check(int n) throws DSException {
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 70: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                break;
            }
            default: {
                throw new DSException(2606, new String[]{"" + n + ":isn't standard jdbc2.0 type"});
            }
        }
    }

    @Override
    public int[] get(String string, int n) throws DSException {
        return this.SEDU.get(string, n);
    }

    @Override
    public Object[][] getAllMapping() throws DSException {
        Hashtable hashtable = this.SEDU.getMapping().getMapping();
        int n = 0;
        Object[][] objectArray = new Object[this.SEDU.getMapping().getLength()][8];
        if (!hashtable.isEmpty()) {
            Set set = hashtable.keySet();
            for (Integer n2 : set) {
                Vector vector = (Vector)hashtable.get(n2);
                int n3 = vector.size();
                for (int i = 0; i < n3; ++i) {
                    Mapping.NamingT namingT = (Mapping.NamingT)vector.get(i);
                    objectArray[n][0] = n2;
                    objectArray[n][1] = namingT.getDataname();
                    objectArray[n][2] = namingT.getIsNull() == 0 ? new Boolean(false) : new Boolean(true);
                    objectArray[n][3] = new Integer(namingT.getJdbctype());
                    objectArray[n][4] = new Integer(namingT.getLength());
                    objectArray[n][5] = new Integer(namingT.getPrecision());
                    objectArray[n][6] = new Integer(namingT.getScale());
                    ++n;
                }
            }
            return objectArray;
        }
        throw new DSException(2607);
    }

    @Override
    public void set(int n, String string, int n2, int n3, int n4, int n5, int n6) throws DSException {
        this.check(n2);
        this.SEDU.add(n, string, n2, n3, n4, n5, n6);
    }

    @Override
    public void remove(String string, int n) throws DSException {
        this.SEDU.remove(string, n);
    }

    public String toString() {
        return this.SEDU.toString();
    }

    void load() throws DSException {
        this.add.readFileList();
        this.append.readFileList();
        this.get.loadResource(this.getDBResourceCache);
        this.SEDU = this.get.getDBResourceCache();
    }
}

