/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.util.dbresource.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jet.dataengine.api.DSException;
import jet.dataengine.api.EnvironmentPropertiesFactory;
import jet.dataengine.api.JEnvironmentProperties;
import jet.dataengine.util.dbresource.types.CompareTool;
import jet.dataengine.util.dbresource.types.ResourceContain;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DBVersion {
    private String SEDU;
    private String add;
    private String append;
    private String appendChild;
    private String available;
    private String createElement;
    private ResourceContain createNewFile;
    private String[] delete = new String[4];
    private final int equal = 1;
    private Hashtable exists = new Hashtable();
    final String filelistpath = "\\DatabaseResource";
    final String filelist = "\\FileList.xml";
    private DocumentBuilderFactory get;
    private DocumentBuilder getAbsolutePath;
    private Document getAttribute;

    public DBVersion(String string, String string2, String string3, String string4) throws DSException {
        this.SEDU = string;
        this.add = string2;
        this.append = string3;
        this.appendChild = string4;
        this.check();
        this.delete[0] = this.SEDU;
        this.delete[1] = this.add;
        this.delete[2] = this.append;
        this.delete[3] = this.appendChild;
        JEnvironmentProperties jEnvironmentProperties = EnvironmentPropertiesFactory.getEnviromentProperties();
        this.createElement = jEnvironmentProperties.getHomePath();
        this.available = this.createElement + "\\DatabaseResource";
    }

    void modifyResource(DBVersion dBVersion) throws DSException {
        String string = null;
        DBVersion dBVersion22 = null;
        DBVersion dBVersion3 = null;
        if (!this.exists.isEmpty()) {
            Set set = this.exists.keySet();
            for (DBVersion dBVersion22 : set) {
                if (CompareTool.equal(dBVersion22, dBVersion)) {
                    return;
                }
                if (!CompareTool.equal(this, dBVersion22)) continue;
                string = (String)this.exists.get(dBVersion22);
                dBVersion3 = dBVersion22;
            }
            this.exists.remove(dBVersion3);
            this.exists.put(dBVersion, string);
        }
        this.writeFile();
    }

    String[] getKey() {
        return this.delete;
    }

    public Hashtable getMapping() {
        return null;
    }

    void writeFile() throws DSException {
        this.get = DocumentBuilderFactory.newInstance();
        this.getAbsolutePath = null;
        try {
            this.getAbsolutePath = this.get.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DSException(2608, new String[]{parserConfigurationException.getMessage()});
        }
        this.getAttribute = this.getAbsolutePath.newDocument();
        Element element = this.getAttribute.createElement("root");
        this.getAttribute.appendChild(element);
        if (!this.exists.isEmpty()) {
            Object object;
            Object object2;
            Object object32;
            Set set = this.exists.keySet();
            for (Object object32 : set) {
                object2 = this.getAttribute.createElement("databaseinformation");
                object2.setAttribute("databasename", ((DBVersion)object32).getDatabaseName());
                object2.setAttribute("databaseversion", ((DBVersion)object32).getDatabaseVersion());
                object2.setAttribute("driver", ((DBVersion)object32).getDriver());
                object2.setAttribute("driverversion", ((DBVersion)object32).getDriverVersion());
                element.appendChild((Node)object2);
                object = this.getAttribute.createElement("pathfilename");
                object.setAttribute("filename", (String)this.exists.get(object32));
                object2.appendChild((Node)object);
            }
            object32 = TransformerFactory.newInstance();
            try {
                object2 = ((TransformerFactory)object32).newTransformer();
                object = new DOMSource(this.getAttribute);
                File file = new File(this.available, "\\FileList.xml");
                if (file.exists()) {
                    file.delete();
                } else {
                    file.createNewFile();
                }
                StreamResult streamResult = new StreamResult(file);
                ((Transformer)object2).transform((Source)object, streamResult);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new DSException(2609, new String[]{transformerConfigurationException.getMessage()});
            }
            catch (TransformerException transformerException) {
                throw new DSException(2610, new String[]{transformerException.getMessage()});
            }
            catch (IOException iOException) {
                throw new DSException(2611, new String[]{iOException.getMessage()});
            }
        }
    }

    private Hashtable SEDU(String string) throws DSException {
        this.get = DocumentBuilderFactory.newInstance();
        try {
            this.getAbsolutePath = this.get.newDocumentBuilder();
            this.getAttribute = this.getAbsolutePath.parse(string);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DSException(2612, new String[]{parserConfigurationException.getMessage()});
        }
        catch (SAXException sAXException) {
            throw new DSException(2613, new String[]{sAXException.getMessage()});
        }
        catch (IOException iOException) {
            throw new DSException(2614, new String[]{iOException.getMessage()});
        }
        Element element = this.getAttribute.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("databaseinformation");
        String string2 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            DBVersion dBVersion = new DBVersion(element2.getAttribute("databasename"), element2.getAttribute("databaseversion"), element2.getAttribute("driver"), element2.getAttribute("driverversion"));
            NodeList nodeList2 = element2.getElementsByTagName("pathfilename");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element3 = (Element)nodeList2.item(j);
                string2 = element3.getAttribute("filename");
            }
            this.exists.put(dBVersion, string2);
        }
        return this.exists;
    }

    String getFileName() throws DSException {
        String string = "";
        if (!this.exists.isEmpty()) {
            Set set = this.exists.keySet();
            for (DBVersion dBVersion : set) {
                if (!CompareTool.equal(dBVersion, this)) continue;
                string = (String)this.exists.get(dBVersion);
            }
        }
        return string;
    }

    void readFileList() throws DSException {
        File file = new File(this.available, "\\FileList.xml");
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                throw new DSException(2615, new String[]{iOException.getMessage()});
            }
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            if (fileInputStream.available() == 0) {
                String string = this.createElement + "\\DatabaseResource" + "\\" + this.equal + ".xml";
                this.exists.put(this, string);
                this.writeFile();
                return;
            }
        }
        catch (IOException iOException) {
            throw new DSException(2616, new String[]{iOException.getMessage()});
        }
        this.exists = this.SEDU(this.available + "\\FileList.xml");
        this.add();
    }

    void add() throws DSException {
        boolean bl = true;
        int n = 0;
        DBVersion dBVersion2 = null;
        if (!this.exists.isEmpty()) {
            int n2;
            Set set = this.exists.keySet();
            for (DBVersion dBVersion2 : set) {
                if (CompareTool.equal(dBVersion2, this)) {
                    bl = false;
                    break;
                }
                n2 = this.add((String)this.exists.get(dBVersion2));
                if (n >= n2) continue;
                n = n2;
            }
            if (bl) {
                n2 = n + 1;
                String string = this.createElement + "\\DatabaseResource" + "\\" + n2 + ".xml";
                this.exists.put(this, string);
                this.writeFile();
            }
        }
    }

    private int add(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.lastIndexOf("\\");
        int n2 = stringBuffer.indexOf(".");
        String string2 = stringBuffer.substring(n + 1, n2);
        Integer n3 = new Integer(string2);
        return n3;
    }

    private void append() {
        File file = new File("");
        this.createElement = file.getAbsolutePath();
    }

    public String getDatabaseName() {
        return this.SEDU;
    }

    public String getDatabaseVersion() {
        return this.add;
    }

    public String getDriver() {
        return this.append;
    }

    public String getDriverVersion() {
        return this.appendChild;
    }

    public String getResourceName() {
        return this.SEDU + this.add + this.append + this.appendChild;
    }

    private void check() throws DSException {
        if (this.SEDU == null || this.SEDU.length() < 1) {
            throw new DSException(2617, new String[]{"" + this.SEDU + "is null"});
        }
        if (this.add == null || this.add.length() < 1) {
            throw new DSException(2618, new String[]{"" + this.add + " is null"});
        }
        if (this.append == null || this.append.length() < 1) {
            throw new DSException(2619, new String[]{"" + this.append + "is null"});
        }
        if (this.appendChild == null || this.appendChild.length() < 1) {
            throw new DSException(2620, new String[]{"" + this.appendChild + " is null"});
        }
    }

    void remove() throws DSException {
        if (!this.exists.isEmpty()) {
            Set set = this.exists.keySet();
            for (DBVersion dBVersion : set) {
                if (!CompareTool.equal(this, dBVersion)) continue;
                this.exists.remove(dBVersion);
                break;
            }
            this.writeFile();
        }
    }

    public String toString() {
        String string = "";
        if (!this.exists.isEmpty()) {
            Set set = this.exists.keySet();
            for (DBVersion dBVersion : set) {
                string = string + dBVersion + ":" + this.exists.get(dBVersion) + "\n";
            }
        }
        return string;
    }
}

