/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.util.dbresource.types.dbResourceUI;

import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import jet.dataengine.api.DSException;
import jet.dataengine.util.dbresource.types.DBResourceFactory;
import jet.dataengine.util.dbresource.types.DBVersion;
import jet.dataengine.util.dbresource.types.JDBResource;

class DBResourceTree {
    final int DEPTHROOT = 2;
    final int DEPTHSUB = 1;
    final int DEPTH = 0;
    int select;
    protected DefaultMutableTreeNode rootNode;
    protected DefaultTreeModel treeModel;
    protected JTree tree;
    private Toolkit SEDU = Toolkit.getDefaultToolkit();
    StringBuffer buffer;
    String newdatabasename;
    String newdatabaseversion;
    String newdrivername;
    String newdriverversion;

    public DBResourceTree() throws DSException {
        this.dbResourceTreeModel();
        this.initTree();
    }

    void initTree() throws DSException {
        Hashtable hashtable = DBResourceFactory.getAllDatabaseResource();
        if (hashtable == null) {
            return;
        }
        Set set = hashtable.keySet();
        for (String string : set) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.addObject(null, string);
            Vector vector = (Vector)hashtable.get(string);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                DBVersion dBVersion = (DBVersion)vector.get(i);
                String string2 = dBVersion.getDatabaseName() + "---" + dBVersion.getDatabaseVersion() + "---" + dBVersion.getDriver() + "---" + dBVersion.getDriverVersion();
                this.addObject(defaultMutableTreeNode, string2);
            }
        }
    }

    Vector parseDBVersion() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = this.buffer.indexOf("---", n)) == -1) {
                vector.add(this.buffer.substring(n));
                return vector;
            }
            vector.add(this.buffer.substring(n, n2));
            n = n2 + 3;
        }
    }

    public void dbResourceTreeModel() {
        this.rootNode = new DefaultMutableTreeNode("DBResource");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeModel.addTreeModelListener(new MyTreeModelListener());
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.tree.addMouseListener(new MouseList(this.tree));
    }

    JTree getJTree() {
        return this.tree;
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.treeModel.reload();
    }

    public void removeCurrentNode() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            int n = defaultMutableTreeNode.getChildCount();
            MutableTreeNode mutableTreeNode = (MutableTreeNode)defaultMutableTreeNode.getParent();
            if (mutableTreeNode != null) {
                this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
                if (n == 1) {
                    this.treeModel.removeNodeFromParent(mutableTreeNode);
                }
                return;
            }
        }
        this.SEDU.beep();
    }

    public DefaultMutableTreeNode addObject(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        TreePath treePath = this.tree.getSelectionPath();
        defaultMutableTreeNode = treePath == null ? this.rootNode : (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return this.addObject(defaultMutableTreeNode, object, true);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        return this.addObject(defaultMutableTreeNode, object, false);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode defaultMutableTreeNode, Object object, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = this.rootNode;
        }
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        if (bl) {
            this.tree.scrollPathToVisible(new TreePath(defaultMutableTreeNode2.getPath()));
        }
        return defaultMutableTreeNode2;
    }

    private static void DEPTH() throws DSException {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("DBResource");
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    class ResourcePopupMenu
    extends JPopupMenu
    implements ActionListener {
        JMenuItem add;
        JMenuItem modify;
        JMenuItem remove;
        int select;

        public ResourcePopupMenu(int n) {
            this.select = n;
            this.add = new JMenuItem("Add");
            this.modify = new JMenuItem("Modify");
            this.remove = new JMenuItem("Remove");
            this.add.addActionListener(this);
            this.modify.addActionListener(this);
            this.remove.addActionListener(this);
            if (n == 2) {
                this.modify.setEnabled(false);
                this.remove.setEnabled(false);
            } else {
                if (n == 1) {
                    this.setEnabled(false);
                    return;
                }
                if (n == 0) {
                    this.add.setEnabled(false);
                }
            }
            this.add(this.add);
            this.add(this.modify);
            this.add(this.remove);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.add) {
                try {
                    this.addDBResource();
                }
                catch (DSException dSException) {
                    this.add(dSException);
                }
            } else if (actionEvent.getSource() == this.modify) {
                try {
                    this.modifyDlg();
                }
                catch (DSException dSException) {
                    this.add(dSException);
                }
            } else if (actionEvent.getSource() == this.remove) {
                try {
                    this.SEDU(this.select);
                }
                catch (DSException dSException) {
                    this.add(dSException);
                }
            }
        }

        private void SEDU(int n) throws DSException {
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("Make sure you remove it?"));
            if (JOptionPane.showConfirmDialog(null, jPanel, "Remove", 2, -1) == 0) {
                if (n == 2) {
                    DBResourceTree.this.clear();
                } else if (n == 0) {
                    Vector vector = DBResourceTree.this.parseDBVersion();
                    if (vector.size() > 1) {
                        String string = (String)vector.get(0);
                        String string2 = (String)vector.get(1);
                        String string3 = (String)vector.get(2);
                        String string4 = (String)vector.get(3);
                        DBVersion dBVersion = new DBVersion(string, string2, string3, string4);
                        DBResourceFactory.remove(dBVersion);
                    }
                    DBResourceTree.this.removeCurrentNode();
                }
            }
        }

        private void add(DSException dSException) {
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel(dSException.toString()));
            JOptionPane.showMessageDialog(null, jPanel, "Message", 0);
        }

        void addDBResource() throws DSException {
            JPanel jPanel = new JPanel();
            JTextField jTextField = new JTextField(10);
            JTextField jTextField2 = new JTextField(10);
            JTextField jTextField3 = new JTextField(10);
            JTextField jTextField4 = new JTextField(10);
            JScrollPane jScrollPane = new JScrollPane(jTextField);
            JScrollPane jScrollPane2 = new JScrollPane(jTextField2);
            JScrollPane jScrollPane3 = new JScrollPane(jTextField3);
            JScrollPane jScrollPane4 = new JScrollPane(jTextField4);
            jPanel.setLayout(new GridLayout(2, 2));
            jPanel.add(new JLabel("databaseName:"));
            jPanel.add(jScrollPane);
            jPanel.add(new JLabel("databaseVersion:"));
            jPanel.add(jScrollPane2);
            jPanel.add(new JLabel("driverName:"));
            jPanel.add(jScrollPane3);
            jPanel.add(new JLabel("driverVersion:"));
            jPanel.add(jScrollPane4);
            if (JOptionPane.showConfirmDialog(null, jPanel, "Modify", 2, -1) == 0) {
                String string;
                String string2;
                String string3;
                String string4 = jTextField.getText().trim();
                DBVersion dBVersion = new DBVersion(string4, string3 = jTextField2.getText().trim(), string2 = jTextField3.getText().trim(), string = jTextField4.getText().trim());
                if (DBResourceFactory.getDBResource(dBVersion) == null) {
                    JDBResource jDBResource = DBResourceFactory.createDBResource(dBVersion);
                    jDBResource.save();
                }
                DefaultMutableTreeNode defaultMutableTreeNode = DBResourceTree.this.addObject(null, string4);
                DBResourceTree.this.addObject(defaultMutableTreeNode, string4 + "---" + string3 + "---" + string2 + "---" + string);
            }
        }

        void modifyDlg() throws DSException {
            JPanel jPanel = new JPanel();
            Vector vector = DBResourceTree.this.parseDBVersion();
            String[] stringArray = new String[]{"databasename", "databaseversion", "drivername", "driverversion"};
            int n = vector.size();
            String string = (String)vector.get(0);
            String string2 = (String)vector.get(1);
            String string3 = (String)vector.get(2);
            String string4 = (String)vector.get(3);
            DBVersion dBVersion = new DBVersion(string, string2, string3, string4);
            JTextField jTextField = new JTextField(10);
            JTextField jTextField2 = new JTextField(10);
            JTextField jTextField3 = new JTextField(10);
            JTextField jTextField4 = new JTextField(10);
            jTextField.setText(string);
            jTextField.setEditable(false);
            jTextField2.setText(string2);
            jTextField3.setText(string3);
            jTextField4.setText(string4);
            JScrollPane jScrollPane = new JScrollPane(jTextField);
            JScrollPane jScrollPane2 = new JScrollPane(jTextField2);
            JScrollPane jScrollPane3 = new JScrollPane(jTextField3);
            JScrollPane jScrollPane4 = new JScrollPane(jTextField4);
            jPanel.setLayout(new GridLayout(2, 2));
            jPanel.add(jScrollPane);
            jPanel.add(new JLabel("databaseName:"));
            jPanel.add(jScrollPane2);
            jPanel.add(new JLabel("databaseVersion:"));
            jPanel.add(jScrollPane3);
            jPanel.add(new JLabel("driverName:"));
            jPanel.add(jScrollPane4);
            jPanel.add(new JLabel("driverVersion:"));
            if (JOptionPane.showConfirmDialog(null, jPanel, "Modify", 2, -1) == 0) {
                DBResourceTree.this.newdatabasename = jTextField.getText().trim();
                DBResourceTree.this.newdatabaseversion = jTextField2.getText().trim();
                DBResourceTree.this.newdrivername = jTextField3.getText().trim();
                DBResourceTree.this.newdriverversion = jTextField4.getText().trim();
                DBVersion dBVersion2 = new DBVersion(DBResourceTree.this.newdatabasename, DBResourceTree.this.newdatabaseversion, DBResourceTree.this.newdrivername, DBResourceTree.this.newdriverversion);
                DBResourceFactory.modifyDBResource(dBVersion, dBVersion2);
            }
        }
    }

    class MyTreeModelListener
    implements TreeModelListener {
        MyTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
            try {
                int n = treeModelEvent.getChildIndices()[0];
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            System.out.println("The user has finished editing the node.");
            System.out.println("New value: " + defaultMutableTreeNode.getUserObject());
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    class MouseList
    implements MouseListener {
        JTree jtree;

        public MouseList(JTree jTree) {
            this.jtree = jTree;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == this.jtree) {
                if (mouseEvent.getButton() == 3) {
                    ResourcePopupMenu resourcePopupMenu = new ResourcePopupMenu(DBResourceTree.this.select);
                    resourcePopupMenu.show(this.jtree, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == this.jtree) {
                TreePath treePath;
                if (mouseEvent.getButton() == 1 && (treePath = this.jtree.getSelectionPath()) != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    DBResourceTree.this.buffer = new StringBuffer(defaultMutableTreeNode.toString());
                    DBResourceTree.this.select = defaultMutableTreeNode.getDepth();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

