/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.util.externalsort;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.config.DbBufferConfig;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.util.externalsort.CellComparator;
import jet.dataengine.util.externalsort.RecordComparator;
import jet.dataengine8.dbbuffer.DbBufferDataImpl;
import jet.dataengine8.dbbuffer.RecordImpl;
import jet.dataengine8.dbbuffer.RecordModel;
import jet.dataengine8.dbbuffer.RecordTool;

public class MergerSort {
    public static final int MINMEMORYSIZE = 4;
    public static final int ASC = 1;
    public static final int DESC = -1;
    private final RecordModelInfo SEDU;
    private final int[] active;
    private final int add;
    private final int addRecord;
    private final JRecord clone;
    private final DbValue[][] close;
    private final RecordComparator compare;
    private final CellComparator countColumns;
    private final int createCursor = 2048;
    private final int createRecord = 2;
    private int currentTimeMillis = 0;
    private List finish = new ArrayList(20);
    private final int get;
    private final int getCell;
    private final int getColDescs;
    private DbBufferDataImpl getPosition;
    private boolean getRecordLen = true;
    DbBufferConfig dbBufferConfig;

    public MergerSort(RecordModelInfo recordModelInfo, int n, int[] nArray, DbBufferConfig dbBufferConfig) {
        this.SEDU = recordModelInfo;
        this.active = nArray;
        this.add = Math.max(n, 4);
        this.compare = new RecordComparator(nArray);
        this.countColumns = new CellComparator(nArray);
        this.dbBufferConfig = dbBufferConfig;
        long l = System.currentTimeMillis();
        this.get = RecordTool.getRecordLen(this.SEDU.getColDescs());
        this.getCell = Math.max(2048 / this.get, 1);
        this.addRecord = (int)(0x100000L * (long)this.add / (long)this.get);
        this.getColDescs = 512 * this.add / 2;
        RecordModel recordModel = new RecordModel(this.SEDU);
        this.clone = new RecordImpl(recordModel);
        this.close = new DbValue[this.addRecord][];
        int n2 = recordModel.countColumns();
        for (int i = 0; i < this.addRecord; ++i) {
            this.close[i] = new DbValue[n2];
        }
    }

    public void appendRecord(JRecord jRecord) throws DSException {
        DbValue[] dbValueArray = this.close[this.currentTimeMillis];
        if (this.getRecordLen) {
            int n = dbValueArray.length;
            for (int i = 0; i < n; ++i) {
                dbValueArray[i] = (DbValue)jRecord.getCell(i).clone();
            }
        } else {
            int n = dbValueArray.length;
            for (int i = 0; i < n; ++i) {
                dbValueArray[i].set(jRecord.getCell(i));
            }
        }
        ++this.currentTimeMillis;
        if (this.currentTimeMillis == this.addRecord) {
            Arrays.sort(this.close, this.countColumns);
            this.SEDU(this.close, 0, this.currentTimeMillis);
            this.currentTimeMillis = 0;
        }
    }

    private void SEDU(DbValue[][] dbValueArray, int n, int n2) throws DSException {
        DbBufferDataImpl dbBufferDataImpl = new DbBufferDataImpl(this.SEDU, this.getCell, 2L, this.dbBufferConfig);
        for (int i = 0; i < n2; ++i) {
            DbValue[] dbValueArray2 = dbValueArray[i];
            int n3 = dbValueArray2.length;
            for (int j = 0; j < n3; ++j) {
                this.clone.getCell(j).set(dbValueArray2[j]);
            }
            dbBufferDataImpl.addRecord(this.clone);
        }
        dbBufferDataImpl.finish();
        dbBufferDataImpl.hibernate();
        this.finish.add(dbBufferDataImpl);
    }

    public JDbBufferCursor finish() throws DSException {
        int n;
        if (this.currentTimeMillis > 0) {
            Arrays.sort(this.close, 0, this.currentTimeMillis, this.countColumns);
            this.SEDU(this.close, 0, this.currentTimeMillis);
        }
        if ((n = this.finish.size()) == 1) {
            this.getPosition = (DbBufferDataImpl)this.finish.get(0);
            this.getPosition.active();
            this.finish = null;
            return this.getPosition.createCursor();
        }
        if (n == 0) {
            this.getPosition = new DbBufferDataImpl(this.SEDU, this.getCell, 2L, this.dbBufferConfig);
            this.finish = null;
            return this.getPosition.createCursor();
        }
        int n2 = n / this.getColDescs + (n % this.getColDescs == 0 ? 0 : 1);
        DbBufferDataImpl[] dbBufferDataImplArray = new DbBufferDataImpl[n];
        this.finish.toArray(dbBufferDataImplArray);
        this.finish = null;
        DbBufferDataImpl[] dbBufferDataImplArray2 = new DbBufferDataImpl[n2];
        while (true) {
            for (int i = 1; i <= n2; ++i) {
                int n3 = this.getColDescs;
                if (i * this.getColDescs > dbBufferDataImplArray.length) {
                    n3 = dbBufferDataImplArray.length - (i - 1) * this.getColDescs;
                }
                DbBufferDataImpl[] dbBufferDataImplArray3 = new DbBufferDataImpl[n3];
                int n4 = (i - 1) * this.getColDescs;
                for (int j = 0; j < n3; ++j) {
                    dbBufferDataImplArray3[j] = dbBufferDataImplArray[n4 + j];
                }
                dbBufferDataImplArray2[i - 1] = this.active(dbBufferDataImplArray3);
            }
            if (n2 == 1) break;
            n2 = n2 / this.getColDescs + (n2 % this.getColDescs == 0 ? 0 : 1);
            dbBufferDataImplArray = dbBufferDataImplArray2;
            dbBufferDataImplArray2 = new DbBufferDataImpl[n2];
        }
        this.getPosition = dbBufferDataImplArray2[0];
        this.getPosition.active();
        return this.getPosition.createCursor();
    }

    private DbBufferDataImpl active(DbBufferDataImpl[] dbBufferDataImplArray) throws DSException {
        int n;
        int n2 = dbBufferDataImplArray.length;
        Object[] objectArray = new Entry[n2];
        JDbBufferCursor[] jDbBufferCursorArray = new JDbBufferCursor[n2];
        for (int i = 0; i < n2; ++i) {
            DbBufferDataImpl dbBufferDataImpl = dbBufferDataImplArray[i];
            dbBufferDataImpl.active();
            jDbBufferCursorArray[i] = dbBufferDataImpl.createCursor();
            objectArray[i] = new Entry(i, this.compare);
            ((Entry)objectArray[i]).v = jDbBufferCursorArray[i].createRecord();
            jDbBufferCursorArray[i].next();
            ((Entry)objectArray[i]).v.setPosition(jDbBufferCursorArray[i].getPosition());
            ((Entry)objectArray[i]).v.refresh();
        }
        DbBufferDataImpl dbBufferDataImpl = new DbBufferDataImpl(this.SEDU, this.getCell, 2L, this.dbBufferConfig);
        Arrays.sort(objectArray);
        while (n2 > 1) {
            int n3 = ((Entry)objectArray[0]).segmtID;
            dbBufferDataImpl.addRecord(((Entry)objectArray[0]).v);
            if (jDbBufferCursorArray[n3].next()) {
                Object object = objectArray[0];
                ((Entry)object).v.setPosition(jDbBufferCursorArray[n3].getPosition());
                ((Entry)object).v.refresh();
                n = 0;
                for (n = 1; n < n2 && this.compare.compare(((Entry)object).v, ((Entry)objectArray[n]).v) > 0; ++n) {
                    objectArray[n - 1] = objectArray[n];
                }
                objectArray[n - 1] = object;
                continue;
            }
            --n2;
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = objectArray[i + 1];
            }
            objectArray[n2] = null;
        }
        dbBufferDataImpl.addRecord(((Entry)objectArray[0]).v);
        while (jDbBufferCursorArray[((Entry)objectArray[0]).segmtID].next()) {
            ((Entry)objectArray[0]).v.setPosition(jDbBufferCursorArray[((Entry)objectArray[0]).segmtID].getPosition());
            ((Entry)objectArray[0]).v.refresh();
            dbBufferDataImpl.addRecord(((Entry)objectArray[0]).v);
        }
        dbBufferDataImpl.finish();
        dbBufferDataImpl.hibernate();
        n = dbBufferDataImplArray.length;
        for (int i = 0; i < n; ++i) {
            jDbBufferCursorArray[i].close();
            dbBufferDataImplArray[i].close();
        }
        return dbBufferDataImpl;
    }

    public void close() throws DSException {
        this.getPosition.close();
    }

    private static class Entry
    implements Comparable {
        final int segmtID;
        JRecord v;
        private final Comparator SEDU;

        Entry(int n, Comparator comparator) {
            this.segmtID = n;
            this.SEDU = comparator;
        }

        public int compareTo(Object object) {
            return this.SEDU.compare(this.v, ((Entry)object).v);
        }
    }
}

