/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.xml;

import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.IOException;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jet.dataengine.api.DSException;
import jet.dataengine.api.datasource.xml.AttributeNode;
import jet.universe.xml.XMLElement;
import jet.universe.xml.XMLGlobalElement;
import jet.universe.xml.XMLLocalAttribute;
import jet.universe.xml.XMLLocalElement;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class FetchXMLSchema
extends DefaultHandler {
    private Stack SEDU;
    private XMLElement add;
    private static String equals = ":";

    @Override
    public void startDocument() throws SAXException {
        this.SEDU = new Stack();
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        XMLElement xMLElement = null;
        String string4 = "";
        int n = string3.indexOf(equals);
        if (n > -1) {
            string4 = string3.substring(0, n - 1);
        }
        QName qName = new QName(string, string2, string4);
        if (this.SEDU.isEmpty()) {
            xMLElement = new XMLGlobalElement(qName);
        } else {
            xMLElement = ((XMLElement)this.SEDU.peek()).getSubEltByName(qName);
            if (xMLElement == null) {
                xMLElement = new XMLLocalElement(qName);
                ((XMLElement)this.SEDU.peek()).add(xMLElement);
            }
        }
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getURI(i);
                String string6 = attributes.getLocalName(i);
                QName qName2 = new QName(string5, string6);
                AttributeNode[] attributeNodeArray = xMLElement.getAttributes();
                boolean bl = false;
                for (int j = 0; j < attributeNodeArray.length; ++j) {
                    if (!attributeNodeArray[j].getQName().equals(qName2)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                XMLLocalAttribute xMLLocalAttribute = new XMLLocalAttribute(qName2);
                xMLElement.add(xMLLocalAttribute);
            }
        }
        this.SEDU.push(xMLElement);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.add = (XMLElement)this.SEDU.pop();
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        if (JRLog.isError(2)) {
            JRLog.error(2, sAXParseException);
        }
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        if (JRLog.isError(2)) {
            JRLog.error(2, sAXParseException);
        }
    }

    XMLElement getRootNode() {
        return this.add;
    }

    public static XMLElement fetchRoot(InputSource inputSource) throws DSException {
        FetchXMLSchema fetchXMLSchema = new FetchXMLSchema();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputSource, (DefaultHandler)fetchXMLSchema);
        }
        catch (SAXParseException sAXParseException) {
            throw new DSException(4114, new Object[]{sAXParseException.getClass().getName(), sAXParseException.getMessage()}, (Throwable)sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new DSException(4115, new Object[]{sAXException.getClass().getName(), sAXException.getMessage()}, (Throwable)sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DSException(4116, new Object[]{parserConfigurationException.getClass().getName(), parserConfigurationException.getMessage()}, (Throwable)parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new DSException(4117, new Object[]{iOException.getClass().getName(), iOException.getMessage()}, (Throwable)iOException);
        }
        return fetchXMLSchema.getRootNode();
    }

    public static XMLElement fetchRoot(String string) throws DSException {
        FetchXMLSchema fetchXMLSchema = new FetchXMLSchema();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            String string2 = string.toLowerCase();
            if (string2.startsWith("file:") || string2.startsWith("ftp:") || string2.startsWith("http:") || string.startsWith("https:")) {
                sAXParser.parse(string, (DefaultHandler)fetchXMLSchema);
            } else {
                sAXParser.parse(new File(string), (DefaultHandler)fetchXMLSchema);
            }
        }
        catch (SAXParseException sAXParseException) {
            throw new DSException(4114, new Object[]{sAXParseException.getClass().getName(), sAXParseException.getMessage()}, (Throwable)sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new DSException(4115, new Object[]{sAXException.getClass().getName(), sAXException.getMessage()}, (Throwable)sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DSException(4116, new Object[]{parserConfigurationException.getClass().getName(), parserConfigurationException.getMessage()}, (Throwable)parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new DSException(4117, new Object[]{iOException.getClass().getName(), iOException.getMessage()}, (Throwable)iOException);
        }
        return fetchXMLSchema.getRootNode();
    }
}

