/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.xml;

import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.dataservice.relational.datasource.json.JsonStreamLoader;
import com.jinfonet.util.JRLog;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import jet.connect.DbValue;
import jet.controls.JetObject;
import jet.dataengine.api.DSException;
import jet.dataengine.api.SpecialFields;
import jet.dataengine.api.datasource.xml.SchemaURIInfo;
import jet.dataengine.api.datasource.xml.XMLModelSource;
import jet.dataengine.util.StringTransform;
import jet.dataengine.xml.FetchJsonSchema;
import jet.dataengine.xml.MetadataContainerImpl;
import jet.dataengine.xml.ModelCreatorImpl;
import jet.formula.JavaFormula;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.formula.util.RefObjectCollector;
import jet.jetc.ReadFailureException;
import jet.parameter.runtime.valuelist.DefaultFetcherContext;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.JetUParameter;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.exception.GenerateFormulasCodeException;
import jet.universe.exception.LoadJavaFormulaException;
import jet.universe.tools.ParseParametersForQueryFactory;
import jet.universe.xml.XMLElement;
import jet.util.CatalogKeyCreater;
import toolkit.db.DbTools;

public class JsonCreator
extends ModelCreatorImpl {
    XMLElement root;
    SchemaURIInfo sui;

    JsonCreator(XMLModelSource xMLModelSource) {
        this.mc = new MetadataContainerImpl();
        this.mc.setSchemaSource(xMLModelSource);
        this.sui = xMLModelSource.getURIInfo();
    }

    @Override
    public void process() throws DSException {
        if (this.root == null) {
            try {
                InputStream inputStream = JsonStreamLoader.load(this.sui.getURI(), this.sui.getUserName(), this.sui.getPassword(), this.sui.getMimeType());
                this.root = FetchJsonSchema.fetchRoot(inputStream);
                this.mc.add(this.root);
            }
            catch (Exception exception) {
                throw new DSException(4276, new Object[]{exception});
            }
        }
    }

    @Override
    public void process(JetUDatabase jetUDatabase, SpecialFields specialFields) throws DSException {
        if (this.root == null) {
            try {
                Object object6;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Vector vector = DbTools.getMappingNamesInRawSql(this.sui.getURI(), false);
                if (this.sui.getBody() != null) {
                    object5 = DbTools.getMappingNamesInRawSql(this.sui.getBody(), false);
                    object4 = ((Vector)object5).iterator();
                    while (object4.hasNext()) {
                        object3 = (String)object4.next();
                        if (vector.contains(object3)) continue;
                        vector.add(object3);
                    }
                }
                if (this.sui.getHeaders() != null) {
                    object5 = this.sui.getHeaders().values().iterator();
                    while (object5.hasNext()) {
                        object4 = DbTools.getMappingNamesInRawSql((String)object5.next(), false);
                        object3 = ((Vector)object4).iterator();
                        while (object3.hasNext()) {
                            object2 = (String)object3.next();
                            if (vector.contains(object2)) continue;
                            vector.add(object2);
                        }
                    }
                }
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, "Jsoncreator, parameter and formula names: " + vector);
                }
                object5 = this.CreateParseParametersForQuery(jetUDatabase, vector, specialFields);
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, "Jsoncreator, parameter and formula values: " + object5 + " original uri: " + this.sui.getURI() + " special fields: " + specialFields + " dataformat: " + this.sui.getDataFormat());
                }
                object4 = StringTransform.PFStoConstant(this.sui.getURI(), (Map)object5, specialFields, this.mc.getEditFormat());
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, "Jsoncreator, after transform value uri: " + (String)object4);
                }
                object3 = new Hashtable<Object, String>();
                if (this.sui.getHeaders() != null) {
                    for (Object object6 : this.sui.getHeaders().keySet()) {
                        if (JRLog.isTrace(5)) {
                            JRLog.trace(5, "Jsoncreator, original header name: " + (String)object6 + " and value: " + (String)this.sui.getHeaders().get(object6));
                        }
                        String string = StringTransform.PFStoConstant((String)this.sui.getHeaders().get(object6), (Map)object5, specialFields, this.sui.getDataFormat());
                        if (JRLog.isTrace(5)) {
                            JRLog.trace(5, "Jsoncreator, after transform header name: " + (String)object6 + " and value: " + string);
                        }
                        object3.put(object6, string);
                    }
                }
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, "Jsoncreator, original body: " + this.sui.getBody());
                }
                object2 = null;
                if (this.sui.getBody() != null) {
                    object2 = StringTransform.PFStoConstant(this.sui.getBody(), (Map)object5, specialFields, this.sui.getDataFormat());
                }
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, "Jsoncreator, after transform body: " + (String)object2 + " tolodaer user: " + this.sui.getUserName());
                }
                object6 = JsonStreamLoader.load((String)object4, this.sui.getUserName(), this.sui.getPassword(), this.sui.getMimeType(), this.sui.getHttpMethod(), object3, (String)object2);
                this.root = FetchJsonSchema.fetchRoot((InputStream)object6);
                this.mc.add(this.root);
            }
            catch (Exception exception) {
                if (JRLog.isTrace(2)) {
                    JRLog.error(2, exception);
                }
                throw new DSException(4276, new Object[]{exception});
            }
        }
    }

    private Hashtable CreateParseParametersForQuery(JetUDatabase jetUDatabase, Vector vector, SpecialFields specialFields) throws GenerateFormulasCodeException, ReadFailureException, ClassNotFoundException, FileNotFoundException, IOException, InstantiationException, IllegalAccessException, GenerateFormulasCodeException, LoadJavaFormulaException, DSException {
        JetUUniverse jetUUniverse = jetUDatabase.getUniverse();
        Hashtable<String, DbValue> hashtable = new Hashtable<String, DbValue>();
        for (String string : vector) {
            Object object;
            JetObject jetObject;
            JetUFormula jetUFormula = jetUDatabase.getFormulaByResourceName(string);
            if (jetUFormula != null) {
                jetObject = jetUFormula.getRptFormula();
                object = jetUUniverse.loadJavaFormula(jetUDatabase.getResourceName());
                ((JavaFormula)object).setInformationBusManager(jetUUniverse.getInfoBusManager());
                Vector vector2 = RefObjectCollector.getRefParams(new JetUFormula[]{jetUFormula}, jetUDatabase);
                Hashtable<String, DbValue> hashtable2 = new Hashtable<String, DbValue>();
                for (JetUParameter jetUParameter : vector2) {
                    ParamDesc paramDesc = jetUParameter.getParamDesc();
                    this.PFStoConstant(jetUDatabase, paramDesc, specialFields);
                    hashtable2.put(jetUParameter.getResourceName().toUpperCase(), paramDesc.getValue());
                }
                ((JavaFormula)object).setParameters(hashtable2);
                hashtable.put(string.toUpperCase(), ((JetRptFormula)jetObject).execConstFML((JavaFormula)object));
                continue;
            }
            jetObject = jetUUniverse.getAnyResourceByName(string);
            if (jetObject == null) continue;
            object = ((JetUParameter)jetObject).getParamDesc();
            this.PFStoConstant(jetUDatabase, (ParamDesc)object, specialFields);
            hashtable.put(string.toUpperCase(), ((ParamDesc)object).getValue());
        }
        return hashtable;
    }

    private void PFStoConstant(JetUDatabase jetUDatabase, ParamDesc paramDesc, SpecialFields specialFields) throws DSException {
        if (paramDesc.isBindColumn()) {
            String[] stringArray;
            Object object;
            String string22;
            Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
            Vector vector = paramDesc.getImportParams();
            JetUUniverse jetUUniverse = jetUDatabase.getUniverse();
            if (vector != null) {
                for (String string22 : vector) {
                    object = jetUUniverse.getAnyResourceByName(string22);
                    stringArray = ((JetUParameter)object).getParamDesc();
                    this.PFStoConstant(jetUDatabase, (ParamDesc)stringArray, specialFields);
                    hashtable.put(string22.toUpperCase(), stringArray);
                }
            }
            Vector vector2 = new Vector();
            string22 = paramDesc.getDefinition().getBindColumn().getQueryName();
            object = ParseParametersForQueryFactory.CreateParseParametersForQuery(jetUUniverse, jetUDatabase.getResourceName(), string22);
            for (String string : stringArray = object.getParameterNamesInQuery()) {
                JetUResourceEntity jetUResourceEntity = jetUUniverse.getAnyResourceByName(string);
                ParamDesc paramDesc2 = ((JetUParameter)jetUResourceEntity).getParamDesc();
                this.PFStoConstant(jetUDatabase, paramDesc2, specialFields);
                vector2.add(paramDesc2);
            }
            DefaultFetcherContext defaultFetcherContext = new DefaultFetcherContext(jetUUniverse, hashtable, vector2, specialFields.getUserName());
            CatalogKey catalogKey = CatalogKeyCreater.createCatalogKey(jetUUniverse.getFullFileName());
            paramDesc.getParameterRuntime().createValueListFetcher(catalogKey, defaultFetcherContext);
        }
    }

    @Override
    public QName[] getNameList() throws DSException {
        QName[] qNameArray = new QName[]{this.root.getQName()};
        return qNameArray;
    }
}

