/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core;

import com.jinfonet.util.JRLog;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.JQuery;
import jet.dataengine.listener.CancelEvent;
import jet.dataengine.listener.JCancelListener;
import jet.dataengine.listener.JListenerContainer;
import jet.dataengine.listener.JQueryListener;
import jet.dataengine.listener.QueryEvent;
import jet.dataengine.util.DSLog;
import jet.dataengine8.core.GroupQueryTask;
import jet.dataservice.api.DataServiceConfig;
import jet.util.EngineErrorListener;

public abstract class ATask
implements JListenerContainer,
JCancelListener {
    protected final DSLog log = DSLog.getDSLog(this.getClass().getName());
    protected final String taskName;
    protected volatile TaskState state = new TaskState();
    protected boolean isSingleThread;
    protected Thread thread = null;
    protected Vector errorListenerContainer;
    private final List add = new LinkedList();
    protected Throwable exception;
    private Object append = new Object();
    protected QueryEvent queryEvent;
    protected CancelEvent cancelEvent;
    private int cancel = -1;
    protected DataServiceConfig dataServiceConfig;

    protected ATask(String string, DataServiceConfig dataServiceConfig) {
        this.taskName = string;
        this.dataServiceConfig = dataServiceConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws DSException {
        Object object = this.append;
        synchronized (object) {
            this.checkClose();
            if (!this.isCreated()) {
                return;
            }
            this.state.chageState(2);
            this.append.notifyAll();
        }
        if (this.isSingleThread) {
            this.$assertionsDisabled();
        } else {
            block10: {
                this.thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ATask.this.$assertionsDisabled();
                    }
                });
                this.thread.setName(this.taskName);
                if (this.cancel != -1) {
                    try {
                        this.thread.setPriority(this.cancel);
                        if (JRLog.isTrace(5)) {
                            JRLog.trace(5, "Thread name in data engine:" + this.thread.getName() + " set prioriy as: " + this.cancel);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!this.log.isWarnEnabled()) break block10;
                        this.log.warn(1147, new Object[]{this.thread.getName()}, throwable);
                    }
                }
            }
            this.thread.start();
        }
    }

    public void setThreadPriority(int n) {
        this.cancel = n;
    }

    private final void $assertionsDisabled() {
        try {
            try {
                this.doTask();
            }
            catch (JRStopEngineException jRStopEngineException) {
                // empty catch block
            }
            this.complete(new QueryEvent(this));
        }
        catch (Throwable throwable) {
            this.error(new QueryEvent(this, throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void complete(QueryEvent queryEvent) {
        Object object = this.append;
        synchronized (object) {
            if (!this.isProcessing()) {
                return;
            }
            this.onComplete();
            this.state.chageState(3);
            this.append.notifyAll();
        }
        this.queryEvent = queryEvent;
        this.sendCompleteEvent();
    }

    protected final void dependTaskError(QueryEvent queryEvent) {
        try {
            this.cancelEvent = new CancelEvent(queryEvent == null ? this : queryEvent.getError());
            this.onCancel(this.cancelEvent);
        }
        catch (DSException dSException) {
            this.log.debug("when the depend task fail, cancel current task fail.", dSException);
        }
        this.error(queryEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void error(QueryEvent queryEvent) {
        Object object = this.append;
        synchronized (object) {
            this.onError(this.exception);
            this.state.chageState(5);
            this.append.notifyAll();
        }
        this.exception = queryEvent.getError();
        this.queryEvent = queryEvent;
        this.sendErrorEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cancel(CancelEvent cancelEvent) throws DSException {
        Object object = this.append;
        synchronized (object) {
            this.log.info("cancelQueryTask: taskState = " + this.state);
            if (!this.isCreated()) {
                if (this.isProcessing()) {
                    this.log.info("cancelQueryTask: onCancel begin");
                    this.onCancel(cancelEvent);
                    this.log.info("cancelQueryTask: onCancel end");
                } else {
                    return;
                }
            }
            this.state.chageState(4);
            this.log.info("cancelQueryTask: taskState = " + this.state);
            this.append.notifyAll();
        }
        this.cancelEvent = cancelEvent;
        this.queryEvent = new QueryEvent(this);
        this.sendCancelEvent();
    }

    protected abstract void doTask() throws DSException, JRStopEngineException;

    protected void onComplete() {
    }

    protected void onError(Throwable throwable) {
    }

    protected void onCancel(CancelEvent cancelEvent) throws DSException {
    }

    protected abstract void onClose() throws DSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addListener(JQueryListener jQueryListener) {
        List list = this.add;
        synchronized (list) {
            this.add.add(jQueryListener);
            if (this.isError()) {
                jQueryListener.error(this.queryEvent);
            } else if (this.isSuccess()) {
                jQueryListener.complete(this.queryEvent);
            } else if (this.isCanceled()) {
                jQueryListener.cancel(this.queryEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeListener(JQueryListener jQueryListener) {
        List list = this.add;
        synchronized (list) {
            this.add.remove(jQueryListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendErrorEvent() {
        List list = this.add;
        synchronized (list) {
            for (Object object : this.add) {
                object.error(this.queryEvent);
            }
            if (this.errorListenerContainer != null) {
                Object object;
                Thread thread = this.thread == null ? Thread.currentThread() : this.thread;
                object = this.queryEvent.getError();
                for (EngineErrorListener engineErrorListener : this.errorListenerContainer) {
                    engineErrorListener.noteError(thread, (Throwable)object, 1, "0");
                }
            }
        }
    }

    private int SEDU() {
        try {
            return this.getQueryId();
        }
        catch (DSException dSException) {
            assert (false) : "not expect the exception " + dSException;
            return -1;
        }
    }

    protected abstract int getQueryId() throws DSException;

    protected abstract JQuery getQuery() throws DSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCompleteEvent() {
        List list = this.add;
        synchronized (list) {
            for (JQueryListener jQueryListener : this.add) {
                jQueryListener.complete(this.queryEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCancelEvent() {
        List list = this.add;
        synchronized (list) {
            for (JQueryListener jQueryListener : this.add) {
                jQueryListener.cancel(this.queryEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getResult() throws DSException, JRStopEngineException {
        if (this instanceof GroupQueryTask) {
            if (this.isError()) {
                if (this.exception instanceof DSException && ((DSException)this.exception).getErrorKey() == 38401) {
                    throw (DSException)this.exception;
                }
                throw this.exception == null ? new DSException(1085) : new DSException(1085, new Object[]{this.exception.getMessage()}, this.exception);
            }
            if (this.isCanceled()) {
                throw new JRStopEngineException();
            }
            if (this.isClosed()) {
                throw new DSException(1087);
            }
            return this.getCrroectResult();
        }
        Object object = this.append;
        synchronized (object) {
            if (this.isError()) {
                throw this.exception == null ? new DSException(1085) : new DSException(1085, new Object[]{this.exception.getMessage()}, this.exception);
            }
            if (this.isCanceled()) {
                throw new JRStopEngineException();
            }
            if (this.isClosed()) {
                throw new DSException(1087);
            }
            return this.getCrroectResult();
        }
    }

    protected abstract Object getCrroectResult() throws DSException, JRStopEngineException;

    public final boolean isCreated() {
        return this.state.isCreated();
    }

    public final boolean isReady() {
        return this.state.isReady();
    }

    public final boolean isProcessing() {
        return this.state.isProcessing();
    }

    public final boolean isEnd() {
        return this.isSuccess() || this.isCanceled() || this.isError();
    }

    public final boolean isSuccess() {
        return this.state.isSuccess();
    }

    public final boolean isCanceled() {
        return this.state.isCanceled();
    }

    public final boolean isError() {
        return this.state.isError();
    }

    public final boolean isClosed() {
        return this.state.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws DSException {
        if (JRLog.isTrace(6)) {
            this.log.externalDebug(1021, new Object[]{this.taskName, "[" + this.hashCode() + "]"});
        }
        Object object = this.append;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            if (this.isProcessing()) {
                this.onCancel(new CancelEvent(this));
            }
            this.state.chageState(6);
            this.append.notifyAll();
            this.add.clear();
        }
        this.onClose();
    }

    protected void checkClose() throws DSException {
        if (this.isClosed()) {
            throw new DSException(1090);
        }
    }

    public Thread[] getThreadList() {
        if (this.thread == null) {
            return new Thread[0];
        }
        return new Thread[]{this.thread};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getError() {
        Object object = this.append;
        synchronized (object) {
            while (this.isProcessing()) {
                try {
                    this.append.wait();
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            return this.exception;
        }
    }

    protected class TaskState {
        private volatile int SEDU = 0;
        final String[] stateName = new String[]{"Created", "Ready", "Processing", "Success", "Cancelled", "Error", "Closed"};

        protected TaskState() {
        }

        public String toString() {
            return ATask.this.taskName + " |" + this.SEDU + "|" + this.stateName[this.SEDU];
        }

        boolean isCreated() {
            return this.SEDU == 0;
        }

        boolean isReady() {
            return this.SEDU == 1;
        }

        boolean isProcessing() {
            return this.SEDU == 2;
        }

        boolean isCanceled() {
            return this.SEDU == 4;
        }

        boolean isSuccess() {
            return this.SEDU == 3;
        }

        boolean isError() {
            return this.SEDU == 5;
        }

        boolean isClosed() {
            return this.SEDU == 6;
        }

        void chageState(int n) {
            if (this.SEDU != n) {
                this.SEDU = n;
            }
        }
    }
}

