/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core;

import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.expression.executor.conditiontools.RelationConditionTool;
import com.jinfonet.dataservice.relational.IRelationData;
import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.DataEngineOption;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.listener.CancelEvent;
import jet.dataengine8.core.ADependentQueryTask;
import jet.dataengine8.core.AQueryTask;
import jet.dataengine8.core.IterativeQueryTask;
import jet.dataengine8.core.RawDataQueryTask;
import jet.dataengine8.core.queryengine.transform.AQueryInfo;
import jet.dataengine8.core.queryengine.transform.AttributeContainer;
import jet.dataservice.api.DataServiceConfig;
import jet.universe.JetUDatabase;
import jet.universe.JetUUniverse;

public class FilterSortTask
extends ADependentQueryTask {
    private RelationConditionTool SEDU;
    private IExpression add;
    private IRelationData append = null;

    public FilterSortTask(JRawDataQuery jRawDataQuery, DataEngineOption dataEngineOption, IExpression iExpression, RawDataQueryTask rawDataQueryTask, DataServiceConfig dataServiceConfig) throws DSException {
        super("LocalSort" + jRawDataQuery.getQueryId(), jRawDataQuery, dataEngineOption, rawDataQueryTask, dataServiceConfig);
        this.isSingleThread = true;
        assert (iExpression != null) : "filter sort task, expression is null";
        JetUDatabase jetUDatabase = null;
        JetUUniverse jetUUniverse = jRawDataQuery.getCatalog();
        jetUDatabase = jetUUniverse.getDatabase(jRawDataQuery.getDataSourceName());
        this.add = iExpression;
        this.SEDU = RelationConditionTool.getInstance(this.add, rawDataQueryTask.getQueryinfo().getAttributeContainer(), jRawDataQuery.getJavaFormula(), jRawDataQuery.getSpecialFields());
        rawDataQueryTask.execute();
        if (this.isCanceled()) {
            return;
        }
        IRelationData iRelationData = null;
        try {
            iRelationData = (IRelationData)rawDataQueryTask.getResult();
        }
        catch (JRStopEngineException jRStopEngineException) {
            // empty catch block
        }
        if (this.isCanceled()) {
            return;
        }
        this.append = this.SEDU.doAction(iRelationData);
    }

    public FilterSortTask(JRawDataQuery jRawDataQuery, DataEngineOption dataEngineOption, IExpression iExpression, IterativeQueryTask iterativeQueryTask, DataServiceConfig dataServiceConfig) throws DSException {
        super("LocalSort" + jRawDataQuery.getQueryId(), jRawDataQuery, dataEngineOption, iterativeQueryTask, dataServiceConfig);
        this.isSingleThread = true;
        assert (iExpression != null) : "filter sort task, expression is null";
        JetUUniverse jetUUniverse = jRawDataQuery.getCatalog();
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(jRawDataQuery.getDataSourceName());
        this.add = iExpression;
        iterativeQueryTask.execute();
        if (this.isCanceled()) {
            return;
        }
        IRelationData iRelationData = null;
        try {
            iRelationData = (IRelationData)iterativeQueryTask.getResult();
        }
        catch (JRStopEngineException jRStopEngineException) {
            // empty catch block
        }
        if (this.isCanceled()) {
            return;
        }
        JRelationMetaData jRelationMetaData = iRelationData.getMetaData();
        AttributeContainer attributeContainer = new AttributeContainer();
        for (int i = 0; i < jRelationMetaData.getColumnCount(); ++i) {
            JAttribute jAttribute = jRelationMetaData.getAttribute(i + 1);
            attributeContainer.add(jAttribute);
        }
        this.SEDU = RelationConditionTool.getInstance(this.add, attributeContainer, jRawDataQuery.getJavaFormula(), jRawDataQuery.getSpecialFields());
        this.append = this.SEDU.doAction(iRelationData);
    }

    public FilterSortTask(JRawDataQuery jRawDataQuery, DataEngineOption dataEngineOption, IExpression iExpression, AQueryTask aQueryTask, AQueryInfo aQueryInfo, DataServiceConfig dataServiceConfig) throws DSException {
        super("LocalSort" + jRawDataQuery.getQueryId(), jRawDataQuery, dataEngineOption, aQueryTask, dataServiceConfig);
        this.isSingleThread = true;
        assert (iExpression != null) : "filter sort task, expression is null";
        JetUUniverse jetUUniverse = jRawDataQuery.getCatalog();
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(jRawDataQuery.getDataSourceName());
        this.add = iExpression;
        this.SEDU = RelationConditionTool.getInstance(this.add, aQueryInfo.getAttributeContainer(), jRawDataQuery.getJavaFormula(), jRawDataQuery.getSpecialFields());
        aQueryTask.execute();
        if (this.isCanceled()) {
            return;
        }
        IRelationData iRelationData = null;
        try {
            iRelationData = (IRelationData)aQueryTask.getResult();
        }
        catch (JRStopEngineException jRStopEngineException) {
            // empty catch block
        }
        if (this.isCanceled()) {
            return;
        }
        this.append = this.SEDU.doAction(iRelationData);
    }

    @Override
    protected void doTask() throws DSException, JRStopEngineException {
        long l = System.currentTimeMillis();
        this.log.externalDebug(1005, new Object[]{this.add.toString()});
        this.log.info(1006, new Object[]{this.add.toString(), String.valueOf(System.currentTimeMillis() - l)});
    }

    @Override
    public Object getCrroectResult() throws DSException {
        return this.append;
    }

    @Override
    public void onCancel(CancelEvent cancelEvent) throws DSException {
        super.onCancel(cancelEvent);
        if (this.SEDU != null) {
            this.SEDU.cancel(cancelEvent);
        }
    }

    public IExpression getRecordLevelFilterSort() {
        return this.add;
    }

    @Override
    protected void onClose() throws DSException {
        super.onClose();
        if (this.append != null) {
            this.append.close();
            this.append = null;
        }
        this.SEDU = null;
        this.add = null;
    }

    @Override
    protected int getQueryId() throws DSException {
        return -1;
    }
}

