/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core;

import com.jinfonet.dataservice.relational.IRelationData;
import jet.JRStopEngineException;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.DataEngineOption;
import jet.dataengine.api.expression.set.ISortExpression;
import jet.dataengine.api.expression.tuple.ITupleExpression;
import jet.dataengine.api.query.ARawDataQueryExtender;
import jet.dataengine.api.query.JDSQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.listener.CancelEvent;
import jet.dataengine8.core.AQueryTask;
import jet.dataengine8.core.queryengine.FetchMessage;
import jet.dataengine8.core.queryengine.JQueryEngine;
import jet.dataengine8.core.queryengine.QueryEngineFactory;
import jet.dataengine8.core.queryengine.transform.AQueryInfo;
import jet.dataengine8.query.AQuery;
import jet.dataservice.api.DataServiceConfig;
import jet.universe.JetUConnection;
import jet.universe.JetUJDBCConnection;

public class RawDataQueryTask
extends AQueryTask {
    private JQueryEngine J;
    private JRawDataQuery SEDU;
    private AQueryInfo append;
    private IRelationData canBeChange = null;
    private FetchMessage cancel = new FetchMessage();
    private ISortExpression checkClose;

    public RawDataQueryTask(JRawDataQuery jRawDataQuery, DataEngineOption dataEngineOption, DataServiceConfig dataServiceConfig) throws DSException {
        this(jRawDataQuery, dataEngineOption, null, null, dataServiceConfig);
    }

    public RawDataQueryTask(JRawDataQuery jRawDataQuery, DataEngineOption dataEngineOption, ITupleExpression iTupleExpression, ISortExpression iSortExpression, DataServiceConfig dataServiceConfig) throws DSException {
        super("RawDataQueryTask[" + jRawDataQuery.hashCode() + "] id = " + jRawDataQuery.getQueryId(), jRawDataQuery, dataEngineOption, dataServiceConfig);
        if (jRawDataQuery.canBeChange()) {
            throw new DSException(1082, new Object[]{String.valueOf(jRawDataQuery.getQueryId())});
        }
        this.SEDU = jRawDataQuery;
        this.checkClose = iSortExpression;
        long l = System.currentTimeMillis();
        JetUJDBCConnection jetUJDBCConnection = null;
        if (jRawDataQuery instanceof JDSQuery && ((JDSQuery)jRawDataQuery).getDynamicDatabaseMetadataInfos().size() > 0) {
            long l2 = Thread.currentThread().getId();
            JetUConnection[] jetUConnectionArray = jRawDataQuery.getCatalog().getDatabase(jRawDataQuery.getDataSourceName()).getQueriableByResourceName(jRawDataQuery.getQueryName()).getConnections();
            if (jetUConnectionArray.length > 0 && jetUConnectionArray[0] instanceof JetUJDBCConnection) {
                jetUJDBCConnection = (JetUJDBCConnection)jetUConnectionArray[0];
                jetUJDBCConnection.registerRunTimeDBMetaData(l2, (JDSQuery)jRawDataQuery);
                jRawDataQuery.getExtender().setSupportInfo(jetUJDBCConnection.getSupportInfo());
            }
        }
        this.J = QueryEngineFactory.getInstance(jRawDataQuery, iTupleExpression, iSortExpression, true, this.cancel, dataServiceConfig);
        ((AQuery)((Object)jRawDataQuery)).pi.createEngineTime = System.currentTimeMillis() - l;
        this.append = this.J.getQueryInfo();
        assert (this.append != null) : "RawDataQueryTask queryinfo is null";
        if (jetUJDBCConnection != null) {
            jetUJDBCConnection.unregisterRunTimeDBMetaData(Thread.currentThread().getId());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("create query engine(id:" + jRawDataQuery.getQueryId() + ") time(ms):" + (System.currentTimeMillis() - l));
        }
    }

    @Override
    protected void doTask() throws DSException, JRStopEngineException {
        Object object;
        long l = System.currentTimeMillis();
        JetUJDBCConnection jetUJDBCConnection = null;
        if (this.SEDU instanceof JDSQuery && ((JDSQuery)this.SEDU).getDynamicDatabaseMetadataInfos().size() > 0) {
            long l2 = Thread.currentThread().getId();
            JetUConnection[] jetUConnectionArray = this.SEDU.getCatalog().getDatabase(this.SEDU.getDataSourceName()).getQueriableByResourceName(this.SEDU.getQueryName()).getConnections();
            if (jetUConnectionArray.length > 0 && jetUConnectionArray[0] instanceof JetUJDBCConnection) {
                jetUJDBCConnection = (JetUJDBCConnection)jetUConnectionArray[0];
                jetUJDBCConnection.registerRunTimeDBMetaData(l2, (JDSQuery)this.SEDU);
            }
        }
        String string = String.valueOf(this.SEDU.getQueryId());
        if (this.log.isOutlineEnabled()) {
            object = this.SEDU.getExtender().isCanPushDownAgg() ? "PushDownAgg for AggQuery " + this.SEDU.getExtender().getAggQueryId() : "";
            this.log.outline(1002, new Object[]{"RawDataQueryTask" + (String)object, string});
        }
        this.J.execute();
        if (jetUJDBCConnection != null) {
            jetUJDBCConnection.unregisterRunTimeDBMetaData(Thread.currentThread().getId());
        }
        if (this.SEDU.isIncrementalQuery()) {
            object = this.SEDU.getExtender();
            ((ARawDataQueryExtender)object).setFirstRun(false);
        }
        if (this.log.isOutlineEnabled()) {
            this.log.outline(1003, new Object[]{"RawDataQueryTask", string, String.valueOf(System.currentTimeMillis() - l)});
        }
    }

    @Override
    public Object getCrroectResult() throws DSException {
        if (this.canBeChange == null) {
            this.canBeChange = this.J.getRelation();
        }
        return this.canBeChange;
    }

    public AQueryInfo getQueryinfo() throws DSException {
        super.checkClose();
        return this.append;
    }

    JQueryEngine getQueryEngine() throws DSException {
        super.checkClose();
        return this.J;
    }

    @Override
    protected DbValue[] getConstantFormulaValues() {
        return this.append.getConstantFormulaValues();
    }

    @Override
    protected void onClose() throws DSException {
        if (this.canBeChange != null) {
            this.canBeChange.close();
            this.canBeChange = null;
        }
        this.append = null;
    }

    @Override
    protected void writeDmtFile(String string, String string2) throws DSException {
        this.cancel.setDmtFile(string);
        this.cancel.setRptName(string2);
    }

    @Override
    public FetchMessage getFetchMessage() throws DSException, JRStopEngineException {
        if (this.isError()) {
            throw this.exception == null ? new DSException(1085) : new DSException(1085, new Object[]{this.exception.getMessage()}, this.exception);
        }
        if (this.isCanceled()) {
            throw new JRStopEngineException();
        }
        if (this.isClosed()) {
            throw new DSException(1087);
        }
        return this.cancel;
    }

    @Override
    protected void onCancel(CancelEvent cancelEvent) throws DSException {
        super.onCancel(cancelEvent);
        this.log.info("cancelQueryTask:RawDataQueryTask  onCancel begin " + this.J);
        this.J.cancel(cancelEvent);
        this.log.info("cancelQueryTask: RawDataQueryTask onCancel end");
    }

    @Override
    protected void onError(Throwable throwable) {
        super.onError(throwable);
    }

    public ISortExpression getSortExp() {
        return this.checkClose;
    }
}

