/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core;

import java.util.ArrayList;
import java.util.List;
import jet.connect.DbColDesc;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.IOperatorFactory;
import jet.dataengine.api.expression.IOperatorInforFactory;
import jet.dataengine.api.expression.info.ISortInformation;
import jet.dataengine.api.expression.info.ISortInformationCollector;
import jet.dataengine.api.expression.set.ISetExpression;
import jet.dataengine.api.expression.set.ISortExpression;
import jet.dataengine.api.expression.set.op.ISortOperator;
import jet.dataengine.api.expression.tuple.ITupleExpression;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.groupengine.GroupModel;
import jet.dataengine.groupengine.LeafGroupModel;
import jet.dataengine.util.DSLog;

public class SortConverter {
    private static IExpressionFactory SEDU;
    private static IOperatorFactory add;
    private static IOperatorInforFactory addSortInformation;
    private static final DSLog append;

    public static IExpressionFactory getIExpressionFactory() throws ConditionException {
        if (SEDU != null) {
            return SEDU;
        }
        SEDU = ExpressionFactoryCreator.getIExpressionFactory();
        return SEDU;
    }

    public static IOperatorFactory getIOperatorFactory() throws ConditionException {
        if (add != null) {
            return add;
        }
        add = ExpressionFactoryCreator.getIOperatorFactory();
        return add;
    }

    public static IOperatorInforFactory getIOperatorInforFactory() throws ConditionException {
        if (addSortInformation != null) {
            return addSortInformation;
        }
        addSortInformation = ExpressionFactoryCreator.getIOperatorInforFactory();
        return addSortInformation;
    }

    public static ISortExpression convert(GroupModel groupModel, String[] stringArray) throws ConditionException {
        Object object;
        append.debug("create a sort expression from groupmodel");
        if (groupModel == null) {
            return null;
        }
        ISortInformationCollector iSortInformationCollector = SortConverter.getIOperatorInforFactory().createSortInfoCollector();
        GroupModel groupModel2 = groupModel;
        groupModel2.sortByServer();
        ArrayList arrayList = new ArrayList();
        boolean bl = SortConverter.$assertionsDisabled(iSortInformationCollector, groupModel2.nextGroupModel(), stringArray, arrayList);
        if (!bl) {
            object = (LeafGroupModel)groupModel.getLastLeaf();
            SortConverter.$assertionsDisabled(iSortInformationCollector, ((LeafGroupModel)object).getSortGroupInLeaf(), stringArray, arrayList);
        }
        if (iSortInformationCollector.size() > 0) {
            groupModel2.sortByServer();
            object = SortConverter.getIOperatorFactory().createSortOp(iSortInformationCollector);
            ISortExpression iSortExpression = SortConverter.getIExpressionFactory().createSortExp((ISortOperator)object);
            append.debug("SortExp: " + iSortExpression);
            return iSortExpression;
        }
        return null;
    }

    private static boolean $assertionsDisabled(ISortInformationCollector iSortInformationCollector, GroupModel groupModel, String[] stringArray, List list) throws ConditionException {
        if (groupModel == null) {
            return false;
        }
        for (GroupModel groupModel2 = groupModel; groupModel2 != null; groupModel2 = groupModel2.nextGroupModel()) {
            if (groupModel2.isGroupByDeny()) {
                groupModel2.setSortByServer(true);
                continue;
            }
            groupModel2.setSortByServer(false);
            DbColDesc dbColDesc = groupModel2.getSpecFunc();
            if (dbColDesc != null || groupModel2.isSpecifiedOrder()) {
                return true;
            }
            DbColDesc dbColDesc2 = groupModel2.getPreprocess();
            if (dbColDesc2 == null) {
                groupModel2.sortByServer();
                return true;
            }
            int n = groupModel2.getOrderBeforeGrouping();
            if (n == 3) {
                groupModel2.sortByServer();
                return true;
            }
            boolean bl = false;
            String string2 = null;
            for (String string2 : stringArray) {
                if (!dbColDesc2.colName.equalsIgnoreCase(string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return true;
            }
            IReference iReference = SortConverter.getIExpressionFactory().createReference(string2);
            n = SortConverter.SEDU(n);
            ISortInformation iSortInformation = SortConverter.getIOperatorInforFactory().createSortInfo(iReference, n, false);
            iSortInformationCollector.addSortInformation(iSortInformation);
            groupModel2.sortByServer();
            list.add(string2);
        }
        return false;
    }

    private static int SEDU(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 0;
            }
        }
        assert (false) : "unknown sort type: " + n;
        return -1;
    }

    public static IExpression convert(IExpression iExpression, GroupModel groupModel) throws DSException {
        GroupModel groupModel2;
        append.debug("create a sort expression from groupmodel");
        for (groupModel2 = groupModel; groupModel2 != null && !(groupModel2 instanceof LeafGroupModel); groupModel2 = groupModel2.nextGroupModel()) {
        }
        GroupModel groupModel3 = groupModel2 == null ? null : ((LeafGroupModel)groupModel2).getSortGroupInLeaf();
        try {
            ISortOperator iSortOperator;
            ISortOperator iSortOperator2 = SortConverter.add(groupModel3);
            if (iSortOperator2 != null) {
                if (iExpression == null) {
                    iExpression = SortConverter.getIExpressionFactory().createSortExp(iSortOperator2);
                } else if (iExpression instanceof ITupleExpression) {
                    iExpression = SortConverter.getIExpressionFactory().createSortExp((ITupleExpression)iExpression, iSortOperator2);
                } else if (iExpression instanceof ISetExpression) {
                    iExpression = SortConverter.getIExpressionFactory().createSortExp((ISetExpression)iExpression, iSortOperator2);
                }
            }
            if ((iSortOperator = SortConverter.add(groupModel)) != null) {
                if (iExpression == null) {
                    iExpression = SortConverter.getIExpressionFactory().createSortExp(iSortOperator);
                } else if (iExpression instanceof ITupleExpression) {
                    iExpression = SortConverter.getIExpressionFactory().createSortExp((ITupleExpression)iExpression, iSortOperator);
                } else if (iExpression instanceof ISetExpression) {
                    iExpression = SortConverter.getIExpressionFactory().createSortExp((ISetExpression)iExpression, iSortOperator);
                }
            }
        }
        catch (ConditionException conditionException) {
            throw new DSException("01081");
        }
        return iExpression;
    }

    private static ISortOperator add(GroupModel groupModel) throws ConditionException {
        if (groupModel == null) {
            return null;
        }
        ISortInformationCollector iSortInformationCollector = SortConverter.getIOperatorInforFactory().createSortInfoCollector();
        for (GroupModel groupModel2 = groupModel; groupModel2 != null; groupModel2 = groupModel2.nextGroupModel()) {
            DbColDesc dbColDesc = groupModel2.getPreprocess();
            if (dbColDesc == null) {
                groupModel2.sortByServer();
                continue;
            }
            int n = groupModel2.getOrderBeforeGrouping();
            if (n == 3) {
                groupModel2.sortByServer();
                continue;
            }
            IReference iReference = SortConverter.getIExpressionFactory().createReference(dbColDesc.colName);
            n = SortConverter.SEDU(n);
            ISortInformation iSortInformation = SortConverter.getIOperatorInforFactory().createSortInfo(iReference, n, false);
            iSortInformationCollector.addSortInformation(iSortInformation);
            groupModel2.sortByServer();
        }
        if (iSortInformationCollector.size() < 1) {
            return null;
        }
        return SortConverter.getIOperatorFactory().createSortOp(iSortInformationCollector);
    }

    static {
        append = DSLog.getDSLog(SortConverter.class.getName());
    }
}

