/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.pushdown;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IBinary;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.ISingle;
import jet.dataengine.api.expression.ITriple;
import jet.dataengine.api.expression.tuple.IMultiLogicExpression;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IFormula;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.dataengine8.core.pushdown.NotProcessor;
import jet.dataengine8.core.queryengine.sqltoolkit.ResourceContainer;

class DataTypeProcessor {
    private ResourceContainer SEDU;

    public DataTypeProcessor(ResourceContainer resourceContainer) {
        this.SEDU = resourceContainer;
    }

    public void processDataType(IExpression iExpression) throws DSException {
        this.process(iExpression, 0);
    }

    private void process(IExpression iExpression, int n) throws DSException {
        if (iExpression == null) {
            return;
        }
        if (ExpressionToolKit.isSetExp(iExpression.expressionType())) {
            IExpression iExpression2 = NotProcessor.getLeafTupleExp(iExpression);
            this.processDataType(iExpression2);
        } else if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            this.getAttributeName(iExpression, n);
        } else if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            IExpression iExpression3 = ((ISingle)((Object)iExpression)).getExpression();
            n = ExpressionToolKit.isSingleLogicExp(iExpression.expressionType()) ? -7 : 0;
            this.process(iExpression3, n);
        } else if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            IExpression iExpression4 = ((IBinary)((Object)iExpression)).getExpression1();
            IExpression iExpression5 = ((IBinary)((Object)iExpression)).getExpression2();
            n = ExpressionToolKit.isBinaryLogicExp(iExpression.expressionType()) ? -7 : this.SEDU(iExpression4, iExpression5, null);
            this.process(iExpression4, n);
            this.process(iExpression5, n);
        } else if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            IExpression iExpression6 = ((ITriple)((Object)iExpression)).getExpression1();
            IExpression iExpression7 = ((ITriple)((Object)iExpression)).getExpression2();
            IExpression iExpression8 = ((ITriple)((Object)iExpression)).getExpression3();
            n = this.SEDU(iExpression6, iExpression7, iExpression8);
            this.process(iExpression6, n);
            this.process(iExpression7, n);
            this.process(iExpression8, n);
        } else if (ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
            IMultiLogicExpression iMultiLogicExpression = (IMultiLogicExpression)iExpression;
            IExpression[] iExpressionArray = iMultiLogicExpression.getExpressions();
            for (int i = 0; i < iExpressionArray.length; ++i) {
                this.process(iExpressionArray[i], n);
            }
        } else {
            System.out.println("The data type: " + n + " is wrong !");
        }
    }

    private int SEDU(IExpression iExpression, IExpression iExpression2, IExpression iExpression3) throws DSException {
        if (iExpression != null && iExpression2 != null && iExpression3 == null) {
            return this.containsIgnoreCase(iExpression, iExpression2);
        }
        if (iExpression != null && iExpression2 != null && iExpression3 != null) {
            return this.append(iExpression, iExpression2, iExpression3);
        }
        throw new DSException(2551, new Object[]{"internal error, invalid usage"});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int append(IExpression iExpression, IExpression iExpression2, IExpression iExpression3) throws DSException {
        int n = 12;
        if (ExpressionToolKit.isReference(iExpression.expressionType())) {
            if (!this.SEDU.containsIgnoreCase(((IReference)iExpression).getAttributeName())) throw new DSException(2553, new Object[]{"not contained field in resource container : " + ((IReference)iExpression).getAttributeName()});
            this.SEDU.getStringValue();
            if (!this.SEDU.wasField()) throw new DSException(2552, new Object[]{"resource node was not field : " + ((IReference)iExpression).getAttributeName()});
            return this.SEDU.getJAttribute().getDataType();
        }
        if (ExpressionToolKit.isFormula(iExpression.expressionType())) {
            try {
                if (!this.SEDU.containsIgnoreCase(iExpression.getName())) throw new DSException(2555, new Object[]{"not contained formula in resource container : " + ((IReference)iExpression).getAttributeName()});
                this.SEDU.getStringValue();
                if (!this.SEDU.wasFormula()) throw new DSException(2554, new Object[]{"resource node was not formula : " + ((IReference)iExpression).getAttributeName()});
                return this.SEDU.getJAttribute().getDataType();
            }
            catch (ConditionException conditionException) {
                throw new DSException(2556, new Object[]{"Condition Exception"}, (Throwable)conditionException);
            }
        }
        try {
            throw new DSException(2557, new Object[]{"exp 1 type error : " + iExpression.getName()});
        }
        catch (ConditionException conditionException) {
            throw new DSException(2558, new Object[]{"Condition Exception"}, (Throwable)conditionException);
        }
    }

    private int containsIgnoreCase(IExpression iExpression, IExpression iExpression2) throws DSException {
        if (ExpressionToolKit.isConstant(iExpression.expressionType()) && ExpressionToolKit.isConstant(iExpression2.expressionType())) {
            return 12;
        }
        if (ExpressionToolKit.isConstant(iExpression.expressionType()) && (ExpressionToolKit.isReference(iExpression2.expressionType()) || ExpressionToolKit.isFormula(iExpression2.expressionType()))) {
            int n = ((IConstant)iExpression).getDataType();
            if (n == 0 || !Types.isNumeric(this.expressionType(iExpression2)) || !Types.isNumeric(n)) {
                return this.expressionType((IReference)iExpression2);
            }
            return Types.getCompatibleNumaricType(this.expressionType((IReference)iExpression2), n);
        }
        if ((ExpressionToolKit.isReference(iExpression.expressionType()) || ExpressionToolKit.isFormula(iExpression.expressionType())) && ExpressionToolKit.isConstant(iExpression2.expressionType())) {
            int n = ((IConstant)iExpression2).getDataType();
            if (n == 0 || !Types.isNumeric(this.expressionType(iExpression)) || !Types.isNumeric(n)) {
                return this.expressionType(iExpression);
            }
            return Types.getCompatibleNumaricType(this.expressionType(iExpression), n);
        }
        int n = this.expressionType(iExpression);
        int n2 = this.expressionType(iExpression2);
        if (Types.isNumeric(n) && Types.isNumeric(n2)) {
            return Types.getCompatibleNumaricType(n, n2);
        }
        return n;
    }

    private int expressionType(IExpression iExpression) throws DSException {
        try {
            if (ExpressionToolKit.isReference(iExpression.expressionType())) {
                if (this.SEDU.containsIgnoreCase(((IReference)iExpression).getAttributeName())) {
                    this.SEDU.getStringValue();
                    if (this.SEDU.wasField()) {
                        JAttribute jAttribute = this.SEDU.getJAttribute();
                        return jAttribute.getDataType();
                    }
                }
            } else if (ExpressionToolKit.isFormula(iExpression.expressionType())) {
                if (this.SEDU.containsIgnoreCase(((IFormula)iExpression).getName())) {
                    this.SEDU.getStringValue();
                    if (this.SEDU.wasFormula()) {
                        JAttribute jAttribute = this.SEDU.getJAttribute();
                        return jAttribute.getDataType();
                    }
                }
            } else {
                return ((IVariableExpression)iExpression).getDataType();
            }
            throw new DSException(2559, new Object[]{"can not get field in resource container : " + iExpression.getName()});
        }
        catch (ConditionException conditionException) {
            throw new DSException(2560, new Object[]{"Condition Exception"}, (Throwable)conditionException);
        }
    }

    private void getAttributeName(IExpression iExpression, int n) throws DSException {
        block8: {
            try {
                if (ExpressionToolKit.isConstant(iExpression.expressionType())) {
                    if (n == 0) {
                        ((IConstant)iExpression).setDataType(12);
                    } else {
                        ((IConstant)iExpression).setDataType(n);
                    }
                    break block8;
                }
                if (!ExpressionToolKit.isVariableList(iExpression.expressionType())) break block8;
                IVariableList iVariableList = (IVariableList)iExpression;
                IVariableExpression iVariableExpression = null;
                try {
                    for (int i = 0; i < iVariableList.size(); ++i) {
                        iVariableExpression = iVariableList.getVariableExp(i);
                        this.getAttributeName(iVariableExpression, n);
                    }
                }
                catch (ConditionException conditionException) {
                    throw new DSException(2561, new Object[]{"Condition Exception"}, (Throwable)conditionException);
                }
            }
            catch (ConditionException conditionException) {
                throw new DSException(2562, new Object[]{"Condition Exception"}, (Throwable)conditionException);
            }
        }
    }
}

