/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.pushdown;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.datasource.JDSConnection;
import com.jinfonet.dataservice.api.schema.relational.datasource.relational.JRdbDataField;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.ConstantFilter;
import com.jinfonet.dataservice.expression.variable.ParameterImpl;
import com.jinfonet.dataservice.schema.relational.datasource.relational.RdbConnection;
import java.util.ArrayList;
import java.util.Date;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IBinary;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IOperatorInformation;
import jet.dataengine.api.expression.ITriple;
import jet.dataengine.api.expression.OperatorInfoToolkit;
import jet.dataengine.api.expression.OperatorToolKit;
import jet.dataengine.api.expression.info.ISortInformation;
import jet.dataengine.api.expression.info.ISortInformationCollector;
import jet.dataengine.api.expression.set.op.ISortOperator;
import jet.dataengine.api.expression.tuple.IBinaryConditionExpression;
import jet.dataengine.api.expression.tuple.IConditionExpression;
import jet.dataengine.api.expression.tuple.ILogicExpression;
import jet.dataengine.api.expression.tuple.IMultiTupleExpression;
import jet.dataengine.api.expression.tuple.ISingleLogicExpression;
import jet.dataengine.api.expression.tuple.ITripleConditionExpression;
import jet.dataengine.api.expression.tuple.op.ITupleOperator;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.dataengine.util.StringTools;
import jet.dataengine8.core.pushdown.ExpPushDownParser;
import jet.dataengine8.core.queryengine.querybuilder.info.NamingTools;
import jet.dataengine8.core.queryengine.sqltoolkit.ResourceContainer;
import jet.dataengine8.core.queryengine.transform.QueryTransform;
import jet.universe.JetUSupportInfo;
import toolkit.db.mongo.ExpressionUtil;

public class MongoPushDownParser
extends ExpPushDownParser {
    public static final String LEFT_PAREN = "(";
    public static final String RIGHT_PAREN = ")";
    public static final String LEFT_BRACKET = "[";
    public static final String RIGHT_BRACKET = "]";
    public static final String LEFT_BRACE = "{";
    public static final String RIGHT_BRACE = "}";
    public static final String SPACE = " ";
    public static final String QUOTE = "\"";
    public static final String COMMA = ",";
    private static final String SEDU = "IS NULL";
    private static final String add = "IS NOT NULL";
    private static final String append = ":";
    public static final String AND = "$and:";
    public static final String OR = "$or:";
    private static final String containsIgnoreCase = "$not:";
    private static final String convertDateString = "";
    private static final String equals = "$ne:";
    private static final String equalsIgnoreCase = "$lt:";
    private static final String expressionType = "$lte:";
    private static final String filter = "$gte:";
    private static final String get = "$gt:";
    private static final String getDSName = "$in:";
    private static final String getDataType = "$nin:";
    private static final String getExpression = "";
    private static final String getExpression1 = "BETWEEN";
    private static final String getExpression2 = "{}";
    private static final String getExpression3 = "{\"\":false}";
    public static final String DATE = "$date:";
    public static final String DATE_LONG = "$numberLong:";

    protected MongoPushDownParser(ResourceContainer resourceContainer, JDSConnection jDSConnection, JetUSupportInfo jetUSupportInfo) throws DSException {
        super(resourceContainer, jDSConnection, jetUSupportInfo);
    }

    @Override
    protected boolean treatConditionExpPushDown(IConditionExpression iConditionExpression) throws DSException {
        boolean bl = super.treatConditionExpPushDown(iConditionExpression);
        if (!bl) {
            return bl;
        }
        if (ExpressionToolKit.isSingleExp(iConditionExpression.expressionType())) {
            return false;
        }
        if (ExpressionToolKit.isBinaryExp(iConditionExpression.expressionType())) {
            IBinary iBinary = (IBinary)((Object)iConditionExpression);
            IExpression iExpression = iBinary.getExpression1();
            IExpression iExpression2 = iBinary.getExpression2();
            if (ExpressionToolKit.isVariableExp(iExpression.expressionType()) && ExpressionToolKit.isVariableExp(iExpression2.expressionType())) {
                return !this.isVarExpFieldPass1F((IVariableExpression)iExpression) || !this.isVarExpFieldPass1F((IVariableExpression)iExpression2);
            }
        } else if (ExpressionToolKit.isTripleExp(iConditionExpression.expressionType())) {
            ITriple iTriple = (ITriple)((Object)iConditionExpression);
            IExpression iExpression = iTriple.getExpression1();
            IExpression iExpression3 = iTriple.getExpression2();
            IExpression iExpression4 = iTriple.getExpression3();
            if (ExpressionToolKit.isVariableExp(iExpression.expressionType()) && ExpressionToolKit.isVariableExp(iExpression3.expressionType()) && ExpressionToolKit.isVariableExp(iExpression4.expressionType())) {
                int n = 0;
                if (this.isVarExpFieldPass1F((IVariableExpression)iExpression)) {
                    ++n;
                }
                if (this.isVarExpFieldPass1F((IVariableExpression)iExpression3)) {
                    ++n;
                }
                if (this.isVarExpFieldPass1F((IVariableExpression)iExpression4)) {
                    ++n;
                }
                return n <= 1;
            }
        }
        return false;
    }

    @Override
    public String getSQLConditionString() throws DSException {
        if (this.filterString == null) {
            if (this.pushFilterExps.size() < 1) {
                return null;
            }
            if (this.pushFilterExps.size() == 1) {
                this.filterString = this.add((IExpression)this.pushFilterExps.get(0));
            } else {
                int n = this.pushFilterExps.size();
                ArrayList<String> arrayList = new ArrayList<String>();
                String string = null;
                for (int i = 0; i < n; ++i) {
                    string = this.add((IExpression)this.pushFilterExps.get(i));
                    if (string.equalsIgnoreCase(getExpression2)) continue;
                    arrayList.add(string);
                }
                if (arrayList.size() < 1) {
                    return null;
                }
                this.filterString = arrayList.size() == 1 ? (String)arrayList.get(0) : this.SEDU(arrayList.toArray(new String[0]));
            }
        }
        return this.filterString;
    }

    private String SEDU(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AND);
        stringBuffer.append(LEFT_BRACKET);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase(getExpression2)) continue;
            if (stringArray[i].equalsIgnoreCase(getExpression3)) {
                return getExpression3;
            }
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(SPACE);
            stringBuffer.append(COMMA);
            stringBuffer.append(SPACE);
        }
        stringBuffer.append(RIGHT_BRACKET);
        return LEFT_BRACE + stringBuffer.toString() + RIGHT_BRACE;
    }

    private String add(IExpression iExpression) throws DSException {
        if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            return this.getDataType(iExpression);
        }
        if (ExpressionToolKit.isLogicExp(iExpression.expressionType())) {
            return this.equalsIgnoreCase((ILogicExpression)iExpression);
        }
        if (ExpressionToolKit.isConditionExp(iExpression.expressionType())) {
            return this.append((IConditionExpression)iExpression);
        }
        throw new DSException(2520, new Object[]{"local condition exp type error : " + iExpression.expressionType()});
    }

    private String append(IConditionExpression iConditionExpression) throws DSException {
        if (ExpressionToolKit.isBinaryConditionExp(iConditionExpression.expressionType())) {
            return this.convertDateString((IBinaryConditionExpression)iConditionExpression);
        }
        if (ExpressionToolKit.isTripleConditonExp(iConditionExpression.expressionType())) {
            return this.connection((ITripleConditionExpression)iConditionExpression);
        }
        throw new DSException(2521, new Object[]{"condition exp type error : " + iConditionExpression.expressionType()});
    }

    private String connection(ITripleConditionExpression iTripleConditionExpression) throws DSException {
        return this.containsIgnoreCase(iTripleConditionExpression, false);
    }

    private String containsIgnoreCase(ITripleConditionExpression iTripleConditionExpression, boolean bl) throws DSException {
        ITupleOperator iTupleOperator = iTripleConditionExpression.getOperator();
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.add(iTripleConditionExpression.getExpression1());
        stringBuffer.append(SPACE);
        if (OperatorToolKit.isBetween(iTupleOperator.operatorType()) && !bl || OperatorToolKit.isNotBetween(iTupleOperator.operatorType()) && bl) {
            stringBuffer.append(LEFT_BRACE);
            stringBuffer.append(AND);
            stringBuffer.append(LEFT_BRACKET);
            stringBuffer.append(LEFT_BRACE);
            stringBuffer.append(string);
            stringBuffer.append(LEFT_BRACE);
            stringBuffer.append(filter);
            stringBuffer.append(this.add(iTripleConditionExpression.getExpression2()));
            stringBuffer.append(RIGHT_BRACE);
            stringBuffer.append(RIGHT_BRACE);
            stringBuffer.append(COMMA);
            stringBuffer.append(LEFT_BRACE);
            stringBuffer.append(string);
            stringBuffer.append(LEFT_BRACE);
            stringBuffer.append(equalsIgnoreCase);
            stringBuffer.append(this.add(iTripleConditionExpression.getExpression3()));
            stringBuffer.append(RIGHT_BRACE);
            stringBuffer.append(RIGHT_BRACE);
            stringBuffer.append(RIGHT_BRACKET);
            stringBuffer.append(RIGHT_BRACE);
        } else if (OperatorToolKit.isBetween(iTupleOperator.operatorType()) && bl || OperatorToolKit.isNotBetween(iTupleOperator.operatorType()) && !bl) {
            stringBuffer.append(LEFT_BRACE);
            stringBuffer.append(OR);
            stringBuffer.append(LEFT_BRACKET);
            stringBuffer.append(LEFT_BRACE);
            stringBuffer.append(string);
            stringBuffer.append(LEFT_BRACE);
            stringBuffer.append(equalsIgnoreCase);
            stringBuffer.append(this.add(iTripleConditionExpression.getExpression2()));
            stringBuffer.append(RIGHT_BRACE);
            stringBuffer.append(RIGHT_BRACE);
            stringBuffer.append(COMMA);
            stringBuffer.append(LEFT_BRACE);
            stringBuffer.append(string);
            stringBuffer.append(LEFT_BRACE);
            stringBuffer.append(filter);
            stringBuffer.append(this.add(iTripleConditionExpression.getExpression3()));
            stringBuffer.append(RIGHT_BRACE);
            stringBuffer.append(RIGHT_BRACE);
            stringBuffer.append(RIGHT_BRACKET);
            stringBuffer.append(RIGHT_BRACE);
        } else {
            throw new DSException(2522, new Object[]{"triple condition op type error : " + iTupleOperator.operatorType()});
        }
        return stringBuffer.toString();
    }

    private String convertDateString(IBinaryConditionExpression iBinaryConditionExpression) throws DSException {
        return this.equals(iBinaryConditionExpression, false);
    }

    private String equals(IBinaryConditionExpression iBinaryConditionExpression, boolean bl) throws DSException {
        ITupleOperator iTupleOperator = iBinaryConditionExpression.getOperator();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        boolean bl3 = false;
        IExpression iExpression = iBinaryConditionExpression.getExpression1();
        if (ExpressionToolKit.isVariableExp(iExpression.expressionType()) && this.isVarExpFieldPass1F((IVariableExpression)iExpression)) {
            bl2 = true;
        }
        IExpression iExpression2 = iBinaryConditionExpression.getExpression2();
        if (!bl2 && ExpressionToolKit.isVariableExp(iExpression2.expressionType()) && this.isVarExpFieldPass1F((IVariableExpression)iExpression2)) {
            bl3 = true;
        }
        if (!bl2 && !bl3) {
            boolean bl4 = new ConstantFilter(iBinaryConditionExpression).filter();
            if (bl4 && !bl || !bl4 && bl) {
                return getExpression2;
            }
            return getExpression3;
        }
        stringBuffer.append(LEFT_BRACE);
        if (bl2) {
            stringBuffer.append(this.add(iExpression));
        } else {
            stringBuffer.append(this.add(iExpression2));
        }
        stringBuffer.append(SPACE);
        boolean bl5 = true;
        if (iTupleOperator.operatorType() != 556793860 && iTupleOperator.operatorType() != 556793864 && iTupleOperator.operatorType() != 556793872 && iTupleOperator.operatorType() != 556793888) {
            stringBuffer.append(LEFT_BRACE);
        }
        switch (iTupleOperator.operatorType()) {
            case 556793872: {
                if (bl) {
                    stringBuffer.append(LEFT_BRACE);
                    stringBuffer.append(equals);
                    break;
                }
                stringBuffer.append("");
                bl5 = false;
                break;
            }
            case 556793888: {
                if (bl) {
                    stringBuffer.append("");
                    bl5 = false;
                    break;
                }
                stringBuffer.append(LEFT_BRACE);
                stringBuffer.append(equals);
                break;
            }
            case 556794112: {
                if (bl) {
                    if (bl2) {
                        stringBuffer.append(filter);
                        break;
                    }
                    stringBuffer.append(expressionType);
                    break;
                }
                if (bl2) {
                    stringBuffer.append(equalsIgnoreCase);
                    break;
                }
                stringBuffer.append(get);
                break;
            }
            case 556794368: {
                if (bl) {
                    if (bl2) {
                        stringBuffer.append(get);
                        break;
                    }
                    stringBuffer.append(equalsIgnoreCase);
                    break;
                }
                if (bl2) {
                    stringBuffer.append(expressionType);
                    break;
                }
                stringBuffer.append(filter);
                break;
            }
            case 556793984: {
                if (bl) {
                    if (bl2) {
                        stringBuffer.append(equalsIgnoreCase);
                        break;
                    }
                    stringBuffer.append(get);
                    break;
                }
                if (bl2) {
                    stringBuffer.append(filter);
                    break;
                }
                stringBuffer.append(expressionType);
                break;
            }
            case 556793920: {
                if (bl) {
                    if (bl2) {
                        stringBuffer.append(expressionType);
                        break;
                    }
                    stringBuffer.append(filter);
                    break;
                }
                if (bl2) {
                    stringBuffer.append(get);
                    break;
                }
                stringBuffer.append(equalsIgnoreCase);
                break;
            }
            case 556793857: {
                if (bl) {
                    stringBuffer.append(getDataType);
                    break;
                }
                stringBuffer.append(getDSName);
                break;
            }
            case 556793858: {
                if (bl) {
                    stringBuffer.append(getDSName);
                    break;
                }
                stringBuffer.append(getDataType);
                break;
            }
            case 556793860: {
                if (bl) {
                    stringBuffer.append(LEFT_BRACE);
                    stringBuffer.append(containsIgnoreCase);
                    break;
                }
                bl5 = false;
                break;
            }
            case 556793864: {
                if (!bl) {
                    stringBuffer.append(LEFT_BRACE);
                    stringBuffer.append(containsIgnoreCase);
                    break;
                }
                bl5 = false;
                break;
            }
            default: {
                throw new DSException(2524, new Object[]{"binary condition op type error : " + iTupleOperator.operatorType()});
            }
        }
        stringBuffer.append(SPACE);
        if (iTupleOperator.operatorType() != 556793860 && iTupleOperator.operatorType() != 556793864) {
            String string = null;
            string = bl2 ? this.add(iExpression2).trim() : this.add(iExpression).trim();
            if ((iTupleOperator.operatorType() == 556793857 || iTupleOperator.operatorType() == 556793858) && string.startsWith(LEFT_PAREN)) {
                string = LEFT_BRACKET + string.substring(1, string.length() - 1) + RIGHT_BRACKET;
            }
            stringBuffer.append(string);
        } else {
            String string = null;
            IExpression iExpression3 = null;
            iExpression3 = bl2 ? iExpression2 : iExpression;
            try {
                string = iExpression3 instanceof IConstant ? ((IConstant)iExpression3).getValue() : iExpression3.getStringValue(false);
            }
            catch (Exception exception) {
                string = iExpression3.toString();
            }
            stringBuffer.append(ExpressionUtil.transformLikeExpression(string));
        }
        if (bl5) {
            stringBuffer.append(RIGHT_BRACE);
        }
        stringBuffer.append(RIGHT_BRACE);
        return stringBuffer.toString();
    }

    private String equalsIgnoreCase(ILogicExpression iLogicExpression) throws DSException {
        if (OperatorToolKit.isSingleLogicOperator(iLogicExpression.getOperator().operatorType())) {
            return this.filterString((ISingleLogicExpression)iLogicExpression);
        }
        if (OperatorToolKit.isMultiLogicOperator(iLogicExpression.getOperator().operatorType())) {
            return this.expressionType((IMultiTupleExpression)((Object)iLogicExpression));
        }
        throw new DSException(2525, new Object[]{"logic exp type error : " + iLogicExpression.expressionType()});
    }

    private String expressionType(IMultiTupleExpression iMultiTupleExpression) throws DSException {
        return this.filter(iMultiTupleExpression, false);
    }

    private String filter(IMultiTupleExpression iMultiTupleExpression, boolean bl) throws DSException {
        IExpression[] iExpressionArray = iMultiTupleExpression.getExpressions();
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        if (OperatorToolKit.isOr(iMultiTupleExpression.getOperator().operatorType())) {
            string = bl ? AND : OR;
        } else if (OperatorToolKit.isAnd(iMultiTupleExpression.getOperator().operatorType())) {
            string = bl ? OR : AND;
        } else {
            throw new DSException(2526, new Object[]{"multiple logic exp type error : " + iMultiTupleExpression.expressionType()});
        }
        stringBuffer.append(string);
        stringBuffer.append(LEFT_BRACKET);
        for (int i = 0; i < iExpressionArray.length; ++i) {
            String string2 = null;
            string2 = bl ? this.get(iExpressionArray[i]) : this.add(iExpressionArray[i]);
            if (string2.equalsIgnoreCase(getExpression2) && string.equals(AND) || string2.equalsIgnoreCase(getExpression3) && string.equals(OR)) continue;
            if (string2.equalsIgnoreCase(getExpression3) && string.equals(AND)) {
                return getExpression3;
            }
            if (string2.equalsIgnoreCase(getExpression2) && string.equals(OR)) {
                return getExpression2;
            }
            stringBuffer.append(string2);
            if (i >= iExpressionArray.length - 1) continue;
            stringBuffer.append(SPACE);
            stringBuffer.append(COMMA);
            stringBuffer.append(SPACE);
        }
        stringBuffer.append(RIGHT_BRACKET);
        return LEFT_BRACE + stringBuffer.toString() + RIGHT_BRACE;
    }

    private String filterString(ISingleLogicExpression iSingleLogicExpression) throws DSException {
        StringBuffer stringBuffer = new StringBuffer();
        IExpression iExpression = iSingleLogicExpression.getExpression();
        try {
            if (iExpression instanceof IConstant && (((IConstant)iExpression).getValue().equalsIgnoreCase("true") || ((IConstant)iExpression).getValue().equalsIgnoreCase("false"))) {
                if (((IConstant)iExpression).getValue().equalsIgnoreCase("true")) {
                    stringBuffer.append(getExpression3);
                } else {
                    stringBuffer.append(getExpression2);
                }
            } else {
                stringBuffer.append(this.get(iExpression));
            }
            return stringBuffer.toString();
        }
        catch (ConditionException conditionException) {
            throw new DSException(2527, new Object[]{"sub exp type error : " + iExpression.expressionType()});
        }
    }

    private String get(IExpression iExpression) throws DSException {
        if (ExpressionToolKit.isLogicExp(iExpression.expressionType())) {
            ILogicExpression iLogicExpression = (ILogicExpression)iExpression;
            if (OperatorToolKit.isSingleLogicOperator(iLogicExpression.getOperator().operatorType())) {
                return this.add(((ISingleLogicExpression)iExpression).getExpression());
            }
            if (OperatorToolKit.isMultiLogicOperator(iLogicExpression.getOperator().operatorType())) {
                return this.filter((IMultiTupleExpression)iExpression, true);
            }
        } else if (ExpressionToolKit.isConditionExp(iExpression.expressionType())) {
            if (ExpressionToolKit.isBinaryConditionExp(iExpression.expressionType())) {
                return this.equals((IBinaryConditionExpression)iExpression, true);
            }
            if (ExpressionToolKit.isTripleConditonExp(iExpression.expressionType())) {
                return this.containsIgnoreCase((ITripleConditionExpression)iExpression, true);
            }
        }
        return "";
    }

    private String getDSName(IExpression iExpression) throws DSException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.add(iExpression));
        return stringBuffer.toString();
    }

    private String getDataType(IExpression iExpression) throws DSException {
        if (ExpressionToolKit.isReference(iExpression.expressionType()) || ExpressionToolKit.isFormula(iExpression.expressionType())) {
            return this.getExpression2(iExpression);
        }
        if (ExpressionToolKit.isConstant(iExpression.expressionType())) {
            return this.getExpression((IConstant)iExpression);
        }
        if (ExpressionToolKit.isVariableList(iExpression.expressionType())) {
            return this.getExpression1((IVariableList)iExpression);
        }
        if (ExpressionToolKit.isParameter(iExpression.expressionType())) {
            return this.getExpression2(iExpression);
        }
        throw new DSException(2527, new Object[]{"sub exp type error : " + iExpression.expressionType()});
    }

    private String getExpression(IConstant iConstant) throws DSException {
        try {
            if (Types.isTimeType(iConstant.getDataType())) {
                if (iConstant.getValue() == null) {
                    throw new DSException(2528, new Object[]{"constant date value was null"});
                }
                return QueryTransform.convertDateString((Date)iConstant.getObjectValue(), iConstant.getDataType(), this.supportInfo);
            }
            if (Types.isStringType(iConstant.getDataType())) {
                return StringTools.getSQLString4pushdownParser(iConstant.getValue());
            }
            return this.getFormulaPushDownString(iConstant.getValue());
        }
        catch (ConditionException conditionException) {
            throw new DSException(2529, new Object[]{"ConditionException"}, (Throwable)conditionException);
        }
    }

    private String getExpression1(IVariableList iVariableList) throws DSException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LEFT_PAREN);
        try {
            for (int i = 0; i < iVariableList.size(); ++i) {
                stringBuffer.append(this.add(iVariableList.getVariableExp(i)));
                if (i >= iVariableList.size() - 1) continue;
                stringBuffer.append(COMMA);
                stringBuffer.append(SPACE);
            }
        }
        catch (ConditionException conditionException) {
            throw new DSException(2530, new Object[]{"ConditionException"}, (Throwable)conditionException);
        }
        stringBuffer.append(RIGHT_PAREN);
        return stringBuffer.toString();
    }

    private String getExpression2(IExpression iExpression) throws DSException {
        String string;
        block11: {
            string = null;
            try {
                if (this.resource.containsIgnoreCase(iExpression.getName())) {
                    if (ExpressionToolKit.isReference(iExpression.expressionType())) {
                        this.resource.getStringValue();
                        if (!this.resource.wasField()) {
                            throw new DSException(2531, new Object[]{string + " is not db field"});
                        }
                        JAttribute jAttribute = this.resource.getJAttribute();
                        if (!(jAttribute instanceof JRdbDataField)) {
                            throw new DSException(2532, new Object[]{iExpression.getName() + " not rdb data field"});
                        }
                        string = NamingTools.getDSName((RdbConnection)this.connection, (JRdbDataField)jAttribute) + append;
                    } else if (ExpressionToolKit.isFormula(iExpression.expressionType())) {
                        string = this.resource.getFormulaPushDownString();
                        if (!this.resource.wasFormula()) {
                            throw new DSException(2533, new Object[]{string + " is not formula"});
                        }
                    } else if (ExpressionToolKit.isParameter(iExpression.expressionType())) {
                        ParameterImpl parameterImpl = (ParameterImpl)iExpression;
                        string = parameterImpl.getStringValue(true);
                    }
                    break block11;
                }
                throw new DSException(2534, new Object[]{"internal error, can not found " + string + " in resource container"});
            }
            catch (ConditionException conditionException) {
                throw new DSException(2535, new Object[]{"ConditionException"}, (Throwable)conditionException);
            }
        }
        return string;
    }

    @Override
    public String getSQLSortString() throws DSException {
        if (this.sortString == null) {
            if (this.pushSortExp == null) {
                return null;
            }
            ISortInformation[] iSortInformationArray = null;
            IOperatorInformation iOperatorInformation = ((ISortOperator)this.pushSortExp.getOperator()).getOperatorInformation();
            if (OperatorInfoToolkit.isSortInformation(iOperatorInformation.informationType())) {
                ISortInformation iSortInformation = (ISortInformation)iOperatorInformation;
                iSortInformationArray = new ISortInformation[]{iSortInformation};
            } else if (OperatorInfoToolkit.isSortInformationCollector(iOperatorInformation.informationType())) {
                ISortInformationCollector iSortInformationCollector = (ISortInformationCollector)iOperatorInformation;
                iSortInformationArray = new ISortInformation[iSortInformationCollector.size()];
                for (int i = 0; i < iSortInformationArray.length; ++i) {
                    iSortInformationArray[i] = iSortInformationCollector.getSortInformation(i);
                }
            }
            this.sortString = this.getExpression3(iSortInformationArray);
        }
        return this.sortString;
    }

    private String getExpression3(ISortInformation[] iSortInformationArray) throws DSException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < iSortInformationArray.length; ++i) {
            if (iSortInformationArray[i].getSortType() == 0) continue;
            stringBuffer.append(this.getExpression2(iSortInformationArray[i].getReference()));
            stringBuffer.append(SPACE);
            stringBuffer.append(this.getExpressions(iSortInformationArray[i]));
            if (i >= iSortInformationArray.length - 1) continue;
            stringBuffer.append(COMMA);
            stringBuffer.append(SPACE);
        }
        return stringBuffer.length() < 1 ? null : stringBuffer.toString().trim();
    }

    private String getExpressions(ISortInformation iSortInformation) throws DSException {
        if (iSortInformation.getSortType() == 1) {
            return "ASC";
        }
        if (iSortInformation.getSortType() == 2) {
            return "DESC";
        }
        throw new DSException(2536, new Object[]{"sort type error : " + iSortInformation.getSortType()});
    }

    private String getFormulaPushDownString(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (!Character.isWhitespace(cArray[i])) continue;
            bl = true;
            break;
        }
        if (bl) {
            return QUOTE + string + QUOTE;
        }
        return string;
    }

    @Override
    public String getSQLTopNString() throws DSException {
        throw new UnsupportedOperationException();
    }
}

