/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.pushdown;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.datasource.JDSDataField;
import java.text.SimpleDateFormat;
import jet.connect.DbDate;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IBinary;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.IMulti;
import jet.dataengine.api.expression.ISingle;
import jet.dataengine.api.expression.ITriple;
import jet.dataengine.api.expression.set.ISetExpression;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IFormula;
import jet.dataengine.api.expression.variable.IParameter;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine8.core.queryengine.sqltoolkit.ResourceContainer;
import jet.log.JRLogger;
import jet.util.CharBinaryFormat;

class ParameterProcessor {
    private ParameterValueList I;
    private ResourceContainer SEDU;
    private static JRLogger Z = JRLogger.getLogger(ParameterProcessor.class.getName());

    public ParameterProcessor(ResourceContainer resourceContainer, ParameterValueList parameterValueList) {
        this.SEDU = resourceContainer;
        this.I = parameterValueList;
    }

    public void processParameters(IExpression iExpression) throws DSException {
        this.process(null, iExpression, -1);
    }

    private void process(IExpression iExpression, IExpression iExpression2, int n) throws DSException {
        if (iExpression2 != null) {
            if (ExpressionToolKit.isSetExp(iExpression2.expressionType())) {
                this.I((ISetExpression)iExpression2);
                this.process(iExpression2, ((ISetExpression)iExpression2).getExpression(), 1);
            } else if (ExpressionToolKit.isVariableExp(iExpression2.expressionType())) {
                this.SEDU(iExpression, (IVariableExpression)iExpression2, n);
            } else if (ExpressionToolKit.isSingleExp(iExpression2.expressionType())) {
                this.process(iExpression2, ((ISingle)((Object)iExpression2)).getExpression(), 1);
            } else if (ExpressionToolKit.isBinaryExp(iExpression2.expressionType())) {
                this.process(iExpression2, ((IBinary)((Object)iExpression2)).getExpression1(), 1);
                this.process(iExpression2, ((IBinary)((Object)iExpression2)).getExpression2(), 2);
            } else if (ExpressionToolKit.isTripleExp(iExpression2.expressionType())) {
                this.process(iExpression2, ((ITriple)((Object)iExpression2)).getExpression1(), 1);
                this.process(iExpression2, ((ITriple)((Object)iExpression2)).getExpression2(), 2);
                this.process(iExpression2, ((ITriple)((Object)iExpression2)).getExpression3(), 3);
            } else if (ExpressionToolKit.isMultiExp(iExpression2.expressionType())) {
                IMulti iMulti = (IMulti)((Object)iExpression2);
                IExpression[] iExpressionArray = iMulti.getExpressions();
                for (int i = 0; i < iExpressionArray.length; ++i) {
                    this.process(iExpression2, iExpressionArray[i], -1);
                }
            }
        }
    }

    private void I(ISetExpression iSetExpression) throws DSException {
    }

    private void SEDU(IExpression iExpression, IVariableExpression iVariableExpression, int n) throws DSException {
        try {
            if (ExpressionToolKit.isParameter(iVariableExpression.expressionType())) {
                this.Z(iExpression, (IParameter)iVariableExpression, n);
            } else if (ExpressionToolKit.isVariableList(iVariableExpression.expressionType())) {
                IVariableList iVariableList = (IVariableList)iVariableExpression;
                for (int i = 0; i < iVariableList.size(); ++i) {
                    this.SEDU(iVariableList, iVariableList.getVariableExp(i), i);
                }
            }
        }
        catch (ConditionException conditionException) {
            throw new DSException(2540, new Object[]{"Condition Exception"}, (Throwable)conditionException);
        }
    }

    private void Z(IExpression iExpression, IParameter iParameter, int n) throws DSException {
        block13: {
            try {
                IVariableExpression iVariableExpression = this.contains(iParameter);
                if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
                    if (n == 1) {
                        ((ISingle)((Object)iExpression)).setExpression(iVariableExpression);
                        break block13;
                    }
                    throw new DSException(2541, new Object[]{"set par index error" + n});
                }
                if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
                    if (n == 1) {
                        ((IBinary)((Object)iExpression)).setExpression1(iVariableExpression);
                        break block13;
                    }
                    if (n == 2) {
                        ((IBinary)((Object)iExpression)).setExpression2(iVariableExpression);
                        break block13;
                    }
                    throw new DSException(2542, new Object[]{"set par index error" + n});
                }
                if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
                    if (n == 1) {
                        ((ITriple)((Object)iExpression)).setExpression1(iVariableExpression);
                        break block13;
                    }
                    if (n == 2) {
                        ((ITriple)((Object)iExpression)).setExpression2(iVariableExpression);
                        break block13;
                    }
                    if (n == 3) {
                        ((ITriple)((Object)iExpression)).setExpression3(iVariableExpression);
                        break block13;
                    }
                    throw new DSException(2543, new Object[]{"set par index error" + n});
                }
                if (!ExpressionToolKit.isVariableList(iExpression.expressionType())) break block13;
                IVariableList iVariableList = (IVariableList)iExpression;
                if (this.append(iParameter)) {
                    iVariableList.setFormula((IFormula)iVariableExpression, n);
                    break block13;
                }
                if (this.bNull(iParameter)) {
                    iVariableList.setConstant((IConstant)iVariableExpression, n);
                    break block13;
                }
                throw new DSException(2544, new Object[]{"set par type error"});
            }
            catch (ConditionException conditionException) {
                throw new DSException(2545, new Object[]{"Condition Exception"}, (Throwable)conditionException);
            }
        }
    }

    private boolean append(IVariableExpression iVariableExpression) throws DSException {
        try {
            if (this.SEDU.containsIgnoreCase(iVariableExpression.getName())) {
                this.SEDU.getStringValue();
                if (this.SEDU.wasFormula()) {
                    return true;
                }
            }
            return false;
        }
        catch (ConditionException conditionException) {
            throw new DSException(2546, new Object[]{"condition exception"}, (Throwable)conditionException);
        }
    }

    private boolean bNull(IVariableExpression iVariableExpression) throws DSException {
        try {
            if (this.SEDU.containsIgnoreCase(iVariableExpression.getName())) {
                return true;
            }
        }
        catch (ConditionException conditionException) {
            throw new DSException(2547, new Object[]{"condition exception"}, (Throwable)conditionException);
        }
        return false;
    }

    private IVariableExpression contains(IVariableExpression iVariableExpression) throws DSException {
        try {
            IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
            if (!this.I.contains(iVariableExpression.getName())) {
                throw new DSException(2548, new Object[]{"can not found parameter : " + iVariableExpression.getName() + " in resource container"});
            }
            DbValue dbValue = this.I.getValue(iVariableExpression.getName());
            Object object = null;
            if (this.SEDU.containsIgnoreCase(dbValue.toString())) {
                String string = this.SEDU.getStringValue();
                if (this.SEDU.wasField()) {
                    IReference iReference = iExpressionFactory.createReference(string);
                    this.containsIgnoreCase((JDSDataField)this.SEDU.getJAttribute(), iReference);
                    object = iReference;
                } else if (this.SEDU.wasFormula()) {
                    string = this.I.getValue(iVariableExpression.getName()).toString();
                    object = iExpressionFactory.createFormula(string);
                }
            } else {
                Object object2;
                DbValue dbValue2 = this.I.getValue(iVariableExpression.getName());
                String string = this.SEDU.getEscapeCharacters();
                String string2 = this.SEDU.getEscapeReplaced();
                String string3 = ParameterProcessor.parseParToString(dbValue2);
                if (string != null && dbValue2.getSqlType() == 12 && string3 != null) {
                    object2 = string3;
                    string3 = string3.replace(string, string2);
                    if (Z.isDebugEnabled()) {
                        Z.debug("\t###EscapeReplaceCharacters### ParameterProcessor.parsePar()... replace string-type of parameter's value: oldVal =" + (String)object2 + ", newVal =" + string3 + "; paramName =" + iVariableExpression.getName() + "; strEscapeCharacters =" + string + ", strEscapeReplaced=" + string2);
                    }
                }
                object2 = iExpressionFactory.createConstant(string3);
                object2.setNull(dbValue2.bNull);
                object2.setDataType(Types.sqlTypeToType(dbValue2.getSqlType()));
                object = object2;
            }
            return object;
        }
        catch (ConditionException conditionException) {
            throw new DSException(2549, new Object[]{"condition exception"}, (Throwable)conditionException);
        }
    }

    private void containsIgnoreCase(JDSDataField jDSDataField, IReference iReference) throws DSException {
        try {
            iReference.setDataType(jDSDataField.getDataType());
            iReference.setLength(jDSDataField.getLength());
            iReference.setCaseSensitive(jDSDataField.isCaseSensitive());
            iReference.setCurrency(jDSDataField.isCurrency());
            iReference.setNullable(jDSDataField.isNullable());
            iReference.setPrecision(jDSDataField.getPrecision());
            iReference.setScale(jDSDataField.getScale());
        }
        catch (ConditionException conditionException) {
            throw new DSException(2550, new Object[]{"Condition Exception"}, (Throwable)conditionException);
        }
    }

    static String parseParToString(DbValue dbValue) {
        String string = null;
        SimpleDateFormat simpleDateFormat = null;
        if (dbValue.getSqlType() == 91) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            string = simpleDateFormat.format(((DbDate)dbValue).getDate());
        } else if (dbValue.getSqlType() == 92) {
            simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            string = simpleDateFormat.format(((DbTime)dbValue).getTime());
        } else if (dbValue.getSqlType() == 93) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            string = simpleDateFormat.format(((DbTimestamp)dbValue).getTimestamp());
        } else {
            string = dbValue.desc.sqlType == 12 ? new CharBinaryFormat("XX").format(dbValue) : dbValue.toString();
        }
        return string;
    }
}

