/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.pushdown;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.datasource.JDSConnection;
import com.jinfonet.dataservice.api.schema.relational.datasource.relational.JRdbDataField;
import com.jinfonet.dataservice.expression.variable.ParameterImpl;
import com.jinfonet.dataservice.schema.relational.datasource.relational.RdbConnection;
import java.util.Date;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IOperatorInformation;
import jet.dataengine.api.expression.OperatorInfoToolkit;
import jet.dataengine.api.expression.OperatorToolKit;
import jet.dataengine.api.expression.info.ISortInformation;
import jet.dataengine.api.expression.info.ISortInformationCollector;
import jet.dataengine.api.expression.set.op.ISortOperator;
import jet.dataengine.api.expression.tuple.IBinaryConditionExpression;
import jet.dataengine.api.expression.tuple.IConditionExpression;
import jet.dataengine.api.expression.tuple.ILogicExpression;
import jet.dataengine.api.expression.tuple.IMultiTupleExpression;
import jet.dataengine.api.expression.tuple.ISingleConditionExpression;
import jet.dataengine.api.expression.tuple.ISingleLogicExpression;
import jet.dataengine.api.expression.tuple.ITripleConditionExpression;
import jet.dataengine.api.expression.tuple.op.ITupleOperator;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.dataengine.util.StringTools;
import jet.dataengine8.core.pushdown.ExpPushDownParser;
import jet.dataengine8.core.queryengine.querybuilder.info.NamingTools;
import jet.dataengine8.core.queryengine.sqltoolkit.ResourceContainer;
import jet.dataengine8.core.queryengine.transform.QueryTransform;
import jet.universe.JetUSupportInfo;

class SQL92PushDownParser
extends ExpPushDownParser {
    private static final String SEDU = "(";
    private static final String append = ")";
    private static final String containsIgnoreCase = " ";
    private static final String convertDateString = "'";
    private static final String equalsIgnoreCase = ",";
    private static final String expressionType = "IS NULL";
    private static final String get = "IS NOT NULL";
    private static final String getComputedColExp = "AND";
    private static final String getDSName = "OR";
    private static final String getDataType = "NOT";
    private static final String getExpression = "=";
    private static final String getExpression1 = "<>";
    private static final String getExpression2 = "<";
    private static final String getExpression3 = "<=";
    private static final String getExpressions = ">=";
    private static final String getFormulaPushDownString = ">";
    private static final String getJAttribute = "IN";
    private static final String getName = "LIKE";
    private static final String getObjectValue = "BETWEEN";

    protected SQL92PushDownParser(ResourceContainer resourceContainer, JDSConnection jDSConnection, JetUSupportInfo jetUSupportInfo) throws DSException {
        super(resourceContainer, jDSConnection, jetUSupportInfo);
    }

    @Override
    public String getSQLConditionString() throws DSException {
        if (this.filterString == null) {
            if (this.pushFilterExps.size() < 1) {
                return null;
            }
            if (this.pushFilterExps.size() == 1) {
                this.filterString = this.containsIgnoreCase((IExpression)this.pushFilterExps.get(0));
            } else {
                String[] stringArray = new String[this.pushFilterExps.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = this.containsIgnoreCase((IExpression)this.pushFilterExps.get(i));
                }
                this.filterString = this.SEDU(stringArray);
            }
        }
        return this.filterString;
    }

    private String SEDU(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(SEDU);
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(append);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(containsIgnoreCase);
            stringBuffer.append(getComputedColExp);
            stringBuffer.append(containsIgnoreCase);
        }
        return stringBuffer.toString().trim();
    }

    private String containsIgnoreCase(IExpression iExpression) throws DSException {
        if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            return this.getExpression(iExpression);
        }
        if (ExpressionToolKit.isLogicExp(iExpression.expressionType())) {
            return this.get((ILogicExpression)iExpression);
        }
        if (ExpressionToolKit.isConditionExp(iExpression.expressionType())) {
            return this.convertDateString((IConditionExpression)iExpression);
        }
        throw new DSException(2520, new Object[]{"local condition exp type error : " + iExpression.expressionType()});
    }

    private String convertDateString(IConditionExpression iConditionExpression) throws DSException {
        if (ExpressionToolKit.isSingleConditionExp(iConditionExpression.expressionType())) {
            return this.expressionType((ISingleConditionExpression)iConditionExpression);
        }
        if (ExpressionToolKit.isBinaryConditionExp(iConditionExpression.expressionType())) {
            return this.filterString((IBinaryConditionExpression)iConditionExpression);
        }
        if (ExpressionToolKit.isTripleConditonExp(iConditionExpression.expressionType())) {
            return this.equalsIgnoreCase((ITripleConditionExpression)iConditionExpression);
        }
        throw new DSException(2521, new Object[]{"condition exp type error : " + iConditionExpression.expressionType()});
    }

    private String equalsIgnoreCase(ITripleConditionExpression iTripleConditionExpression) throws DSException {
        ITupleOperator iTupleOperator = iTripleConditionExpression.getOperator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDataType(iTripleConditionExpression.getExpression1()));
        stringBuffer.append(containsIgnoreCase);
        if (OperatorToolKit.isBetween(iTupleOperator.operatorType())) {
            stringBuffer.append(getObjectValue);
        } else if (OperatorToolKit.isNotBetween(iTupleOperator.operatorType())) {
            stringBuffer.append(getDataType);
            stringBuffer.append(containsIgnoreCase);
            stringBuffer.append(getObjectValue);
        } else {
            throw new DSException(2522, new Object[]{"triple condition op type error : " + iTupleOperator.operatorType()});
        }
        stringBuffer.append(containsIgnoreCase);
        stringBuffer.append(this.getDataType(iTripleConditionExpression.getExpression2()));
        stringBuffer.append(containsIgnoreCase);
        stringBuffer.append(getComputedColExp);
        stringBuffer.append(containsIgnoreCase);
        stringBuffer.append(this.getDataType(iTripleConditionExpression.getExpression3()));
        return stringBuffer.toString();
    }

    private String expressionType(ISingleConditionExpression iSingleConditionExpression) throws DSException {
        ITupleOperator iTupleOperator = iSingleConditionExpression.getOperator();
        if (OperatorToolKit.isNull(iTupleOperator.operatorType())) {
            return this.containsIgnoreCase(iSingleConditionExpression.getExpression()) + containsIgnoreCase + expressionType;
        }
        if (OperatorToolKit.isNotNull(iTupleOperator.operatorType())) {
            return this.containsIgnoreCase(iSingleConditionExpression.getExpression()) + containsIgnoreCase + get;
        }
        throw new DSException(2523, new Object[]{"single condition op type error : " + iTupleOperator.operatorType()});
    }

    private String filterString(IBinaryConditionExpression iBinaryConditionExpression) throws DSException {
        ITupleOperator iTupleOperator = iBinaryConditionExpression.getOperator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDataType(iBinaryConditionExpression.getExpression1()));
        stringBuffer.append(containsIgnoreCase);
        switch (iTupleOperator.operatorType()) {
            case 556793872: {
                stringBuffer.append(getExpression);
                break;
            }
            case 556793888: {
                stringBuffer.append(getExpression1);
                break;
            }
            case 556794112: {
                stringBuffer.append(getExpression2);
                break;
            }
            case 556794368: {
                stringBuffer.append(getExpression3);
                break;
            }
            case 556793984: {
                stringBuffer.append(getExpressions);
                break;
            }
            case 556793920: {
                stringBuffer.append(getFormulaPushDownString);
                break;
            }
            case 556793857: {
                stringBuffer.append(getJAttribute);
                break;
            }
            case 556793858: {
                stringBuffer.append(getDataType);
                stringBuffer.append(containsIgnoreCase);
                stringBuffer.append(getJAttribute);
                break;
            }
            case 556793860: {
                stringBuffer.append(getName);
                break;
            }
            case 556793864: {
                stringBuffer.append(getDataType);
                stringBuffer.append(containsIgnoreCase);
                stringBuffer.append(getName);
                break;
            }
            default: {
                throw new DSException(2524, new Object[]{"binary condition op type error : " + iTupleOperator.operatorType()});
            }
        }
        stringBuffer.append(containsIgnoreCase);
        stringBuffer.append(this.getDataType(iBinaryConditionExpression.getExpression2()));
        return stringBuffer.toString();
    }

    private String get(ILogicExpression iLogicExpression) throws DSException {
        if (OperatorToolKit.isSingleLogicOperator(iLogicExpression.getOperator().operatorType())) {
            return this.getDSName((ISingleLogicExpression)iLogicExpression);
        }
        if (OperatorToolKit.isMultiLogicOperator(iLogicExpression.getOperator().operatorType())) {
            return this.getComputedColExp((IMultiTupleExpression)((Object)iLogicExpression));
        }
        throw new DSException(2525, new Object[]{"logic exp type error : " + iLogicExpression.expressionType()});
    }

    private String getComputedColExp(IMultiTupleExpression iMultiTupleExpression) throws DSException {
        IExpression[] iExpressionArray = iMultiTupleExpression.getExpressions();
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        if (OperatorToolKit.isOr(iMultiTupleExpression.getOperator().operatorType())) {
            string = getDSName;
        } else if (OperatorToolKit.isAnd(iMultiTupleExpression.getOperator().operatorType())) {
            string = getComputedColExp;
        } else {
            throw new DSException(2526, new Object[]{"multiple logic exp type error : " + iMultiTupleExpression.expressionType()});
        }
        stringBuffer.append(this.getDataType(iExpressionArray[0]));
        for (int i = 1; i < iExpressionArray.length; ++i) {
            stringBuffer.append(containsIgnoreCase);
            stringBuffer.append(string);
            stringBuffer.append(containsIgnoreCase);
            stringBuffer.append(this.getDataType(iExpressionArray[i]));
        }
        return stringBuffer.toString();
    }

    private String getDSName(ISingleLogicExpression iSingleLogicExpression) throws DSException {
        StringBuffer stringBuffer = new StringBuffer();
        IExpression iExpression = iSingleLogicExpression.getExpression();
        try {
            if (iExpression instanceof IConstant && (((IConstant)iExpression).getValue().equalsIgnoreCase("true") || ((IConstant)iExpression).getValue().equalsIgnoreCase("false"))) {
                if (((IConstant)iExpression).getValue().equalsIgnoreCase("true")) {
                    stringBuffer.append(" 1<>1 ");
                } else {
                    stringBuffer.append(" 1=1 ");
                }
            } else {
                stringBuffer.append(getDataType);
                stringBuffer.append(containsIgnoreCase);
                stringBuffer.append(this.getDataType(iSingleLogicExpression.getExpression()));
            }
            return stringBuffer.toString();
        }
        catch (ConditionException conditionException) {
            throw new DSException(2527, new Object[]{"sub exp type error : " + iExpression.expressionType()});
        }
    }

    private String getDataType(IExpression iExpression) throws DSException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            stringBuffer.append(SEDU);
        }
        stringBuffer.append(this.containsIgnoreCase(iExpression));
        if (!ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            stringBuffer.append(append);
        }
        return stringBuffer.toString();
    }

    private String getExpression(IExpression iExpression) throws DSException {
        if (ExpressionToolKit.isReference(iExpression.expressionType()) || ExpressionToolKit.isFormula(iExpression.expressionType())) {
            return this.getExpression3(iExpression);
        }
        if (ExpressionToolKit.isConstant(iExpression.expressionType())) {
            return this.getExpression1((IConstant)iExpression);
        }
        if (ExpressionToolKit.isVariableList(iExpression.expressionType())) {
            return this.getExpression2((IVariableList)iExpression);
        }
        if (ExpressionToolKit.isParameter(iExpression.expressionType())) {
            return this.getExpression3(iExpression);
        }
        throw new DSException(2527, new Object[]{"sub exp type error : " + iExpression.expressionType()});
    }

    private String getExpression1(IConstant iConstant) throws DSException {
        try {
            if (Types.isTimeType(iConstant.getDataType())) {
                if (iConstant.getValue() == null) {
                    throw new DSException(2528, new Object[]{"constant date value was null"});
                }
                return QueryTransform.convertDateString((Date)iConstant.getObjectValue(), iConstant.getDataType(), this.supportInfo);
            }
            if (Types.isStringType(iConstant.getDataType())) {
                return StringTools.getSQLString4pushdownParser(iConstant.getValue());
            }
            return this.getJAttribute(iConstant.getValue());
        }
        catch (ConditionException conditionException) {
            throw new DSException(2529, new Object[]{"ConditionException"}, (Throwable)conditionException);
        }
    }

    private String getExpression2(IVariableList iVariableList) throws DSException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SEDU);
        try {
            for (int i = 0; i < iVariableList.size(); ++i) {
                stringBuffer.append(this.containsIgnoreCase(iVariableList.getVariableExp(i)));
                if (i >= iVariableList.size() - 1) continue;
                stringBuffer.append(equalsIgnoreCase);
                stringBuffer.append(containsIgnoreCase);
            }
        }
        catch (ConditionException conditionException) {
            throw new DSException(2530, new Object[]{"ConditionException"}, (Throwable)conditionException);
        }
        stringBuffer.append(append);
        return stringBuffer.toString();
    }

    private String getExpression3(IExpression iExpression) throws DSException {
        String string;
        block13: {
            string = null;
            try {
                if (this.resource.containsIgnoreCase(iExpression.getName())) {
                    if (ExpressionToolKit.isReference(iExpression.expressionType())) {
                        String string2 = this.resource.getStringValue();
                        if (!this.resource.wasField()) {
                            throw new DSException(2531, new Object[]{string + " is not db field"});
                        }
                        if (this.resource.wasComputedCol()) {
                            string = this.resource.getComputedColExp();
                        } else {
                            JAttribute jAttribute = this.resource.getJAttribute();
                            if (!(jAttribute instanceof JRdbDataField)) {
                                throw new DSException(2532, new Object[]{iExpression.getName() + " not rdb data field"});
                            }
                            string = NamingTools.getDSName((RdbConnection)this.connection, (JRdbDataField)jAttribute);
                        }
                    } else if (ExpressionToolKit.isFormula(iExpression.expressionType())) {
                        string = this.resource.getFormulaPushDownString();
                        if (!this.resource.wasFormula()) {
                            throw new DSException(2533, new Object[]{string + " is not formula"});
                        }
                    } else if (ExpressionToolKit.isParameter(iExpression.expressionType())) {
                        ParameterImpl parameterImpl = (ParameterImpl)iExpression;
                        string = parameterImpl.getStringValue(true);
                    }
                    break block13;
                }
                throw new DSException(2534, new Object[]{"internal error, can not found " + string + " in resource container"});
            }
            catch (ConditionException conditionException) {
                throw new DSException(2535, new Object[]{"ConditionException"}, (Throwable)conditionException);
            }
        }
        return string;
    }

    @Override
    public String getSQLSortString() throws DSException {
        if (this.sortString == null) {
            if (this.pushSortExp == null) {
                return null;
            }
            ISortInformation[] iSortInformationArray = null;
            IOperatorInformation iOperatorInformation = ((ISortOperator)this.pushSortExp.getOperator()).getOperatorInformation();
            if (OperatorInfoToolkit.isSortInformation(iOperatorInformation.informationType())) {
                ISortInformation iSortInformation = (ISortInformation)iOperatorInformation;
                iSortInformationArray = new ISortInformation[]{iSortInformation};
            } else if (OperatorInfoToolkit.isSortInformationCollector(iOperatorInformation.informationType())) {
                ISortInformationCollector iSortInformationCollector = (ISortInformationCollector)iOperatorInformation;
                iSortInformationArray = new ISortInformation[iSortInformationCollector.size()];
                for (int i = 0; i < iSortInformationArray.length; ++i) {
                    iSortInformationArray[i] = iSortInformationCollector.getSortInformation(i);
                }
            }
            this.sortString = this.getExpressions(iSortInformationArray);
        }
        return this.sortString;
    }

    private String getExpressions(ISortInformation[] iSortInformationArray) throws DSException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < iSortInformationArray.length; ++i) {
            if (iSortInformationArray[i].getSortType() == 0) continue;
            stringBuffer.append(this.getExpression3(iSortInformationArray[i].getReference()));
            stringBuffer.append(containsIgnoreCase);
            stringBuffer.append(this.getFormulaPushDownString(iSortInformationArray[i]));
            if (i >= iSortInformationArray.length - 1) continue;
            stringBuffer.append(equalsIgnoreCase);
            stringBuffer.append(containsIgnoreCase);
        }
        return stringBuffer.length() < 1 ? null : stringBuffer.toString().trim();
    }

    private String getFormulaPushDownString(ISortInformation iSortInformation) throws DSException {
        if (iSortInformation.getSortType() == 1) {
            return "ASC";
        }
        if (iSortInformation.getSortType() == 2) {
            return "DESC";
        }
        throw new DSException(2536, new Object[]{"sort type error : " + iSortInformation.getSortType()});
    }

    private String getJAttribute(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (!Character.isWhitespace(cArray[i])) continue;
            bl = true;
            break;
        }
        if (bl) {
            return convertDateString + string + convertDateString;
        }
        return string;
    }

    @Override
    public String getSQLTopNString() throws DSException {
        throw new UnsupportedOperationException();
    }
}

