/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.queryengine;

import com.jinfonet.dataservice.api.schema.relational.datasource.relational.JRdbConnection;
import java.util.Vector;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.info.ISortInformation;
import jet.dataengine.api.expression.info.ISortInformationCollector;
import jet.dataengine.api.expression.set.ISetExpression;
import jet.dataengine.api.expression.set.ISortExpression;
import jet.dataengine.api.expression.set.op.ISortOperator;
import jet.dataengine.api.expression.tuple.ITupleExpression;
import jet.dataengine.api.query.JDSQuery;
import jet.dataengine.api.query.JDataSourceQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.util.StringTools;
import jet.dataengine8.core.pushdown.ExpPushDownParser;
import jet.dataengine8.core.queryengine.FetchMessage;
import jet.dataengine8.core.queryengine.JQueryEngine;
import jet.dataengine8.core.queryengine.RawDataQueryTools;
import jet.dataengine8.core.queryengine.impl.BVDataQueryEngineImpl;
import jet.dataengine8.core.queryengine.impl.ConstantformulaQueryEngineImpl;
import jet.dataengine8.core.queryengine.impl.DemandQueryEngineImpl;
import jet.dataengine8.core.queryengine.impl.MixQueryEngineImpl;
import jet.dataengine8.core.queryengine.impl.OOJDBCQueryEngineImpl;
import jet.dataengine8.core.queryengine.impl.ProductQueryEngineImpl;
import jet.dataengine8.core.queryengine.impl.ResultSetQueryEngineImpl;
import jet.dataengine8.core.queryengine.impl.UDResultSetQueryEngineImpl;
import jet.dataengine8.core.queryengine.impl.WebServiceDataSourceQueryEngineImpl;
import jet.dataengine8.core.queryengine.impl.XMLDataSourceQueryEngineImpl;
import jet.dataengine8.core.queryengine.sqltoolkit.ResourceContainer;
import jet.dataengine8.core.queryengine.transform.AQueryInfo;
import jet.dataengine8.core.queryengine.transform.BVDataQueryInfo;
import jet.dataengine8.core.queryengine.transform.ConstantformulaQueryInfo;
import jet.dataengine8.core.queryengine.transform.DemandQueryInfo;
import jet.dataengine8.core.queryengine.transform.MixQueryInfo;
import jet.dataengine8.core.queryengine.transform.OOJDBCQueryInfo;
import jet.dataengine8.core.queryengine.transform.QueryTransform;
import jet.dataengine8.core.queryengine.transform.ResultSetQueryInfo;
import jet.dataengine8.core.queryengine.transform.UDCatQueryInfo;
import jet.dataengine8.core.queryengine.transform.UDResultSetQueryInfo;
import jet.dataengine8.core.queryengine.transform.WebServiceDataSourceQueryInfo;
import jet.dataengine8.core.queryengine.transform.XMLDataSourceQueryInfo;
import jet.dataservice.api.DataServiceConfig;
import jet.universe.JetUConnection;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUQuery;
import jet.universe.JetUUniverse;
import jet.universe.JetUWebServiceConnection;
import jet.universe.JetUXMLConnection;

public final class QueryEngineFactory {
    private static JQueryEngine $assertionsDisabled(JRawDataQuery jRawDataQuery, AQueryInfo aQueryInfo, ITupleExpression iTupleExpression, ISortExpression iSortExpression, DataServiceConfig dataServiceConfig) throws DSException {
        switch (aQueryInfo.queryInfoType()) {
            case 0x1002000: {
                return new OOJDBCQueryEngineImpl((OOJDBCQueryInfo)aQueryInfo, dataServiceConfig);
            }
            case 278528: {
                return new ConstantformulaQueryEngineImpl((ConstantformulaQueryInfo)aQueryInfo, dataServiceConfig);
            }
            case 81920: 
            case 0x114000: 
            case 2179072: 
            case 134299648: {
                try {
                    return new ResultSetQueryEngineImpl((ResultSetQueryInfo)aQueryInfo, QueryEngineFactory.SEDU((JDSQuery)jRawDataQuery, iSortExpression), dataServiceConfig);
                }
                catch (ConditionException conditionException) {
                    throw new DSException(2902, (Throwable)conditionException);
                }
            }
            case 147456: 
            case 1196032: 
            case 0x224000: 
            case 0x424000: 
            case 0x4024000: {
                try {
                    return new ResultSetQueryEngineImpl((UDCatQueryInfo)aQueryInfo, QueryEngineFactory.SEDU((JDSQuery)jRawDataQuery, iSortExpression), dataServiceConfig);
                }
                catch (ConditionException conditionException) {
                    throw new DSException(2902, (Throwable)conditionException);
                }
            }
            case 540672: {
                return new UDResultSetQueryEngineImpl((UDResultSetQueryInfo)aQueryInfo, dataServiceConfig);
            }
            case 4096: {
                return new DemandQueryEngineImpl((DemandQueryInfo)aQueryInfo, dataServiceConfig);
            }
            case 0x10004000: {
                try {
                    return new BVDataQueryEngineImpl((BVDataQueryInfo)aQueryInfo, dataServiceConfig);
                }
                catch (DSException dSException) {
                    throw new DSException(2902, (Throwable)dSException);
                }
            }
        }
        assert (false) : "Unknow QueryInfo! " + aQueryInfo.getClass().getName();
        throw new RuntimeException();
    }

    private static Vector[] SEDU(JDSQuery jDSQuery, ISetExpression iSetExpression) throws DSException, ConditionException {
        if (!QueryTransform.canProductionEngine(jDSQuery)) {
            return null;
        }
        JetUUniverse jetUUniverse = jDSQuery.getCatalog();
        String string = jDSQuery.getDataSourceName();
        JetUConnection jetUConnection = RawDataQueryTools.getOneExeQueryConnection(jDSQuery);
        String string2 = jetUConnection.getResourceName();
        if (jetUConnection instanceof JetUJDBCConnection) {
            JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)jetUConnection;
            Vector[] vectorArray = new Vector[]{new Vector(), new Vector()};
            if (iSetExpression != null) {
                JRdbConnection jRdbConnection = QueryTransform.parseConnection(jetUJDBCConnection);
                ExpPushDownParser expPushDownParser = ExpPushDownParser.getInstance(iSetExpression, new ResourceContainer(jetUUniverse, string, jDSQuery.getParameterValues()), jRdbConnection, jetUJDBCConnection.getSupportInfo());
                String string3 = expPushDownParser.getSQLSortString();
                if (!StringTools.isEmptyStringWithTrim(string3)) {
                    if (ExpressionToolKit.isSortExp(iSetExpression.expressionType())) {
                        ISortExpression iSortExpression = (ISortExpression)iSetExpression;
                        ISortInformationCollector iSortInformationCollector = (ISortInformationCollector)((ISortOperator)iSortExpression.getOperator()).getOperatorInformation();
                        int n = iSortInformationCollector.size();
                        for (int i = 0; i < n; ++i) {
                            ISortInformation iSortInformation = iSortInformationCollector.getSortInformation(i);
                            if (iSortInformation.getSortType() != 1 && iSortInformation.getSortType() != 2) continue;
                            vectorArray[0].add(iSortInformation.getReference().getName());
                            vectorArray[1].add(iSortInformation.getSortType() == 1 ? "ASC" : "DESC");
                        }
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }
            return vectorArray;
        }
        throw new IllegalArgumentException();
    }

    public static JQueryEngine getInstance(JRawDataQuery jRawDataQuery, ITupleExpression iTupleExpression, ISortExpression iSortExpression, boolean bl, FetchMessage fetchMessage, DataServiceConfig dataServiceConfig) throws DSException {
        JQueryEngine jQueryEngine = null;
        if (jRawDataQuery instanceof JDSQuery && !QueryTransform.canProductionEngine((JDSQuery)jRawDataQuery)) {
            jRawDataQuery.getExtender().setQueryType(1);
            QueryTransform queryTransform = new QueryTransform();
            AQueryInfo aQueryInfo = queryTransform.getQueryInfo(jRawDataQuery, iTupleExpression, iSortExpression, fetchMessage);
            jQueryEngine = QueryEngineFactory.$assertionsDisabled(jRawDataQuery, aQueryInfo, iTupleExpression, iSortExpression, dataServiceConfig);
            return jQueryEngine;
        }
        if (!RawDataQueryTools.isSingleExecuteQuery(jRawDataQuery, iTupleExpression, true) && jRawDataQuery.getExtender().getDownToSubQuery() == null) {
            return new MixQueryEngineImpl((MixQueryInfo)new QueryTransform().getQueryInfo(jRawDataQuery, iTupleExpression, iSortExpression, fetchMessage), dataServiceConfig);
        }
        JetUConnection jetUConnection = RawDataQueryTools.getOneExeQueryConnection(jRawDataQuery);
        if (jRawDataQuery instanceof JDataSourceQuery) {
            if (jetUConnection instanceof JetUXMLConnection && jRawDataQuery.getCatalog().getQueriableByResourceName(jRawDataQuery.getDataSourceName(), jRawDataQuery.getQueryName()) instanceof JetUQuery) {
                return new XMLDataSourceQueryEngineImpl((XMLDataSourceQueryInfo)new QueryTransform().getQueryInfo(jRawDataQuery, iTupleExpression, iSortExpression, fetchMessage), dataServiceConfig);
            }
            if (jetUConnection instanceof JetUWebServiceConnection && jRawDataQuery.getCatalog().getQueriableByResourceName(jRawDataQuery.getDataSourceName(), jRawDataQuery.getQueryName()) instanceof JetUQuery) {
                return new WebServiceDataSourceQueryEngineImpl((WebServiceDataSourceQueryInfo)new QueryTransform().getQueryInfo(jRawDataQuery, iTupleExpression, iSortExpression, fetchMessage), dataServiceConfig);
            }
        }
        if (bl && jRawDataQuery instanceof JDataSourceQuery) {
            jQueryEngine = new ProductQueryEngineImpl(jRawDataQuery, iTupleExpression, iSortExpression, fetchMessage, dataServiceConfig);
        } else {
            QueryTransform queryTransform = new QueryTransform();
            AQueryInfo aQueryInfo = queryTransform.getQueryInfo(jRawDataQuery, iTupleExpression, iSortExpression, fetchMessage);
            jQueryEngine = QueryEngineFactory.$assertionsDisabled(jRawDataQuery, aQueryInfo, iTupleExpression, iSortExpression, dataServiceConfig);
        }
        return jQueryEngine;
    }
}

