/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.queryengine.conntools;

import com.jinfonet.dataservice.api.schema.relational.datasource.relational.JRdbConnection;
import com.jinfonet.dataservice.schema.relational.datasource.relational.RdbConnection;
import com.jinfonet.util.JRLog;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import jet.dataengine.api.DSException;
import jet.dataengine.util.StringTools;
import jet.dataengine8.core.queryengine.conntools.AConnectionCreator;
import toolkit.db.gui.ConnectionsBroker;

public class RDBConnectionCreator
extends AConnectionCreator {
    private String SEDU = null;
    private String append = null;
    private String getConnection = null;
    private String getCurrentCatalog = null;
    private String getDriver = null;
    private String getJNDIConnection = null;

    RDBConnectionCreator(JRdbConnection jRdbConnection) {
        super(jRdbConnection);
        this.append = jRdbConnection.getUser();
        this.getConnection = jRdbConnection.getPassword();
        this.getCurrentCatalog = jRdbConnection.getDriver();
        this.SEDU = jRdbConnection.getUrl();
        this.getDriver = jRdbConnection.getCurrentCatalog();
        if (jRdbConnection instanceof RdbConnection && ((RdbConnection)jRdbConnection).isUseJNDIConf()) {
            this.getJNDIConnection = ((RdbConnection)jRdbConnection).getJNDIName();
        }
    }

    @Override
    public Connection createRDBConnection() throws DSException {
        Connection connection = null;
        try {
            if (!this.isUseJNDIConf()) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "Connection info : User :" + this.append + " Password :" + this.getConnection + " url :" + this.SEDU + " driver :" + this.getCurrentCatalog + "CatalogName : " + this.getDriver);
                }
                connection = ConnectionsBroker.getConnection(this.SEDU, this.append, this.getConnection, this.getCurrentCatalog);
                if (!StringTools.isEmptyStringWithTrim(this.getDriver)) {
                    connection.setCatalog(this.getDriver);
                }
            } else {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "Connection info : User :" + this.append + " Password :" + this.getConnection + " JNDIName : " + this.getJNDIConnection);
                }
                connection = ConnectionsBroker.getJNDIConnection(this.getJNDIConnection, this.append, this.getConnection);
            }
        }
        catch (SQLException sQLException) {
            throw new DSException(2053, (Throwable)sQLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DSException(2052, (Throwable)classNotFoundException);
        }
        catch (NamingException namingException) {
            throw new DSException(2061, (Throwable)namingException);
        }
        return connection;
    }

    @Override
    public int getType() {
        return 0;
    }

    public boolean isUseJNDIConf() {
        boolean bl = false;
        if (this.getJNDIConnection != null) {
            bl = true;
        }
        return bl;
    }
}

