/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.queryengine.impl;

import com.jinfonet.dataservice.expression.executor.conditiontools.CancelActionException;
import java.sql.SQLException;
import jet.connect.DbProcedure;
import jet.connect.DbQuery;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.set.ISetExpression;
import jet.dataengine.api.expression.tuple.ITupleExpression;
import jet.dataengine.listener.CancelEvent;
import jet.dataengine.listener.JCancelListener;
import jet.dataengine8.core.queryengine.DynamicQueryEngine;
import jet.dataengine8.core.queryengine.impl.AQueryEngine;
import jet.dataengine8.core.queryengine.transform.DynamicQueryInfo;
import jet.dataservice.api.DataServiceConfig;
import jet.universe.engine.UProcedureEngine;
import jet.universe.engine.UQueryEngine;

public abstract class ADynamicQueryEngine
extends AQueryEngine
implements DynamicQueryEngine {
    private boolean SEDU = false;
    private boolean append = false;
    private JCancelListener cancel;
    protected UQueryEngine engine;

    public ADynamicQueryEngine(DynamicQueryInfo dynamicQueryInfo, DataServiceConfig dataServiceConfig) {
        super(dynamicQueryInfo, dataServiceConfig);
        if (dynamicQueryInfo == null) assert (false) : "query info is null";
    }

    @Override
    public void cancel(CancelEvent cancelEvent) throws DSException {
        DbQuery dbQuery;
        if (cancelEvent == null) assert (false) : "dynamic engine cancel event was null";
        if (this.engine instanceof UProcedureEngine) {
            DbProcedure dbProcedure = ((UProcedureEngine)this.engine).getDbProcedure();
            this.SEDU = dbProcedure.cancel();
        } else if (this.engine != null && (dbQuery = this.engine.getDBQuery()) != null) {
            this.SEDU = dbQuery.cancel(cancelEvent);
        }
        if (this.cancel != null) {
            this.cancel.cancel(cancelEvent);
        }
        this.cancelEvent = cancelEvent;
        this.setCanceled(true);
    }

    protected void tryCanceled() throws DSException {
        if (this.isCanceled()) {
            if (this.getCancelListener() != null) {
                this.getCancelListener().cancel(this.cancelEvent);
            }
            throw new CancelActionException("cancel event performed");
        }
    }

    protected boolean isBreakDown() {
        return this.append;
    }

    protected void setBreakDown(boolean bl) {
        this.append = bl;
    }

    private void $assertionsDisabled() throws DSException {
        if (this.isCanceled()) {
            throw new DSException(2600, new Object[]{"action canceled, calling error"});
        }
    }

    @Override
    public void close() throws DSException {
        this.closeResource();
        if (this.engine != null) {
            try {
                this.engine.end();
            }
            catch (SQLException sQLException) {
                this.log.debug("close engine error", sQLException);
            }
        }
        if (!this.isFinished) {
            this.log.info(2600, new Object[]{"execute not finished"});
            throw new DSException(2602, new Object[]{"execute not finished"});
        }
    }

    protected ISetExpression getSetExpression(IExpression iExpression) {
        if (iExpression != null) {
            if (!(iExpression instanceof ISetExpression)) assert (false) : "local set exp typ error, must be Set exp " + iExpression.toString();
            if (ExpressionToolKit.containedTupleExp(iExpression)) assert (false) : "local set exp can not contain tuple exp : " + iExpression.toString();
            return (ISetExpression)iExpression;
        }
        this.log.debug("set exp was null");
        return null;
    }

    protected ITupleExpression getFilterExpression(IExpression iExpression) {
        if (iExpression != null) {
            if (!(iExpression instanceof ITupleExpression)) assert (false) : "local condition exp typ error, must be Tuple exp : " + iExpression.toString();
            return (ITupleExpression)iExpression;
        }
        this.log.debug("filter exp was null");
        return null;
    }

    public boolean isCanceled() {
        return this.SEDU;
    }

    public void setCanceled(boolean bl) {
        this.SEDU = bl;
    }

    public JCancelListener getCancelListener() {
        return this.cancel;
    }

    public void setCancelListener(JCancelListener jCancelListener) {
        this.cancel = jCancelListener;
    }

    public void setSQLStatement(String string) {
        this.fetchMessage.setSqlStatement(string);
    }
}

