/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.queryengine.impl;

import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.Attribute;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.RelationMetaData;
import com.jinfonet.dataservice.relational.localrelation.extend.ExtendableRelationData;
import com.jinfonet.dataservice.relational.localrelation.extend.ExtendedDataProvider;
import com.jinfonet.dataservice.schema.relational.datasource.relational.RdbDataField;
import com.jinfonet.util.JRLog;
import jet.connect.DbColDesc;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.api.query.SpecialFields;
import jet.dataengine.listener.CancelEvent;
import jet.dataengine.util.DSLog;
import jet.dataengine8.core.queryengine.FetchMessage;
import jet.dataengine8.core.queryengine.JQueryEngine;
import jet.dataengine8.core.queryengine.atapter.QueryOption;
import jet.dataengine8.core.queryengine.transform.AQueryInfo;
import jet.dataengine8.core.queryengine.transform.AttributeContainer;
import jet.dataengine8.core.queryengine.transform.ExtendedDataProviderimpl;
import jet.dataservice.api.DataServiceConfig;

public abstract class AQueryEngine
implements JQueryEngine {
    protected DSLog log = DSLog.getDSLog(this.getClass().getName());
    protected int queryEngineID;
    protected AQueryInfo queryInfo;
    protected boolean isFinished = false;
    protected CancelEvent cancelEvent;
    protected SpecialFields specialFields;
    protected static final long SLEEP_TIME = 50L;
    protected IRelationData relationData = null;
    protected boolean isError = false;
    protected FetchMessage fetchMessage = new FetchMessage();
    protected DataServiceConfig dsConfig = null;

    protected AQueryEngine() {
    }

    public AQueryEngine(AQueryInfo aQueryInfo, DataServiceConfig dataServiceConfig) {
        this.queryInfo = aQueryInfo;
        this.specialFields = aQueryInfo.getSpecialFields();
        this.fetchMessage = aQueryInfo.getFetchMessage();
        this.dsConfig = dataServiceConfig;
    }

    @Override
    public final int getQueryEngineID() throws DSException {
        return this.queryEngineID;
    }

    @Override
    public QueryOption getQueryOption() throws DSException {
        return this.queryInfo.getOptions();
    }

    @Override
    public final boolean isFinished() throws DSException {
        return this.isFinished;
    }

    @Override
    public void cancel(CancelEvent cancelEvent) throws DSException {
        this.cancelEvent = cancelEvent;
    }

    @Override
    public String[] getUDSMappingNames() throws DSException {
        return null;
    }

    @Override
    public IRelationData getRelation() throws DSException {
        return this.relationData;
    }

    @Override
    public final AQueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    @Override
    public String getSQLStatement() {
        return this.fetchMessage.getSqlStatement();
    }

    @Override
    public void close() throws DSException {
        this.closeResource();
    }

    @Override
    public void closeResource() throws DSException {
        if (this.relationData != null) {
            this.relationData.close();
            this.relationData = null;
        }
        this.cancelEvent = null;
        this.fetchMessage = null;
        this.queryInfo = null;
        this.specialFields = null;
    }

    protected static DbColDesc createColDescForFetchTime(JRelationMetaData jRelationMetaData) throws DSException {
        String string = "fetchDataTimeStamp";
        int n = jRelationMetaData.getColumnCount();
        int n2 = jRelationMetaData.findColumn(string);
        int n3 = 0;
        while (n2 != -1) {
            string = string + n3;
            ++n3;
            n2 = jRelationMetaData.findColumn(string);
        }
        DbColDesc dbColDesc = new DbColDesc(string, 93, 20, 0, 1, false);
        dbColDesc.setConstant(false);
        dbColDesc.setColIndex(n);
        return dbColDesc;
    }

    public static DbColDesc createColDescForAgg(int n, DbColDesc dbColDesc, AttributeContainer attributeContainer, RecordModelInfo recordModelInfo, int n2) throws DSException {
        String string = dbColDesc.getColName() + "_" + n2;
        if (string.length() > 26) {
            string = string.substring(string.length() - 26);
        }
        JAttribute jAttribute = attributeContainer.getElementByAttributeName(string);
        int n3 = -1;
        if (recordModelInfo != null) {
            n3 = recordModelInfo.indexOfCell(string);
        }
        int n4 = 0;
        int n5 = dbColDesc.getPrecision();
        int n6 = dbColDesc.getScale();
        boolean bl = false;
        while (jAttribute != null || n3 != -1) {
            string = string + "_" + n4;
            ++n4;
            jAttribute = attributeContainer.getElementByAttributeName(string);
            if (recordModelInfo == null) continue;
            n3 = recordModelInfo.indexOfCell(string);
        }
        switch (n) {
            case -5: {
                n5 = 19;
                n6 = 0;
                break;
            }
            case 2: 
            case 3: {
                n5 = 30;
                n6 = 2;
                bl = true;
            }
        }
        DbColDesc dbColDesc2 = new DbColDesc(string, n, n5, n6, 1, bl);
        dbColDesc2.setColIndex(-1);
        return dbColDesc2;
    }

    protected static DbValue createDbVavalueForFetchTime(long l, JRelationMetaData jRelationMetaData) throws DSException {
        DbColDesc dbColDesc = AQueryEngine.createColDescForFetchTime(jRelationMetaData);
        DbTimestamp dbTimestamp = new DbTimestamp(dbColDesc);
        dbTimestamp.set(l);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, " Finish creating system refresh time column:" + dbTimestamp + " Coldesc:" + dbColDesc);
        }
        return dbTimestamp;
    }

    public static JAttribute createJAttribue(DbColDesc dbColDesc, boolean bl) throws DSException {
        JAttribute jAttribute = null;
        jAttribute = bl ? new RdbDataField(dbColDesc.getColName(), dbColDesc.getSqlType(), dbColDesc.getPrecision(), dbColDesc.getScale(), dbColDesc.getPrecision(), dbColDesc.isCurrency(), dbColDesc.getNullable(), !dbColDesc.isIgnoreCase()) : new Attribute(dbColDesc.getColName(), dbColDesc.getSqlType(), dbColDesc.getPrecision(), dbColDesc.getScale(), dbColDesc.getPrecision(), dbColDesc.getNullable(), dbColDesc.isCurrency(), dbColDesc.isReadOnly(), dbColDesc.isConstant());
        return jAttribute;
    }

    protected static IRelationData createExtendableRelationData(String string, IRelationData iRelationData, DbValue[] dbValueArray) throws DSException {
        Object object;
        int n = dbValueArray.length;
        JAttribute[] jAttributeArray = new JAttribute[n];
        for (int i = 0; i < n; ++i) {
            object = AQueryEngine.createJAttribue(dbValueArray[i].getColDesc(), false);
            jAttributeArray[i] = object;
        }
        RelationMetaData relationMetaData = new RelationMetaData(iRelationData.getMetaData(), (JRelationMetaData)new RelationMetaData(jAttributeArray));
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, " meta data dump before ExtendableRelationData: " + relationMetaData);
            JRLog.trace(6, " meta data hashtable ExtendableRelationData: " + relationMetaData.hashCode());
        }
        object = new ExtendedDataProviderimpl(dbValueArray);
        ExtendableRelationData extendableRelationData = new ExtendableRelationData(string, iRelationData, relationMetaData, (ExtendedDataProvider)object);
        return extendableRelationData;
    }

    protected static DbValue[] createDbVavalueForFetchTimeByExistingRMD(long l, JRelationMetaData jRelationMetaData) throws DSException {
        DbValue[] dbValueArray = new DbValue[1];
        int n = jRelationMetaData.getColumnCount();
        JAttribute jAttribute = null;
        for (int i = n; i > 0 && !(jAttribute = jRelationMetaData.getAttribute(i)).getAttributeName().startsWith("fetchDataTimeStamp"); --i) {
        }
        DbColDesc dbColDesc = null;
        if (jAttribute != null) {
            dbColDesc = new DbColDesc(jAttribute.getAttributeName(), jAttribute.getDataType(), jAttribute.getPrecision(), jAttribute.getScale(), 1, jAttribute.isCurrency());
            dbColDesc.setConstant(jAttribute.isConstant());
        }
        dbValueArray[0] = new DbTimestamp(dbColDesc);
        ((DbTimestamp)dbValueArray[0]).set(l);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, " Finish creating system refresh time column:" + dbValueArray[0]);
        }
        return dbValueArray;
    }

    protected IRelationData getInputRelationData() {
        IRelationData iRelationData = null;
        iRelationData = this.relationData instanceof ExtendableRelationData ? ((ExtendableRelationData)this.relationData).getInputRelationData() : this.relationData;
        return iRelationData;
    }

    @Override
    public void setDataServiceConfig(DataServiceConfig dataServiceConfig) {
        this.dsConfig = dataServiceConfig;
    }

    @Override
    public DataServiceConfig getDataServiceConfig() {
        return this.dsConfig;
    }

    public static long min(long l, long l2) {
        long l3 = l;
        if (l2 > -1L) {
            l3 = l3 > -1L ? Math.min(l3, l2) : l2;
        }
        return l3;
    }
}

