/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.queryengine.impl;

import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.expression.executor.conditiontools.RelationConditionTool;
import com.jinfonet.dataservice.relational.FakeRelationData;
import com.jinfonet.dataservice.relational.RelationMetaData;
import com.jinfonet.dataservice.relational.RelationMetaDataFactory;
import com.jinfonet.dataservice.relational.RelationOption;
import com.jinfonet.dataservice.relational.datasource.adapters.ResultSetStreamRelationData;
import com.jinfonet.dataservice.relational.swap.Relation4ResultSetPool;
import com.jinfonet.dataservice.relational.swap.RowDataPoolListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.AggregationKey;
import jet.dataengine.listener.CancelEvent;
import jet.dataengine.listener.JCancelListener;
import jet.dataengine8.core.queryengine.DataSourceQueryEngine;
import jet.dataengine8.core.queryengine.ResultSetTools;
import jet.dataengine8.core.queryengine.impl.AQueryEngine;
import jet.dataengine8.core.queryengine.transform.DataSourceQueryInfo;
import jet.dataservice.api.DataServiceConfig;

public class DataSourceQueryEngineImpl
extends AQueryEngine
implements DataSourceQueryEngine {
    private static final String SEDU = "DataSourceQueryEngineImpl";
    protected ResultSetTools resultSetTools;
    protected ResultSet rs;
    protected JCancelListener cancelListener;

    public DataSourceQueryEngineImpl(DataSourceQueryInfo dataSourceQueryInfo, DataServiceConfig dataServiceConfig) {
        super(dataSourceQueryInfo, dataServiceConfig);
    }

    @Override
    public void close() throws DSException {
        if (this.relationData != null) {
            this.relationData.close();
        }
        this.closeResource();
    }

    @Override
    public int type() {
        return 131072;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void execute() throws DSException {
        this.log.indent("DataSourceQueryEngineImpl");
        var1_1 = (DataSourceQueryInfo)this.queryInfo;
        var2_2 = var1_1.getOptions();
        this.fetchMessage.setFetchDate(System.currentTimeMillis());
        this.fetchMessage.setFetchTime(System.currentTimeMillis());
        if (var2_2.isNoRecrod()) {
            this.rs = null;
            this.fetchMessage.setIoTime(0L);
            this.fetchMessage.setSqlStatement("");
            try {
                var3_3 = RelationMetaDataFactory.create("", var1_1.getAttributeContainer());
                var4_5 = var3_3.getAttributes();
                var5_8 = new RelationOption(var2_2, (JAttribute[])var4_5, this.specialFields);
                var5_8.setDiskStore(this.dsConfig.getResourceStore().getDiskStore());
                this.relationData = new FakeRelationData("", 0, (RelationMetaData)var3_3, var5_8);
                this.fetchMessage.setFetchStartTime(System.currentTimeMillis());
                this.fetchMessage.setFetchEndTime(System.currentTimeMillis());
                if (!this.log.isDebugEnabled()) ** GOTO lbl63
                this.log.debug("This is NoRecord Query!");
            }
            catch (DSException var4_6) {
                this.isError = true;
            }
            finally {
                this.log.deIndent("DataSourceQueryEngineImpl");
            }
        } else {
            try {
                this.resultSetTools = new ResultSetTools();
                this.rs = this.resultSetTools.getResultSet(var1_1);
                this.fetchMessage.setIoTime(this.resultSetTools.getIOTime());
                this.fetchMessage.setSqlStatement(var1_1.getSqlStatement());
                var3_3 = RelationMetaDataFactory.create("", this.rs, var1_1.getAttributeContainer());
                var4_5 = var3_3.getAttributes();
                var5_8 = new RelationOption(var2_2, (JAttribute[])var4_5, this.specialFields);
                var5_8.setDiskStore(this.dsConfig.getResourceStore().getDiskStore());
                if (var2_2.isFastPass()) {
                    if (!DataSourceQueryEngineImpl.$assertionsDisabled && var1_1.getLocalSortExpression() != null) {
                        throw new AssertionError((Object)("Fast Pass Can not contain local sort! " + var1_1.getLocalSortExpression().toString()));
                    }
                    var6_11 = new ResultSetStreamRelationData(var1_1.getLocalConditionsExpression(), var1_1.getJavaFormula(), var1_1.getAttributeContainer(), var1_1.getConstantFormulaValues(), var5_8, false, this.fetchMessage, (JRelationMetaData)var3_3);
                    var6_11.addCloseResourceListener(this);
                    this.relationData = var6_11;
                    this.cancelListener = var6_11;
                } else {
                    var6_12 = System.currentTimeMillis();
                    var8_14 = new Relation4ResultSetPool(var1_1.getLocalConditionsExpression(), var1_1.getJavaFormula(), var1_1.getAttributeContainer(), var5_8, var1_1.getConstantFormulaValues(), this.fetchMessage);
                    var8_14.addRowDataPoolListener(new RowDataPoolListener(){

                        @Override
                        public void fetchDataCompleted() {
                        }
                    });
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Fetch ResultSet Time for swap :" + (System.currentTimeMillis() - var6_12) + " ms");
                    }
                    var8_14.addCloseResourceListener(this);
                    if (var1_1.getLocalSortExpression() != null) {
                        var9_15 = RelationConditionTool.getInstance(var1_1.getLocalSortExpression(), var1_1.getAttributeContainer(), var1_1.getJavaFormula(), var1_1.getSpecialFields());
                        this.relationData = var9_15.doAction(var8_14);
                    } else {
                        this.relationData = var8_14;
                    }
                    this.cancelListener = var8_14;
                }
            }
            catch (DSException var3_4) {
                this.isError = true;
            }
            finally {
                this.log.deIndent("DataSourceQueryEngineImpl");
            }
        }
        if (this.queryInfo.getNeedSystemRefreshTime()) {
            var3_3 = DataSourceQueryEngineImpl.createDbVavalueForFetchTime(this.fetchMessage.getFetchStartTime(), this.relationData.getMetaData());
            var4_5 = new DbValue[]{var3_3};
            this.relationData = DataSourceQueryEngineImpl.createExtendableRelationData("extendFetchTime", this.relationData, (DbValue[])var4_5);
        }
        if (this.fetchMessage.hasSpecialT2()) {
            var3_3 = this.fetchMessage.getSpecialT2();
            var4_7 = var3_3.size();
            for (var5_9 = 0; var5_9 < var4_7; ++var5_9) {
                var6_13 = (AggregationKey)var3_3.get(var5_9);
                this.queryInfo.getExtender().addSpecialT2Value(var6_13, this.fetchMessage.getSpecialT2Value(var6_13));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeResource() throws DSException {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
        }
        catch (SQLException sQLException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Close ResultSet Error ! " + sQLException.getMessage());
            }
        }
        finally {
            this.rs = null;
            if (this.resultSetTools != null) {
                this.resultSetTools.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(CancelEvent cancelEvent) throws DSException {
        this.cancelEvent = cancelEvent;
        if (this.cancelListener != null) {
            JCancelListener jCancelListener = this.cancelListener;
            synchronized (jCancelListener) {
                try {
                    this.cancelListener.cancel(cancelEvent);
                }
                catch (DSException dSException) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Cancel relation data error occurs!");
                    }
                    throw dSException;
                }
            }
        }
        if (this.resultSetTools != null) {
            ResultSetTools resultSetTools = this.resultSetTools;
            synchronized (resultSetTools) {
                try {
                    this.resultSetTools.cancel(cancelEvent);
                }
                catch (DSException dSException) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Cancel relation data error occurs!");
                    }
                    throw dSException;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.getClass().getName() + " is canceled!");
            }
        }
    }
}

