/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.queryengine.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.util.DSLog;
import jet.dataengine8.core.queryengine.impl.UQueryEngineToolkit;
import jet.dataengine8.core.queryengine.transform.JRExternalRunnerQueryInfo;
import jet.dataengine8.core.queryengine.transform.ResultSetQueryInfo;
import jet.dataengine8.core.queryengine.transform.UDCatQueryInfo;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUUniverse;
import jet.universe.engine.UQueryEngine;
import toolkit.db.ConnectionToolkit;

class DyQueryResultSetFactory {
    private DSLog SEDU;
    private Connection append;
    private Statement close;

    DyQueryResultSetFactory(DSLog dSLog) {
        this.SEDU = dSLog;
    }

    public ResultSet getResultSet(UDCatQueryInfo uDCatQueryInfo, Vector[] vectorArray) throws DSException {
        switch (uDCatQueryInfo.queryInfoType()) {
            case 1196032: {
                return this.SEDU((JRExternalRunnerQueryInfo)uDCatQueryInfo);
            }
            case 147456: {
                return this.append(uDCatQueryInfo);
            }
        }
        throw new DSException(2625, new Object[]{"query infor type error : " + uDCatQueryInfo.queryInfoType()});
    }

    public UQueryEngine getQueryEngine(UDCatQueryInfo uDCatQueryInfo, Vector[] vectorArray) throws DSException {
        switch (uDCatQueryInfo.queryInfoType()) {
            case 0x224000: 
            case 0x424000: 
            case 0x4024000: {
                return UQueryEngineToolkit.getQueryEngine(uDCatQueryInfo, vectorArray);
            }
        }
        throw new DSException(2625, new Object[]{"query infor type error : " + uDCatQueryInfo.queryInfoType()});
    }

    public ResultSet getResultSet(ResultSetQueryInfo resultSetQueryInfo, Vector[] vectorArray) throws DSException {
        switch (resultSetQueryInfo.queryInfoType()) {
            case 0x114000: 
            case 2179072: 
            case 134299648: {
                return UQueryEngineToolkit.getResultSet(resultSetQueryInfo, vectorArray);
            }
            case 81920: {
                return resultSetQueryInfo.getResultSet();
            }
        }
        throw new DSException(2626, new Object[]{"query infor type error : " + resultSetQueryInfo.queryInfoType()});
    }

    public UQueryEngine getQueryEngine(ResultSetQueryInfo resultSetQueryInfo, Vector[] vectorArray) throws DSException {
        switch (resultSetQueryInfo.queryInfoType()) {
            case 0x114000: 
            case 2179072: 
            case 134299648: {
                return UQueryEngineToolkit.getQueryEngine(resultSetQueryInfo, vectorArray);
            }
        }
        throw new DSException(2626, new Object[]{"query infor type error : " + resultSetQueryInfo.queryInfoType()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws DSException {
        try {
            if (this.close != null) {
                Statement statement = this.close;
                synchronized (statement) {
                    this.close.close();
                    this.close = null;
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new DSException(2627, new Object[]{"statement close failed"}, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                try {
                    if (this.append == null) throw throwable;
                    Connection connection = this.append;
                    synchronized (connection) {
                        ConnectionToolkit.freeConnection(this.append);
                        this.append = null;
                        throw throwable;
                    }
                }
                catch (SQLException sQLException2) {
                    throw new DSException(2628, new Object[]{"connection close failed"}, (Throwable)sQLException2);
                }
            }
        }
        try {
            if (this.append == null) return;
            Connection connection = this.append;
            synchronized (connection) {
                ConnectionToolkit.freeConnection(this.append);
                this.append = null;
                return;
            }
        }
        catch (SQLException sQLException) {
            throw new DSException(2628, new Object[]{"connection close failed"}, (Throwable)sQLException);
        }
    }

    private ResultSet SEDU(JRExternalRunnerQueryInfo jRExternalRunnerQueryInfo) throws DSException {
        if (jRExternalRunnerQueryInfo.getExternalObj() == null) {
            throw new IllegalArgumentException("JRExternalQueryRunner was null");
        }
        if (jRExternalRunnerQueryInfo.getSqlStatement() == null) {
            throw new IllegalArgumentException("sql statemetn was null");
        }
        try {
            return jRExternalRunnerQueryInfo.getExternalObj().getResultSet(jRExternalRunnerQueryInfo.getSqlStatement());
        }
        catch (SQLException sQLException) {
            throw new DSException(2634, new Object[]{"get result set error"}, (Throwable)sQLException);
        }
    }

    private ResultSet append(UDCatQueryInfo uDCatQueryInfo) throws DSException {
        JetUUniverse jetUUniverse = uDCatQueryInfo.getCatlogObj();
        JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)ExpressionToolKit.getJetUConnectionByField(jetUUniverse, uDCatQueryInfo.getDataSourceName(), uDCatQueryInfo.getMappingNames()[0]);
        try {
            this.append = ConnectionToolkit.getConnection(jetUJDBCConnection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.close = this.append.createStatement();
            return this.close.executeQuery(uDCatQueryInfo.getSqlStatement());
        }
        catch (SQLException sQLException) {
            throw new DSException(2631, new Object[]{"can not get result set"}, (Throwable)sQLException);
        }
    }
}

