/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.queryengine.transform;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.relational.datasource.Formula;
import com.jinfonet.dataservice.relational.datasource.FormulaMapping;
import com.jinfonet.dataservice.relational.datasource.NormalParameter;
import com.jinfonet.dataservice.relational.datasource.ParameterMapping;
import com.jinfonet.dataservice.schema.relational.RelationModel;
import com.jinfonet.dataservice.schema.relational.datasource.DSDataField;
import com.jinfonet.dataservice.schema.relational.datasource.relational.RdbDataField;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.query.DataDescription;
import jet.dataengine.api.query.JDSQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.api.query.MappingNameBindInfo;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine8.core.queryengine.RawDataQueryTools;
import jet.dataengine8.core.queryengine.transform.AttributeContainer;
import jet.dataengine8.core.queryengine.transform.FormulaEnvTools;
import jet.dataengine8.core.queryengine.transform.FormulaFetcher4Universe;
import jet.dataengine8.core.queryengine.transform.ModelKey;
import jet.dataengine8.core.queryengine.transform.QueryTransform;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.universe.JetUFormula;
import jet.universe.JetUQueriable;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import toolkit.db.gui.MappingSQLType;

class DynamicQueryAttContainerParser {
    DynamicQueryAttContainerParser() {
    }

    public AttributeContainer parseDynamicContainer(JDSQuery jDSQuery) throws DSException {
        DataDescription dataDescription = RawDataQueryTools.getOneExeQueryDD(jDSQuery);
        if (jDSQuery.getResultSet() != null || jDSQuery.getExtender().isUseBV()) {
            String string = jDSQuery.getDataSourceName();
            JetUUniverse jetUUniverse = jDSQuery.getCatalog();
            String string2 = jDSQuery.getQueryName();
            JetUQueriable jetUQueriable = jetUUniverse.getQueriableByResourceName(string, string2);
            return this.add(jDSQuery.getMappingNames(), jDSQuery, jetUQueriable, dataDescription);
        }
        if (dataDescription != null && dataDescription.getType() == 6) {
            return this.SEDU(jDSQuery.getMappingNames(), dataDescription.getConstantFormulas(), jDSQuery.getParameterValues());
        }
        if (dataDescription != null && (dataDescription.getType() == 4103 || dataDescription.getType() == 122888 || dataDescription.getType() == 0x20000B || jDSQuery.getExternalQueryRunner() != null)) {
            return this.desiredAssertionStatus(jDSQuery.getMappingNames(), jDSQuery, dataDescription);
        }
        throw new IllegalArgumentException("dynamic query type error in DataDescription: " + dataDescription.getType());
    }

    private AttributeContainer $assertionsDisabled(JDSQuery jDSQuery, DataDescription dataDescription) {
        throw new UnsupportedOperationException();
    }

    private AttributeContainer SEDU(String[] stringArray, JetRptFormula[] jetRptFormulaArray, ParameterValueList parameterValueList) throws DSException {
        int n;
        if (jetRptFormulaArray == null || stringArray == null) assert (false) : "constant formulas were null";
        AttributeContainer attributeContainer = new AttributeContainer();
        boolean bl = false;
        for (int i = 0; i < jetRptFormulaArray.length; ++i) {
            for (n = 0; n < stringArray.length; ++n) {
                if (!jetRptFormulaArray[i].getName().equalsIgnoreCase(stringArray[n])) continue;
                FormulaMapping formulaMapping = new FormulaMapping(stringArray[n], new Formula(jetRptFormulaArray[i].getName(), jetRptFormulaArray[i]));
                formulaMapping.setCaseSensitive(!jetRptFormulaArray[i].getColDesc().isIgnoreCase());
                attributeContainer.add(formulaMapping);
                bl = true;
                break;
            }
            if (bl) continue;
            throw new RuntimeException("can not found constant formula in mapping names : " + jetRptFormulaArray[i].getName());
        }
        ParamDesc[] paramDescArray = parameterValueList.getParameterDescriptions();
        for (n = 0; n < paramDescArray.length; ++n) {
            attributeContainer.add(new ParameterMapping(paramDescArray[n].getName(), new NormalParameter(paramDescArray[n].getName(), paramDescArray[n].isReferedBy(), paramDescArray[n].getValue(), Types.sqlTypeToType(MappingSQLType.mapSQLTypeToInt(paramDescArray[n].getType())), paramDescArray[n].getFormat(), -1, -1, -1, paramDescArray[n])));
        }
        attributeContainer.setDisplayMappingNames(stringArray);
        return attributeContainer;
    }

    private AttributeContainer add(String[] stringArray, JDSQuery jDSQuery, JetUQueriable jetUQueriable, DataDescription dataDescription) throws DSException {
        Vector<MappingNameBindInfo> vector = new Vector<MappingNameBindInfo>();
        ResultSetMetaData resultSetMetaData = null;
        MappingNameBindInfo[] mappingNameBindInfoArray = null;
        if (jDSQuery.getExtender().isUseBV() || jDSQuery.getExtender().isResultSetFromCRD()) {
            if (jDSQuery.getExtender().isUseBV()) {
                return this.addRelationModelFromParse(stringArray, jDSQuery, jetUQueriable, dataDescription);
            }
            try {
                resultSetMetaData = jDSQuery.getResultSet().getMetaData();
                int n = resultSetMetaData.getColumnCount() + 1;
                for (int i = 1; i < n; ++i) {
                    vector.add(new MappingNameBindInfo(resultSetMetaData.getColumnName(i), i));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            mappingNameBindInfoArray = vector.toArray(new MappingNameBindInfo[0]);
        } else {
            mappingNameBindInfoArray = jDSQuery.getMappingNameBindInfos();
        }
        if (resultSetMetaData == null) {
            resultSetMetaData = this.createRdbDataField(jDSQuery, dataDescription);
        }
        AttributeContainer attributeContainer = new AttributeContainer();
        this.appendFormulas(jDSQuery.getCatalog(), jDSQuery.getDataSourceName(), stringArray, mappingNameBindInfoArray, resultSetMetaData, attributeContainer);
        this.append(jDSQuery.getFilters(), resultSetMetaData, attributeContainer, jDSQuery.getCatalog(), jDSQuery.getDataSourceName(), jDSQuery.getQueryName());
        this.getColumnCount(jDSQuery, jetUQueriable, attributeContainer);
        DynamicQueryAttContainerParser.appendFormulas(jDSQuery.getCatalog(), jDSQuery.getDataSourceName(), stringArray, attributeContainer);
        this.getCatalog(jDSQuery, attributeContainer);
        this.getColDesc(jDSQuery, attributeContainer);
        attributeContainer.setDisplayMappingNames(stringArray);
        return this.dump(jDSQuery.getCatalog(), jDSQuery.getDataSourceName(), attributeContainer, stringArray, mappingNameBindInfoArray, resultSetMetaData, jDSQuery);
    }

    private AttributeContainer addRelationModelFromParse(String[] stringArray, JDSQuery jDSQuery, JetUQueriable jetUQueriable, DataDescription dataDescription) throws DSException {
        if (jDSQuery.getExtender().isUseBV()) {
            AttributeContainer attributeContainer = new AttributeContainer();
            this.getColumnName(stringArray, jDSQuery.getDataSourceName(), jDSQuery.getCatalog(), attributeContainer, jDSQuery.getQueryName());
            IExpression iExpression = jDSQuery.getFilters();
            if (iExpression != null) {
                Object var7_7 = null;
                String[] stringArray2 = ExpressionToolKit.getDependentRefNames(iExpression, jDSQuery.getCatalog(), jDSQuery.getDataSourceName(), jDSQuery.getQueryName());
                if (stringArray2 != null && stringArray2.length > 0) {
                    this.getColumnName(stringArray2, jDSQuery.getDataSourceName(), jDSQuery.getCatalog(), attributeContainer, jDSQuery.getQueryName());
                }
            }
            this.getColumnCount(jDSQuery, jetUQueriable, attributeContainer);
            DynamicQueryAttContainerParser.appendFormulas(jDSQuery.getCatalog(), jDSQuery.getDataSourceName(), stringArray, attributeContainer);
            this.getCatalog(jDSQuery, attributeContainer);
            this.getColDesc(jDSQuery, attributeContainer);
            attributeContainer.setDisplayMappingNames(stringArray);
            return this.dump(jDSQuery.getCatalog(), jDSQuery.getDataSourceName(), attributeContainer, stringArray, null, null, jDSQuery);
        }
        return null;
    }

    private void append(IExpression iExpression, ResultSetMetaData resultSetMetaData, AttributeContainer attributeContainer, JetUUniverse jetUUniverse, String string, String string2) throws DSException {
        Hashtable hashtable = new Hashtable();
        DSDataField dSDataField = null;
        if (iExpression != null) {
            JetUResourceEntity jetUResourceEntity = null;
            String[] stringArray = ExpressionToolKit.getDependentRefNames(iExpression, jetUUniverse, string, string2);
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (attributeContainer.getElementByAliasName(stringArray[i]) != null || (jetUResourceEntity = jetUUniverse.getResourceByName(string, string2, stringArray[i])) == null || (dSDataField = QueryTransform.createRdbDataField(jetUResourceEntity, hashtable)) == null) continue;
                    int n2 = -1;
                    try {
                        int n3 = resultSetMetaData.getColumnCount() + 1;
                        for (int j = 1; j < n3; ++j) {
                            if (!stringArray[i].equalsIgnoreCase(resultSetMetaData.getColumnName(j))) continue;
                            n2 = j;
                            break;
                        }
                        dSDataField.setFieldIndex(n2);
                        attributeContainer.add(dSDataField);
                        continue;
                    }
                    catch (Exception exception) {
                        throw new DSException(exception.getMessage());
                    }
                }
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    ModelKey modelKey = (ModelKey)enumeration.nextElement();
                    attributeContainer.addRelationModelFromParse(modelKey, (RelationModel)hashtable.get(modelKey));
                }
            }
        }
    }

    public static void appendAdditionalDBFields(String[] stringArray, ResultSetMetaData resultSetMetaData, AttributeContainer attributeContainer, JetUUniverse jetUUniverse, String string, String string2) throws DSException {
        Hashtable hashtable = new Hashtable();
        DSDataField dSDataField = null;
        JetUResourceEntity jetUResourceEntity = null;
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (attributeContainer.getElementByAliasName(stringArray[i]) != null || (jetUResourceEntity = jetUUniverse.getResourceByName(string, string2, stringArray[i])) == null) continue;
                dSDataField = QueryTransform.createRdbDataField(jetUResourceEntity, hashtable);
                if (dSDataField != null && resultSetMetaData != null) {
                    int n2 = -1;
                    try {
                        int n3 = resultSetMetaData.getColumnCount() + 1;
                        for (int j = 1; j < n3; ++j) {
                            if (!stringArray[i].equalsIgnoreCase(resultSetMetaData.getColumnName(j))) continue;
                            n2 = j;
                            break;
                        }
                        dSDataField.setFieldIndex(n2);
                    }
                    catch (Exception exception) {
                        throw new DSException(exception.getMessage());
                    }
                }
                if (dSDataField == null) continue;
                attributeContainer.add(dSDataField);
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                ModelKey modelKey = (ModelKey)enumeration.nextElement();
                attributeContainer.addRelationModelFromParse(modelKey, (RelationModel)hashtable.get(modelKey));
            }
        }
    }

    private void appendFormulas(JetUUniverse jetUUniverse, String string, String[] stringArray, MappingNameBindInfo[] mappingNameBindInfoArray, ResultSetMetaData resultSetMetaData, AttributeContainer attributeContainer) throws DSException {
        RdbDataField rdbDataField = null;
        int n = -1;
        block0: for (String string2 : stringArray) {
            if (attributeContainer.getElementByAliasName(string2) != null) continue;
            for (int i = 0; i < mappingNameBindInfoArray.length; ++i) {
                if (!string2.equalsIgnoreCase(mappingNameBindInfoArray[i].getMappingName())) continue;
                n = mappingNameBindInfoArray[i].getFieldIndex();
                this.createParameterMapping(n, resultSetMetaData);
                JetUResourceEntity jetUResourceEntity = jetUUniverse.getResourceByName(string, null, mappingNameBindInfoArray[i].getMappingName());
                if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUFormula && ((JetUFormula)jetUResourceEntity).isConstant()) continue;
                boolean bl = true;
                if (jetUResourceEntity != null) {
                    bl = jetUResourceEntity.getColDesc().isIgnoreCase();
                }
                rdbDataField = this.createFormulaMapping(mappingNameBindInfoArray[i], resultSetMetaData, n, i);
                rdbDataField.setCaseSensitive(!bl);
                attributeContainer.add(rdbDataField);
                continue block0;
            }
        }
    }

    private RdbDataField createFormulaMapping(MappingNameBindInfo mappingNameBindInfo, ResultSetMetaData resultSetMetaData, int n, int n2) throws DSException {
        RdbDataField rdbDataField = null;
        try {
            String string = resultSetMetaData.getColumnName(n);
            String string2 = mappingNameBindInfo.getMappingName();
            int n3 = resultSetMetaData.getColumnType(n);
            int n4 = resultSetMetaData.isNullable(n);
            int n5 = resultSetMetaData.getPrecision(n);
            int n6 = resultSetMetaData.getPrecision(n);
            int n7 = resultSetMetaData.getScale(n);
            rdbDataField = new RdbDataField(string);
            rdbDataField.setAliasName(string2);
            rdbDataField.setFieldIndex(n);
            rdbDataField.setDataType(Types.sqlTypeToType(n3));
            rdbDataField.setIsNullable(n4);
            rdbDataField.setLength(n5);
            rdbDataField.setPrecision(n6);
            rdbDataField.setScale(n7);
            rdbDataField.setFieldIndex(mappingNameBindInfo.getFieldIndex());
        }
        catch (SQLException sQLException) {
            throw new DSException(5033, new Object[]{"can not found collum : " + sQLException.getMessage()}, (Throwable)sQLException);
        }
        return rdbDataField;
    }

    private void createParameterMapping(int n, ResultSetMetaData resultSetMetaData) throws DSException {
        try {
            if (n < 1 || n > resultSetMetaData.getColumnCount()) {
                throw new DSException(5035, new Object[]{"col index out of bounds : " + n});
            }
        }
        catch (SQLException sQLException) {
            throw new DSException(5036, new Object[]{"can't get column count"});
        }
    }

    private ResultSetMetaData createRdbDataField(JDSQuery jDSQuery, DataDescription dataDescription) throws DSException {
        ResultSetMetaData resultSetMetaData = null;
        try {
            if (jDSQuery.getResultSet() != null) {
                resultSetMetaData = jDSQuery.getResultSet().getMetaData();
            }
        }
        catch (DSException dSException) {
            throw dSException;
        }
        catch (Exception exception) {
            throw new DSException(5030, new Object[]{"SQLException : " + exception.getMessage()}, (Throwable)exception);
        }
        return resultSetMetaData;
    }

    private AttributeContainer desiredAssertionStatus(String[] stringArray, JDSQuery jDSQuery, DataDescription dataDescription) throws DSException {
        String string = jDSQuery.getDataSourceName();
        JetUUniverse jetUUniverse = jDSQuery.getCatalog();
        String string2 = jDSQuery.getQueryName();
        JetUQueriable jetUQueriable = jetUUniverse.getQueriableByResourceName(string, string2);
        AttributeContainer attributeContainer = new AttributeContainer();
        this.getColumnName(stringArray, string, jetUUniverse, attributeContainer, jDSQuery.getQueryName());
        this.getColumnCount(jDSQuery, jetUQueriable, attributeContainer);
        DynamicQueryAttContainerParser.appendFormulas(jDSQuery.getCatalog(), jDSQuery.getDataSourceName(), stringArray, attributeContainer);
        this.getColDesc(jDSQuery, attributeContainer);
        this.getAllNeedFormulaMappingNames(attributeContainer);
        attributeContainer.setDisplayMappingNames(stringArray);
        return this.dump(jDSQuery.getCatalog(), jDSQuery.getDataSourceName(), attributeContainer, stringArray, null, null, jDSQuery);
    }

    private AttributeContainer dump(JetUUniverse jetUUniverse, String string, AttributeContainer attributeContainer, String[] stringArray, MappingNameBindInfo[] mappingNameBindInfoArray, ResultSetMetaData resultSetMetaData, JDSQuery jDSQuery) throws DSException {
        FormulaEnvTools formulaEnvTools = new FormulaEnvTools(attributeContainer.getOutputFunctionMappingNames(), new FormulaFetcher4Universe(jetUUniverse, string, RawDataQueryTools.getReportDefineJetRptFormulas(jDSQuery)));
        this.get(jetUUniverse, string, mappingNameBindInfoArray, resultSetMetaData, attributeContainer, formulaEnvTools, jDSQuery.getQueryName());
        this.equalsIgnoreCase(jetUUniverse, string, attributeContainer, formulaEnvTools);
        return attributeContainer;
    }

    private void equalsIgnoreCase(JetUUniverse jetUUniverse, String string, AttributeContainer attributeContainer, FormulaEnvTools formulaEnvTools) throws DSException {
        String[] stringArray = formulaEnvTools.getAllNeedFormulaMappingNames();
        FormulaMapping formulaMapping = null;
        for (int i = 0; i < stringArray.length; ++i) {
            JetUResourceEntity jetUResourceEntity = jetUUniverse.getResourceByName(string, null, stringArray[i]);
            if (!(jetUResourceEntity instanceof JetUFormula)) continue;
            JetUFormula jetUFormula = (JetUFormula)jetUResourceEntity;
            formulaMapping = QueryTransform.createFormulaMapping(jetUFormula);
            formulaMapping.dump();
            attributeContainer.add(formulaMapping);
        }
    }

    private void get(JetUUniverse jetUUniverse, String string, MappingNameBindInfo[] mappingNameBindInfoArray, ResultSetMetaData resultSetMetaData, AttributeContainer attributeContainer, FormulaEnvTools formulaEnvTools, String string2) {
        String[] stringArray = formulaEnvTools.getAllNeedDbFieldMappingNames();
        if (stringArray != null && stringArray.length > 0) {
            try {
                if (resultSetMetaData == null) {
                    this.getColumnName(stringArray, string, jetUUniverse, attributeContainer, string2);
                } else {
                    this.appendFormulas(jetUUniverse, string, stringArray, mappingNameBindInfoArray, resultSetMetaData, attributeContainer);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean getAllNeedDbFieldMappingNames(MappingNameBindInfo[] mappingNameBindInfoArray, String string) {
        for (int i = 0; i < mappingNameBindInfoArray.length; ++i) {
            if (!mappingNameBindInfoArray[i].getMappingName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void getAllNeedFormulaMappingNames(AttributeContainer attributeContainer) {
    }

    public static void appendFormulas(JetUUniverse jetUUniverse, String string, String[] stringArray, AttributeContainer attributeContainer) throws DSException {
        FormulaMapping formulaMapping = null;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            JetUResourceEntity jetUResourceEntity = jetUUniverse.getResourceByName(string, null, stringArray[i]);
            if (!(jetUResourceEntity instanceof JetUFormula)) continue;
            JetUFormula jetUFormula = (JetUFormula)jetUResourceEntity;
            formulaMapping = QueryTransform.createFormulaMapping(jetUFormula);
            formulaMapping.dump();
            attributeContainer.add(formulaMapping);
        }
    }

    private void getCatalog(JDSQuery jDSQuery, AttributeContainer attributeContainer) throws DSException {
        JetUUniverse jetUUniverse = jDSQuery.getCatalog();
        String string = jDSQuery.getDataSourceName();
        IExpression iExpression = jDSQuery.getFilters();
        if (iExpression != null) {
            String[] stringArray = ExpressionToolKit.getDependentForNames(iExpression);
            FormulaMapping formulaMapping = null;
            JetUResourceEntity jetUResourceEntity = null;
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (attributeContainer.getElementByAliasName(stringArray[i]) != null || !((jetUResourceEntity = jetUUniverse.getResourceByName(string, null, stringArray[i])) instanceof JetUFormula)) continue;
                    JetUFormula jetUFormula = (JetUFormula)jetUResourceEntity;
                    formulaMapping = QueryTransform.createFormulaMapping(jetUFormula);
                    attributeContainer.add(formulaMapping);
                }
            }
        }
    }

    private void getColDesc(JRawDataQuery jRawDataQuery, AttributeContainer attributeContainer) throws DSException {
        FormulaMapping formulaMapping = null;
        Hashtable hashtable = jRawDataQuery.getReportFormulas();
        for (JetUFormula jetUFormula : hashtable.values()) {
            if (!QueryTransform.isConstantFormula(jetUFormula) && !QueryTransform.isPass1Formula(jetUFormula)) continue;
            formulaMapping = QueryTransform.createFormulaMapping(jetUFormula);
            attributeContainer.add(formulaMapping);
        }
    }

    private void getColumnCount(JDSQuery jDSQuery, JetUQueriable jetUQueriable, AttributeContainer attributeContainer) throws DSException {
        ParameterValueList parameterValueList = jDSQuery.getParameterValues();
        if (parameterValueList != null && parameterValueList.size() > 0) {
            ParamDesc[] paramDescArray = parameterValueList.getParameterDescriptions();
            int n = paramDescArray.length;
            for (int i = 0; i < n; ++i) {
                ParameterMapping parameterMapping = QueryTransform.createParameterMapping(jDSQuery.getCatalog(), jDSQuery.getDataSourceName(), jetUQueriable, paramDescArray[i]);
                attributeContainer.add(parameterMapping);
            }
        }
    }

    private void getColumnName(String[] stringArray, String string, JetUUniverse jetUUniverse, AttributeContainer attributeContainer, String string2) throws DSException {
        Object object;
        DSDataField dSDataField = null;
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < stringArray.length; ++i) {
            if (attributeContainer.getElementByAliasName(stringArray[i]) != null) continue;
            object = jetUUniverse.getResourceByName(string, string2, stringArray[i]);
            if (object == null) {
                throw new IllegalArgumentException("can not found resource entity : [" + stringArray[i] + "] in database: [" + string + "]");
            }
            dSDataField = QueryTransform.createRdbDataField((JetUResourceEntity)object, hashtable);
            if (dSDataField == null) continue;
            attributeContainer.add(dSDataField);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (ModelKey)enumeration.nextElement();
            attributeContainer.addRelationModelFromParse((ModelKey)object, (RelationModel)hashtable.get(object));
        }
    }
}

