/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.queryengine.transform;

import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.tuple.ITupleExpression;

public class JoinObject {
    public static final int INNER_JOIN = 0;
    public static final int FULL_OUTER_JOIN = 1;
    public static final int LEFT_OUTER_JOIN = 2;
    public static final int RIGHT_OUTER_JOIN = 3;
    public static final int SELF_JOIN = 4;
    private String[] SEDU = new String[2];
    private ITupleExpression append = null;
    private int buildAndExpression = -1;

    public JoinObject(String string, String string2, ITupleExpression iTupleExpression, int n) {
        this.SEDU[0] = string;
        this.SEDU[1] = string2;
        this.append = iTupleExpression;
        this.buildAndExpression = n;
    }

    public boolean contains(String string) {
        return this.SEDU[0].equals(string) || this.SEDU[1].equals(string);
    }

    public ITupleExpression getJoinExp() {
        return this.append;
    }

    public boolean equals(Object object) {
        if (object instanceof JoinObject) {
            JoinObject joinObject = (JoinObject)object;
            if (!this.isOuterJoin()) {
                return this.contains(joinObject.getRelationModelName1()) && this.contains(joinObject.getRelationModelName2());
            }
            if (!joinObject.isOuterJoin() || this.isFullOuterJoin()) {
                return this.contains(joinObject.getRelationModelName1()) && this.contains(joinObject.getRelationModelName2());
            }
            if (this.isLeftOuterJoin() && joinObject.isRightOuterJoin() || this.isRightOuterJoin() && joinObject.isLeftOuterJoin()) {
                return this.getRelationModelName1().equalsIgnoreCase(joinObject.getRelationModelName2()) && this.getRelationModelName2().equalsIgnoreCase(joinObject.getRelationModelName1());
            }
            return this.getRelationModelName1().equalsIgnoreCase(joinObject.getRelationModelName1()) && this.getRelationModelName2().equalsIgnoreCase(joinObject.getRelationModelName2());
        }
        return false;
    }

    public String getRelationModelName2() {
        return this.SEDU[1];
    }

    public String getRelationModelName1() {
        return this.SEDU[0];
    }

    public JoinObject merge(JoinObject joinObject) throws ConditionException {
        if (this.isInnerJoin() || this.isSelfJoin()) {
            if (this.equals(joinObject)) {
                joinObject.append = ExpressionToolKit.buildAndExpression(this.append, joinObject.getJoinExp());
                return joinObject;
            }
            throw new UnsupportedOperationException();
        }
        if (this.isOuterJoin()) {
            if (this.isFullOuterJoin()) {
                if (joinObject.isFullOuterJoin() || joinObject.isLeftOuterJoin() || joinObject.isRightOuterJoin() || joinObject.isSelfJoin()) {
                    if (this.equals(joinObject)) {
                        this.append = ExpressionToolKit.buildAndExpression(this.append, joinObject.getJoinExp());
                        return this;
                    }
                    throw new UnsupportedOperationException();
                }
                throw new UnsupportedOperationException();
            }
            if (this.isLeftOuterJoin()) {
                if (joinObject.isFullOuterJoin()) {
                    if (this.equals(joinObject)) {
                        joinObject.append = ExpressionToolKit.buildAndExpression(this.append, joinObject.getJoinExp());
                        return joinObject;
                    }
                    throw new UnsupportedOperationException();
                }
                if (joinObject.isLeftOuterJoin() || joinObject.isSelfJoin() || joinObject.isInnerJoin()) {
                    if (this.equals(joinObject)) {
                        this.append = ExpressionToolKit.buildAndExpression(this.append, joinObject.getJoinExp());
                        return this;
                    }
                    throw new UnsupportedOperationException();
                }
                throw new UnsupportedOperationException();
            }
            if (this.isRightOuterJoin()) {
                if (joinObject.isFullOuterJoin()) {
                    if (this.equals(joinObject)) {
                        joinObject.append = ExpressionToolKit.buildAndExpression(this.append, joinObject.getJoinExp());
                        return joinObject;
                    }
                    throw new UnsupportedOperationException();
                }
                if (joinObject.isRightOuterJoin() || joinObject.isSelfJoin() || joinObject.isInnerJoin()) {
                    if (this.equals(joinObject)) {
                        this.append = ExpressionToolKit.buildAndExpression(this.append, joinObject.getJoinExp());
                        return this;
                    }
                    throw new UnsupportedOperationException();
                }
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "[" + this.SEDU[0] + this.SEDU() + this.SEDU[1] + " (" + this.append.toString() + ") ]";
    }

    private String SEDU() {
        switch (this.buildAndExpression) {
            case 0: {
                return " Inner Join ";
            }
            case 1: {
                return " Full Outer Join ";
            }
            case 2: {
                return " Left Outer Join ";
            }
            case 3: {
                return " Right Outer Join ";
            }
            case 4: {
                return " Self Join ";
            }
        }
        return " Unknow Join ";
    }

    public static String getJoinType(int n) {
        switch (n) {
            case 0: {
                return " Inner Join ";
            }
            case 1: {
                return " Full Outer Join ";
            }
            case 2: {
                return " Left Outer Join ";
            }
            case 3: {
                return " Right Outer Join ";
            }
            case 4: {
                return " Self Join ";
            }
        }
        return " Unknow Join ";
    }

    public boolean isInnerJoin() {
        return this.buildAndExpression == 0;
    }

    public boolean isLeftOuterJoin() {
        return this.buildAndExpression == 2;
    }

    public boolean isRightOuterJoin() {
        return this.buildAndExpression == 3;
    }

    public boolean isFullOuterJoin() {
        return this.buildAndExpression == 1;
    }

    public boolean isOuterJoin() {
        return this.buildAndExpression == 1 || this.buildAndExpression == 2 || this.buildAndExpression == 3;
    }

    public int getJoinState() {
        return this.buildAndExpression;
    }

    public boolean isSelfJoin() {
        return this.buildAndExpression == 4;
    }
}

