/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.dbbuffer;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.dataservice.relational.swap.PooledRecord;
import com.jinfonet.datatypes.JinfonetArrayBaseObject;
import com.jinfonet.datatypes.JinfonetBlobBaseBytes;
import com.jinfonet.datatypes.JinfonetClobBaseString;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.math.BigDecimal;
import jet.connect.DbArray;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;

public class DataMapTool {
    public static void dbValue2PooledRecord(int n, PooledRecord pooledRecord, DbValue dbValue) throws DSException {
        if (dbValue.desc.isArray()) {
            DbArray dbArray = (DbArray)dbValue;
            pooledRecord.putArray(new JinfonetArrayBaseObject(dbArray));
            return;
        }
        switch (n) {
            case 5: {
                pooledRecord.putShort(((DbSmallInt)dbValue).value);
                break;
            }
            case -6: {
                pooledRecord.putByte(((DbTinyInt)dbValue).byteValue());
                break;
            }
            case 4: {
                pooledRecord.putInt(((DbInteger)dbValue).value);
                break;
            }
            case -5: {
                pooledRecord.putLong(((DbBigInt)dbValue).value);
                break;
            }
            case 7: {
                pooledRecord.putFloat(((DbReal)dbValue).value);
                break;
            }
            case 2: 
            case 3: {
                pooledRecord.putBigDecimal(((DbDecimal)dbValue).value);
                break;
            }
            case 6: 
            case 8: {
                pooledRecord.putDouble(((DbDouble)dbValue).value);
                break;
            }
            case -7: {
                pooledRecord.putBoolean(((DbBit)dbValue).value);
                break;
            }
            case 91: {
                pooledRecord.putDate(((DbDate)dbValue).value);
                break;
            }
            case 92: {
                pooledRecord.putTime(((DbTime)dbValue).value);
                break;
            }
            case 93: {
                pooledRecord.putTimeStamp(((DbTimestamp)dbValue).value, ((DbTimestamp)dbValue).nanos);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                pooledRecord.putString(((DbChar)dbValue).value);
                break;
            }
            case 2005: {
                if (dbValue.bNull) {
                    pooledRecord.putClob(null);
                    break;
                }
                pooledRecord.putClob(new JinfonetClobBaseString(((DbChar)dbValue).value));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                pooledRecord.putBytes(((DbBinary)dbValue).value);
                break;
            }
            case 2004: {
                if (dbValue.bNull) {
                    pooledRecord.putBlob(null);
                    break;
                }
                pooledRecord.putBlob(new JinfonetBlobBaseBytes(((DbBinary)dbValue).value));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public static void pooledRecord2DbValue(int n, ITuple iTuple, int n2, DbValue dbValue) throws DSException {
        if (dbValue.desc.isArray()) {
            Array array = iTuple.getArray(n2);
            if (!iTuple.wasNull()) {
                Object object;
                Object object2 = array.getArray();
                switch (dbValue.desc.sqlType) {
                    case 91: {
                        JinfonetDate[] jinfonetDateArray = (JinfonetDate[])object2;
                        long[] lArray = new long[jinfonetDateArray.length];
                        for (int i = 0; i < lArray.length; ++i) {
                            lArray[i] = jinfonetDateArray[i].getTime();
                        }
                        object = lArray;
                        break;
                    }
                    case 92: {
                        JinfonetTime[] jinfonetTimeArray = (JinfonetTime[])object2;
                        long[] lArray = new long[jinfonetTimeArray.length];
                        for (int i = 0; i < lArray.length; ++i) {
                            lArray[i] = jinfonetTimeArray[i].getTime();
                        }
                        object = lArray;
                        break;
                    }
                    case 93: {
                        JinfonetTimeStamp[] jinfonetTimeStampArray = (JinfonetTimeStamp[])object2;
                        long[] lArray = new long[jinfonetTimeStampArray.length];
                        int[] nArray = new int[lArray.length];
                        for (int i = 0; i < lArray.length; ++i) {
                            nArray[i] = jinfonetTimeStampArray[i].getNanos();
                            lArray[i] = jinfonetTimeStampArray[i].getTime() - (long)(nArray[i] / 1000000);
                        }
                        object = lArray;
                        ((DbArray)dbValue).setNanos(nArray);
                        break;
                    }
                    default: {
                        object = object2;
                    }
                }
                ((DbArray)dbValue).set(array.getBaseType(), object);
            }
            return;
        }
        switch (n) {
            case 5: {
                ((DbSmallInt)dbValue).set(iTuple.getShort(n2));
                break;
            }
            case -6: {
                ((DbTinyInt)dbValue).set(iTuple.getByte(n2));
                break;
            }
            case 4: {
                ((DbInteger)dbValue).set(iTuple.getInt(n2));
                break;
            }
            case -5: {
                ((DbBigInt)dbValue).set(iTuple.getLong(n2));
                break;
            }
            case 7: {
                ((DbReal)dbValue).set(iTuple.getFloat(n2));
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = iTuple.getBigDecimal(n2);
                if (bigDecimal == null) {
                    ((DbDecimal)dbValue).bNull = true;
                    break;
                }
                ((DbDecimal)dbValue).set(bigDecimal);
                break;
            }
            case 6: 
            case 8: {
                ((DbDouble)dbValue).set(iTuple.getDouble(n2));
                break;
            }
            case -7: {
                ((DbBit)dbValue).set(iTuple.getBoolean(n2));
                break;
            }
            case 91: {
                Date date = iTuple.getDate(n2);
                if (date == null) break;
                ((DbDate)dbValue).set(date.getTime());
                break;
            }
            case 92: {
                Time time2 = iTuple.getTime(n2);
                if (time2 == null) break;
                ((DbTime)dbValue).set(time2.getTime());
                break;
            }
            case 93: {
                DbTimestamp dbTimestamp = (DbTimestamp)dbValue;
                Timestamp timestamp = iTuple.getTimeStamp(n2);
                if (timestamp == null) {
                    dbTimestamp.bNull = true;
                    break;
                }
                dbTimestamp.set(timestamp.getTime() - (long)(timestamp.getNanos() / 1000000));
                dbTimestamp.setNanos(timestamp.getNanos());
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                ((DbChar)dbValue).set(iTuple.getString(n2));
                break;
            }
            case 2005: {
                Clob clob = iTuple.getClob(n2);
                if (clob == null) {
                    ((DbChar)dbValue).bNull = true;
                    break;
                }
                ((DbChar)dbValue).set(clob.getSubString(1L, (int)clob.length()));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                ((DbBinary)dbValue).set(iTuple.getBytes(n2));
                break;
            }
            case 2004: {
                Blob blob = iTuple.getBlob(n2);
                if (blob == null) {
                    ((DbBinary)dbValue).bNull = true;
                    break;
                }
                ((DbBinary)dbValue).set(blob.getBytes(1L, (int)blob.length()));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }
}

