/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.dbbuffer;

import jet.connect.DbColDesc;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JDbBufferData;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.dbbuffer.JRecordModel;
import jet.dataengine.util.DSLog;
import jet.dataengine8.dbbuffer.DbBufferRecord;
import jet.dataengine8.dbbuffer.IDbBufferRecordID;

public abstract class DbBufferCursor
implements JDbBufferCursor {
    DSLog log = DSLog.getDSLog(DbBufferCursor.class.getName());
    private JDbBufferData SEDU;
    protected boolean isClose = false;
    protected IDbBufferRecordID recordIndex;
    private int afterLast;

    DbBufferCursor(JDbBufferData jDbBufferData) {
        this.SEDU = jDbBufferData;
    }

    void checkClose() throws DSException {
        if (this.isClose) {
            throw new DSException(6001);
        }
    }

    @Override
    public int size() throws DSException {
        this.checkClose();
        return this.recordIndex.size();
    }

    @Override
    public boolean previous() throws DSException {
        this.checkClose();
        boolean bl = this.recordIndex.previous();
        this.onChangePosition();
        return bl;
    }

    @Override
    public boolean next() throws DSException {
        this.checkClose();
        boolean bl = this.recordIndex.next();
        this.onChangePosition();
        return bl;
    }

    @Override
    public void beforeFirst() throws DSException {
        this.checkClose();
        this.recordIndex.beforeFirst();
        this.onChangePosition();
    }

    @Override
    public boolean isBeforeFirst() throws DSException {
        this.checkClose();
        return this.recordIndex.isBeforeFirst();
    }

    @Override
    public void afterLast() throws DSException {
        this.checkClose();
        this.recordIndex.afterLast();
        this.onChangePosition();
    }

    @Override
    public boolean isAfterLast() throws DSException {
        this.checkClose();
        return this.recordIndex.isAfterLast();
    }

    @Override
    public boolean first() throws DSException {
        this.checkClose();
        boolean bl = this.recordIndex.first();
        this.onChangePosition();
        return bl;
    }

    @Override
    public boolean isFirst() throws DSException {
        this.checkClose();
        return this.recordIndex.isFirst();
    }

    @Override
    public boolean last() throws DSException {
        this.checkClose();
        boolean bl = this.recordIndex.last();
        this.onChangePosition();
        return bl;
    }

    @Override
    public boolean isLast() throws DSException {
        this.checkClose();
        return this.recordIndex.isLast();
    }

    private void $assertionsDisabled(JRecord jRecord) throws DSException {
        assert (jRecord instanceof DbBufferRecord);
        this.checkClose();
        if (!this.recordIndex.currentIndexIsAvailable()) {
            throw new DSException(6002);
        }
        jRecord.setPosition(this.recordIndex.getCurrentIndex());
        jRecord.refresh();
    }

    @Override
    public void setPosition(int n) throws DSException {
        this.checkClose();
        this.recordIndex.setPosition(n);
        this.onChangePosition();
    }

    @Override
    public int getPosition() throws DSException {
        this.checkClose();
        return (int)this.recordIndex.getPosition();
    }

    protected void onChangePosition() {
    }

    @Override
    public void nextRecord(JRecord jRecord) throws DSException {
        if (!this.next()) {
            throw new DSException(6003);
        }
        this.$assertionsDisabled(jRecord);
    }

    @Override
    public void setID(int n) {
        this.afterLast = n;
    }

    @Override
    public String toString() {
        return super.toString() + '@' + this.afterLast;
    }

    @Override
    public int isNoRecord() throws DSException {
        this.checkClose();
        if (this.getCurrentEnd() > 0) {
            return 3;
        }
        if (this.finished()) {
            if (this.getCurrentEnd() == 0) {
                return 2;
            }
            return 3;
        }
        return 1;
    }

    @Override
    public boolean isFastPass() {
        return false;
    }

    public DbColDesc[] getColDescs() {
        return this.getRecordModel().getColDescs();
    }

    public int indexOfCell(String string) {
        return this.getRecordModel().indexOfCell(string);
    }

    public int countColumns() {
        return this.getRecordModel().getColDescs().length;
    }

    @Override
    public boolean finished() {
        return this.recordIndex.finished();
    }

    public DbColDesc getColDesc(int n) {
        return this.getColDesc(n);
    }

    public int getReadCursor() {
        int n = 0;
        try {
            n = this.getPosition();
        }
        catch (DSException dSException) {
            // empty catch block
        }
        return n;
    }

    public void setReadCursor(int n) {
        try {
            this.setPosition(n);
        }
        catch (DSException dSException) {
            this.log.warn(0, dSException);
        }
    }

    public Object clone() {
        JDbBufferCursor jDbBufferCursor = null;
        try {
            jDbBufferCursor = this.SEDU.createCursor();
        }
        catch (DSException dSException) {
            this.log.error(0, dSException);
        }
        try {
            jDbBufferCursor.setPosition(this.getPosition());
        }
        catch (DSException dSException) {
            this.log.error(0, dSException);
        }
        return jDbBufferCursor;
    }

    public int getCurrentRecordIndex() throws DSException {
        this.checkClose();
        return this.recordIndex.getCurrentIndex();
    }

    @Override
    public JRecordModel getRecordModel() {
        return this.SEDU.getRecordModel();
    }

    int getRowID(int n) throws DSException {
        this.checkClose();
        return this.recordIndex.getRowID(n);
    }

    @Override
    public int getPosition(int n) throws DSException {
        this.checkClose();
        return this.recordIndex.getPosition(n);
    }
}

