/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.dbbuffer;

import jet.dataengine.api.DSException;
import jet.dataengine.api.EnvironmentPropertiesFactory;
import jet.dataengine.api.config.DbBufferConfig;
import jet.dataengine.api.dbbuffer.DbBufferDataFactory;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JDbBufferData;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.dbbuffer.RecordConvertor;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.api.query.GroupQueryOption;
import jet.dataengine8.dbbuffer.DbBufferCursorAdapterRelation;
import jet.dataengine8.dbbuffer.DbBufferDataEmpty;
import jet.dataengine8.dbbuffer.DbBufferDataFastPast;
import jet.dataengine8.dbbuffer.DbBufferDataImpl;
import jet.dataengine8.dbbuffer.DbBufferDataRefImpl;
import jet.dataengine8.dbbuffer.RecordFake;
import jet.dataengine8.dbbuffer.RecordModel;

public class DbBufferDataImplFactory
extends DbBufferDataFactory {
    @Override
    public JDbBufferData createDbBufferDataRef(JDbBufferCursor jDbBufferCursor, RecordModelInfo recordModelInfo, long l, long l2, DbBufferConfig dbBufferConfig) throws DSException {
        DbBufferDataRefImpl dbBufferDataRefImpl = null;
        assert (jDbBufferCursor instanceof DbBufferCursorAdapterRelation);
        if (l <= 0L || l2 <= 0L) {
            l = 0L;
            l2 = 0L;
        }
        dbBufferDataRefImpl = new DbBufferDataRefImpl(jDbBufferCursor, recordModelInfo, l, l2, dbBufferConfig);
        return dbBufferDataRefImpl;
    }

    @Override
    public JDbBufferData createDbBufferData(RecordModelInfo recordModelInfo, long l, long l2, DbBufferConfig dbBufferConfig) throws DSException {
        DbBufferDataImpl dbBufferDataImpl = null;
        dbBufferDataImpl = new DbBufferDataImpl(recordModelInfo, l, l2, dbBufferConfig);
        return dbBufferDataImpl;
    }

    @Override
    public JDbBufferData createDbBufferData(RecordModelInfo recordModelInfo, long l, long l2, boolean bl, DbBufferConfig dbBufferConfig) throws DSException {
        JDbBufferData jDbBufferData = null;
        if (bl) {
            int n = EnvironmentPropertiesFactory.getEnviromentProperties().getDataCacheOption().getFastPassPipeLength();
            jDbBufferData = new DbBufferDataFastPast(recordModelInfo, n, dbBufferConfig);
        } else {
            if (l <= 0L || l2 <= 0L) {
                l = 0L;
                l2 = 0L;
            }
            jDbBufferData = new DbBufferDataImpl(recordModelInfo, l, l2, dbBufferConfig);
        }
        return jDbBufferData;
    }

    @Override
    public JDbBufferData createDbBufferDataEmpty(JRecord jRecord, RecordModelInfo recordModelInfo, DbBufferConfig dbBufferConfig) throws DSException {
        RecordConvertor recordConvertor = new RecordConvertor(jRecord.getRecordModel(), new RecordModel(recordModelInfo));
        RecordFake recordFake = new RecordFake(recordModelInfo);
        recordConvertor.Refresh(jRecord, recordFake);
        recordFake.update();
        return new DbBufferDataEmpty(recordFake, dbBufferConfig);
    }

    @Override
    public JDbBufferData createDbBufferData(RecordModelInfo recordModelInfo, GroupQueryOption groupQueryOption, boolean bl, DbBufferConfig dbBufferConfig) throws DSException {
        JDbBufferData jDbBufferData = null;
        if (bl) {
            int n = EnvironmentPropertiesFactory.getEnviromentProperties().getDataCacheOption().getFastPassPipeLength();
            jDbBufferData = new DbBufferDataFastPast(recordModelInfo, n, dbBufferConfig);
        } else {
            jDbBufferData = new DbBufferDataImpl(recordModelInfo, groupQueryOption, dbBufferConfig);
        }
        return jDbBufferData;
    }

    @Override
    public JDbBufferData createDbBufferDataRef(JDbBufferCursor jDbBufferCursor, RecordModelInfo recordModelInfo, GroupQueryOption groupQueryOption, DbBufferConfig dbBufferConfig) throws DSException {
        DbBufferDataRefImpl dbBufferDataRefImpl = null;
        assert (jDbBufferCursor instanceof DbBufferCursorAdapterRelation);
        dbBufferDataRefImpl = new DbBufferDataRefImpl(jDbBufferCursor, recordModelInfo, groupQueryOption, dbBufferConfig);
        return dbBufferDataRefImpl;
    }
}

