/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.dbbuffer;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.RelationOption;
import com.jinfonet.dataservice.relational.swap.ARelationPool;
import com.jinfonet.dataservice.relational.swap.PooledRecord;
import com.jinfonet.dataservice.relational.swap.RelationPool;
import java.util.ArrayList;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.DataCacheInfo;
import jet.dataengine.api.DataCacheOption;
import jet.dataengine.api.EnvironmentPropertiesFactory;
import jet.dataengine.api.config.DbBufferConfig;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JDbBufferData;
import jet.dataengine.api.dbbuffer.JDbBufferWriteAbleCursor;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.dbbuffer.JRecordModel;
import jet.dataengine.api.dbbuffer.RecordConvertor;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.api.query.GroupQueryOption;
import jet.dataengine.util.DSLog;
import jet.dataengine8.dbbuffer.DataMapTool;
import jet.dataengine8.dbbuffer.DbBufferCursorRefImpl;
import jet.dataengine8.dbbuffer.DbBufferDataAdapterRelation;
import jet.dataengine8.dbbuffer.DbBufferRecordIndex;
import jet.dataengine8.dbbuffer.IDbBufferRecordID;
import jet.dataengine8.dbbuffer.MetaDataTool;
import jet.dataengine8.dbbuffer.RecordFake;
import jet.dataengine8.dbbuffer.RecordModel;
import jet.dataengine8.dbbuffer.RecordTool;
import jet.dataengine8.dbbuffer.WriteAbleCurosrRef;
import jet.dataengine8.util.LogDebugTool;

public class DbBufferDataRefImpl
implements JDbBufferData {
    private static String Refresh = "DbBufferDataRef";
    static DSLog log = DSLog.getDSLog(DbBufferDataRefImpl.class.getName());
    private RelationPool SEDU;
    private RecordModel add;
    private int appendFinished;
    private int[] arraycopy;
    private boolean[] bNull;
    private int[] booleanArrayToStr;
    private RecordModelInfo close;
    private PooledRecord convert2RelationMetaData;
    private JDbBufferCursor countColumns;
    private boolean createRecord;
    private boolean dbValue2PooledRecord;
    private int deIndent = 0;
    private boolean debug = false;
    private JRecord desiredAssertionStatus;

    public DbBufferDataRefImpl(JDbBufferCursor jDbBufferCursor, RecordModelInfo recordModelInfo, long l, long l2, DbBufferConfig dbBufferConfig) throws DSException {
        log.debug("begin create a DbBufferDataImpl");
        log.indent(Refresh);
        log.debug("the Ref Cursor RecordModelInfo:");
        jDbBufferCursor.getRecordModel().dump(2);
        log.debug("the RecordModelInfo:");
        recordModelInfo.dump();
        this.countColumns = jDbBufferCursor;
        this.$assertionsDisabled(jDbBufferCursor.getRecordModel(), recordModelInfo);
        this.SEDU = this.Refresh(this.close, l, l2, false, dbBufferConfig);
        log.deIndent(Refresh);
        log.debug("end create a DbBufferDataImpl");
    }

    public DbBufferDataRefImpl(JDbBufferCursor jDbBufferCursor, RecordModelInfo recordModelInfo, GroupQueryOption groupQueryOption, DbBufferConfig dbBufferConfig) throws DSException {
        log.debug("begin create a DbBufferDataImpl");
        log.indent(Refresh);
        log.debug("the Ref Cursor RecordModelInfo:");
        jDbBufferCursor.getRecordModel().dump(2);
        log.debug("the RecordModelInfo:");
        recordModelInfo.dump();
        this.countColumns = jDbBufferCursor;
        this.$assertionsDisabled(jDbBufferCursor.getRecordModel(), recordModelInfo);
        this.SEDU = this.Refresh(this.close, groupQueryOption.getRecordsPerPage(), groupQueryOption.getMaxPageNumber(), groupQueryOption.isCacheZip(), dbBufferConfig);
        log.deIndent(Refresh);
        log.debug("end create a DbBufferDataImpl");
    }

    private void $assertionsDisabled(JRecordModel jRecordModel, RecordModelInfo recordModelInfo) {
        this.add = new RecordModel(recordModelInfo);
        this.appendFinished = this.add.countColumns();
        DbColDesc[] dbColDescArray = jRecordModel.getColDescs();
        DbColDesc[] dbColDescArray2 = recordModelInfo.getColDescs();
        this.bNull = new boolean[this.appendFinished];
        this.booleanArrayToStr = new int[this.appendFinished];
        int n = 0;
        ArrayList<DbColDesc> arrayList = new ArrayList<DbColDesc>();
        int[] nArray = new int[this.appendFinished + 1];
        arrayList.add(new DbColDesc("refCursorPosition", 4, 30, 30, 0, false));
        for (int i = 0; i < this.appendFinished; ++i) {
            String string = dbColDescArray2[i].getColName();
            boolean bl = false;
            for (int j = 0; j < dbColDescArray.length; ++j) {
                if (string == null || !string.equalsIgnoreCase(dbColDescArray[j].getColName())) continue;
                this.bNull[i] = true;
                this.booleanArrayToStr[i] = j;
                bl = true;
                break;
            }
            if (bl) continue;
            this.bNull[i] = false;
            this.booleanArrayToStr[i] = n + 2;
            nArray[n] = i;
            ++n;
            arrayList.add(new DbColDesc(dbColDescArray2[i]));
        }
        this.arraycopy = new int[arrayList.size() - 1];
        System.arraycopy(nArray, 0, this.arraycopy, 0, this.arraycopy.length);
        DbColDesc[] dbColDescArray3 = new DbColDesc[arrayList.size()];
        arrayList.toArray(dbColDescArray3);
        this.close = new RecordModelInfo(dbColDescArray3);
        log.debug("ref mapping:");
        log.debug(LogDebugTool.booleanArrayToStr(1, this.bNull));
        log.debug("ref colIndex:");
        log.debug(LogDebugTool.intArrayToStr(1, this.booleanArrayToStr));
        log.debug("local mapping to all:");
        log.debug(LogDebugTool.intArrayToStr(1, this.arraycopy));
        log.debug("locate relation Data's  recordModelInfo");
        this.close.dump();
    }

    private RelationPool Refresh(RecordModelInfo recordModelInfo, long l, long l2, boolean bl, DbBufferConfig dbBufferConfig) throws DSException {
        Object object;
        Object object2;
        long l3 = l * l2;
        if (l <= 0L || l2 <= 0L) {
            l3 = 0L;
        }
        int n = RecordTool.getRecordLen(recordModelInfo.getColDescs());
        int n2 = (int)l3 * n / 1024;
        int n3 = 0;
        RelationOption relationOption = new RelationOption();
        if (n2 == 0) {
            object2 = EnvironmentPropertiesFactory.getEnviromentProperties();
            object = object2.getDataCacheOption();
            n2 = ((DataCacheOption)object).getDefaultDbBufferCache();
        }
        relationOption.setLevelOneMemorySize(n2);
        relationOption.setLevelTwoMemeorySize(n3);
        relationOption.setCacheZip(bl);
        relationOption.setDiskStore(dbBufferConfig.getDiskStore());
        object2 = MetaDataTool.convert2RelationMetaData(recordModelInfo);
        object = new RelationPool("NoName", (JRelationMetaData)object2, relationOption);
        this.convert2RelationMetaData = (PooledRecord)((ARelationPool)object).createRecord();
        return object;
    }

    @Override
    public JRecordModel getRecordModel() {
        return this.add;
    }

    @Override
    public JDbBufferCursor createCursor() throws DSException {
        this.appendFinished();
        return new DbBufferCursorRefImpl(this);
    }

    @Override
    public void close() throws DSException {
        this.SEDU.close();
        this.countColumns.close();
        this.createRecord = true;
    }

    @Override
    public void addRecord(JRecord jRecord) throws DSException {
        assert (false);
    }

    @Override
    public void addRecord(JRecord jRecord, int n) throws DSException {
        this.SEDU();
        this.add(this.convert2RelationMetaData, jRecord, n);
        this.SEDU.appendRecord(this.convert2RelationMetaData);
        ++this.deIndent;
    }

    @Override
    public void finish() {
        this.dbValue2PooledRecord = true;
        this.SEDU.appendFinished();
    }

    private void SEDU() throws DSException {
        if (this.createRecord) {
            throw new DSException(6005);
        }
    }

    public boolean finished() {
        return this.dbValue2PooledRecord;
    }

    private void add(PooledRecord pooledRecord, JRecord jRecord, int n) throws DSException {
        pooledRecord.putInt(n);
        for (int i = 0; i < this.arraycopy.length; ++i) {
            DbValue dbValue = jRecord.getCell(this.arraycopy[i]);
            int n2 = this.add.getColDescs()[this.arraycopy[i]].sqlType;
            int n3 = Types.sqlTypeToType(n2);
            if (dbValue.bNull) {
                pooledRecord.putNull(n3);
                continue;
            }
            DataMapTool.dbValue2PooledRecord(n2, pooledRecord, dbValue);
        }
    }

    public IDbBufferRecordID createRecordIndex() throws DSException {
        return new DbBufferRecordIndex(this.SEDU);
    }

    public int getcurrentEnd() {
        return this.SEDU.getCurrentFilledRecordsCount();
    }

    public RelationPool getRd() {
        return this.SEDU;
    }

    public JDbBufferCursor getRefCursor() {
        return this.countColumns;
    }

    public boolean[] getIsRef() {
        return this.bNull;
    }

    public int[] getRefIndex() {
        return this.booleanArrayToStr;
    }

    public int[] getRelation2All() {
        return this.arraycopy;
    }

    @Override
    public JDbBufferWriteAbleCursor createWriteAbleCursor() throws DSException {
        this.appendFinished();
        this.debug = true;
        return new WriteAbleCurosrRef(this);
    }

    private void appendFinished() throws DSException {
        if (this.debug) {
            throw new DSException(6010);
        }
    }

    public int getRecords() {
        return this.deIndent;
    }

    @Override
    public int getType() {
        return 2;
    }

    public JRecord getFakeRecord() {
        return this.desiredAssertionStatus;
    }

    public void setFakeRecord(DbBufferDataAdapterRelation dbBufferDataAdapterRelation) {
        RecordFake recordFake = dbBufferDataAdapterRelation.getFakeRecord();
        RecordConvertor recordConvertor = new RecordConvertor(recordFake.getRecordModel(), this.getRecordModel());
        RecordFake recordFake2 = new RecordFake(this.add);
        recordConvertor.Refresh(recordFake, recordFake2);
        recordFake2.update();
        recordFake2.setPosition(1);
        this.desiredAssertionStatus = recordFake2;
    }

    @Override
    public DataCacheInfo getDataCacheInfo() {
        return this.SEDU.getDataCacheInfo();
    }
}

