/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.dbbuffer;

import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.dataservice.relational.swap.PooledRecord;
import jet.connect.DbColDesc;
import jet.connect.DbInteger;
import jet.connect.DbValue;
import jet.connect.Groupable;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.dbbuffer.JRecordModel;
import jet.dataengine.util.DSLog;
import jet.dataengine8.dbbuffer.DataMapTool;
import jet.dataengine8.dbbuffer.DbBufferCursor;
import jet.util.DbValueable;

public class DbBufferRecord
implements JRecord {
    static DSLog log = DSLog.getDSLog(DbBufferRecord.class.getName());
    private ITuple SEDU;
    protected DbValue[] cells = null;
    protected DbValue[] tempCells = null;
    int columnCount;
    private int append;
    private JRecordModel bNull;
    private DbBufferCursor countColumns;
    public int hit = 0;
    public int total_access = 0;
    private int[] dbValue2PooledRecord;
    private boolean debug = false;

    public DbBufferRecord(ITuple iTuple, DbBufferCursor dbBufferCursor) {
        this.SEDU = iTuple;
        this.countColumns = dbBufferCursor;
        this.bNull = dbBufferCursor.getRecordModel();
        this.columnCount = this.bNull.getColDescs().length;
        this.cells = new DbValue[this.columnCount];
        this.tempCells = new DbValue[this.columnCount];
        this.dbValue2PooledRecord = new int[this.columnCount];
        DbColDesc[] dbColDescArray = this.bNull.getColDescs();
        for (int i = 0; i < dbColDescArray.length; ++i) {
            this.cells[i] = DbValue.makeDbValue(dbColDescArray[i]);
            this.tempCells[i] = DbValue.makeDbValue(dbColDescArray[i]);
            this.dbValue2PooledRecord[i] = dbColDescArray[i].sqlType;
        }
        this.debug = dbColDescArray[0].sqlType == 4 && !dbColDescArray[0].isArray();
    }

    private void SEDU(int n) throws DSException {
        this.SEDU.init(this.append(n));
        for (int i = 0; i < this.columnCount; ++i) {
            DataMapTool.pooledRecord2DbValue(this.dbValue2PooledRecord[i], this.SEDU, i + 1, this.cells[i]);
            this.cells[i].bNull = this.SEDU.wasNull();
        }
    }

    @Override
    public DbValue[] getValueArray() {
        return this.cells;
    }

    @Override
    public void update() {
        PooledRecord pooledRecord = (PooledRecord)this.SEDU;
        try {
            this.cells();
            pooledRecord.update(this.append(this.append));
        }
        catch (DSException dSException) {
            log.error(6202);
        }
    }

    private int append(int n) throws DSException {
        return this.countColumns.getRowID(n);
    }

    @Override
    public void update(int n) {
        int n2;
        if (n == 0 && this.debug) {
            PooledRecord pooledRecord = (PooledRecord)this.SEDU;
            try {
                int n3 = this.append(this.append);
                pooledRecord.init(n3);
                if (this.cells[0].bNull) {
                    pooledRecord.putNull(1, -1);
                } else {
                    pooledRecord.putInt(1, ((DbInteger)this.cells[0]).value);
                }
                pooledRecord.update(n3);
            }
            catch (DSException dSException) {
                log.error(6208);
            }
            return;
        }
        for (n2 = 0; n2 < this.columnCount; ++n2) {
            this.tempCells[n2].set(this.cells[n2]);
        }
        this.refresh();
        this.cells[n].set(this.tempCells[n]);
        this.update();
        for (n2 = 0; n2 < this.columnCount; ++n2) {
            this.cells[n2].set(this.tempCells[n2]);
        }
    }

    @Override
    public void update(String string) {
        int n = this.bNull(string);
        this.update(n);
    }

    @Override
    public void update(DbColDesc dbColDesc) {
        if (dbColDesc.getColIndex() == -1) {
            String string = dbColDesc.getColName();
            this.update(string);
        } else {
            this.update(dbColDesc.getColIndex());
        }
    }

    @Override
    public void setPosition(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("the argument [" + n + "] is out of bound,the position must >0");
        }
        this.append = n;
    }

    @Override
    public int getPosition() {
        return this.append;
    }

    @Override
    public DbValue getCell(int n) {
        return this.cells[n];
    }

    @Override
    public DbValue getCell(DbColDesc dbColDesc) {
        if (dbColDesc.getColIndex() == -1) {
            String string = dbColDesc.getColName();
            int n = this.bNull(string);
            if (n == -1) {
                throw new ArrayIndexOutOfBoundsException("column not found [" + string + "]");
            }
            dbColDesc.setColIndex(n);
        }
        return this.getCell(dbColDesc.getColIndex());
    }

    @Override
    public DbValue getCell(String string) {
        int n = this.bNull(string);
        if (n == -1) {
            throw new ArrayIndexOutOfBoundsException("column not found [" + string + "]");
        }
        return this.getCell(n);
    }

    private int bNull(String string) {
        for (int i = 0; i < this.cells.length; ++i) {
            String string2 = this.cells[i].getColDesc().getColName();
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            return i;
        }
        log.warn(6103, new Object[]{string});
        log.debug("Current RecordModel Column is:");
        this.bNull.dump(1);
        return -1;
    }

    @Override
    public void refresh(boolean bl) {
        this.refresh();
        if (!bl && this.columnCount > 0) {
            Groupable groupable = this.getDependCursor().getRecordModel().getGroupable();
            if (groupable != null) {
                if (this.cells[0].isNull()) {
                    groupable.getValuesByRecordNumber(this);
                } else {
                    groupable.getValues(((DbInteger)this.cells[0]).value, this);
                }
            } else {
                log.warn(6104);
            }
        }
    }

    @Override
    public void refresh(int n) {
        this.refresh();
    }

    @Override
    public void refresh(String string) {
        this.refresh();
    }

    @Override
    public void refresh(DbColDesc dbColDesc) {
        this.refresh();
    }

    @Override
    public DbValueable getValue(int n) {
        return this.cells[n];
    }

    @Override
    public DbValueable getValue(String string) {
        int n = this.bNull(string);
        return this.getValue(n);
    }

    @Override
    public void refresh() {
        try {
            this.SEDU(this.append);
        }
        catch (DSException dSException) {
            log.error(6108, dSException);
        }
    }

    @Override
    public int columnCount() {
        return this.columnCount;
    }

    @Override
    public void setRecordIndex(int n) {
        this.setPosition(n);
    }

    @Override
    public JRecordModel getRecordModel() {
        return this.bNull;
    }

    @Override
    public int size() {
        return this.getRecordModel().countColumns();
    }

    @Override
    public int getRecordIndex() {
        return this.getPosition();
    }

    private void cells() throws DSException {
        PooledRecord pooledRecord = (PooledRecord)this.SEDU;
        pooledRecord.reset();
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.cells[i].bNull) {
                pooledRecord.putNull(-1);
                continue;
            }
            DataMapTool.dbValue2PooledRecord(this.dbValue2PooledRecord[i], pooledRecord, this.cells[i]);
        }
    }

    @Override
    public JDbBufferCursor getDependCursor() {
        return this.countColumns;
    }

    @Override
    public int indexOfCell(String string) {
        return this.bNull.indexOfCell(string);
    }

    @Override
    public void setRowID(int n) throws DSException {
        this.append = this.countColumns.getPosition(n);
    }

    @Override
    public int getRowID() throws DSException {
        return this.countColumns.getRowID(this.append);
    }
}

