/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.dbbuffer;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.Attribute;
import com.jinfonet.dataservice.relational.RelationMetaData;
import jet.connect.DbColDesc;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JRecordModel;
import jet.dataengine.api.dbbuffer.RecordModelInfo;

public class MetaDataTool {
    public static DbColDesc[] getCols(JRelationMetaData jRelationMetaData) throws DSException {
        int n = jRelationMetaData.getColumnCount();
        DbColDesc[] dbColDescArray = new DbColDesc[n];
        for (int i = 0; i < n; ++i) {
            JAttribute jAttribute = jRelationMetaData.getAttribute(i + 1);
            dbColDescArray[i] = MetaDataTool.createrDbColDesc(jAttribute);
        }
        return dbColDescArray;
    }

    public static DbColDesc createrDbColDesc(JAttribute jAttribute) {
        DbColDesc dbColDesc = new DbColDesc(jAttribute.getAliasName() == null ? null : jAttribute.getAliasName().toUpperCase(), Types.typeToSQLType(jAttribute.getDataType()), jAttribute.getPrecision(), jAttribute.getScale(), jAttribute.isNullable(), jAttribute.isCurrency());
        int n = jAttribute.getUseEncodingType();
        dbColDesc.setNotAutoEncode(n != 0);
        dbColDesc.setEncode(n == 1);
        dbColDesc.setConvertEncoding(jAttribute.getFromEncoding(), jAttribute.getToEncoding());
        if (dbColDesc.getSqlType() == 2003) {
            dbColDesc.setArray(true);
            dbColDesc.setSqlType(jAttribute.getBaseType());
        }
        dbColDesc.setReadOnly(jAttribute.isReadOnly());
        dbColDesc.setConstant(jAttribute.isConstant());
        dbColDesc.setIgnoreCase(!jAttribute.isCaseSensitive());
        return dbColDesc;
    }

    public static JRelationMetaData convert2RelationMetaData(RecordModelInfo recordModelInfo) {
        DbColDesc[] dbColDescArray = recordModelInfo.getColDescs();
        return MetaDataTool.ColDesc2RelationMetaData(dbColDescArray);
    }

    public static JRelationMetaData convert2RelationMetaData(JRecordModel jRecordModel) {
        DbColDesc[] dbColDescArray = jRecordModel.getColDescs();
        return MetaDataTool.ColDesc2RelationMetaData(dbColDescArray);
    }

    public static JRelationMetaData ColDesc2RelationMetaData(DbColDesc[] dbColDescArray) {
        JAttribute[] jAttributeArray = new JAttribute[dbColDescArray.length];
        for (int i = 0; i < dbColDescArray.length; ++i) {
            String string = dbColDescArray[i].getColName();
            int n = Types.sqlTypeToType(dbColDescArray[i].getSqlType());
            if (dbColDescArray[i].isArray()) {
                n = 2003;
            }
            int n2 = dbColDescArray[i].getPrecision();
            int n3 = dbColDescArray[i].getScale();
            int n4 = dbColDescArray[i].getNullable();
            int n5 = 0;
            boolean bl = dbColDescArray[i].isCurrency();
            boolean bl2 = dbColDescArray[i].isReadOnly();
            boolean bl3 = dbColDescArray[i].isGroupable() || dbColDescArray[i].isConstant() || dbColDescArray[i].isGroupLevel();
            jAttributeArray[i] = new Attribute(string, n, n2, n3, n5, n4, bl, bl2, bl3);
            jAttributeArray[i].setCaseSensitive(!dbColDescArray[i].isIgnoreCase());
            if (!dbColDescArray[i].isArray()) continue;
            jAttributeArray[i].setBaseType(Types.sqlTypeToType(dbColDescArray[i].getSqlType()));
        }
        return new RelationMetaData("noName", jAttributeArray);
    }
}

