/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.dbbuffer;

import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.dbbuffer.JRecordModel;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.util.DSLog;
import jet.dataengine8.dbbuffer.RecordModel;
import jet.util.DbValueable;

public class RecordImpl
implements JRecord {
    static DSLog log = DSLog.getDSLog(RecordImpl.class.getName());
    protected final DbValue[] cells;
    private final DbValue[] SEDU;
    private RecordModel debug;
    protected int recordIndex = -1;

    public RecordImpl(DbColDesc[] dbColDescArray) {
        int n;
        this.debug = new RecordModel(new RecordModelInfo(dbColDescArray));
        this.cells = new DbValue[dbColDescArray.length];
        for (n = 0; n < dbColDescArray.length; ++n) {
            this.cells[n] = DbValue.makeDbValue(dbColDescArray[n]);
        }
        this.SEDU = new DbValue[dbColDescArray.length];
        for (n = 0; n < dbColDescArray.length; ++n) {
            this.SEDU[n] = DbValue.makeDbValue(dbColDescArray[n]);
        }
    }

    public RecordImpl(RecordModelInfo recordModelInfo) {
        int n;
        this.debug = new RecordModel(recordModelInfo);
        DbColDesc[] dbColDescArray = recordModelInfo.getColDescs();
        this.cells = new DbValue[dbColDescArray.length];
        for (n = 0; n < dbColDescArray.length; ++n) {
            this.cells[n] = DbValue.makeDbValue(dbColDescArray[n]);
        }
        this.SEDU = new DbValue[dbColDescArray.length];
        for (n = 0; n < dbColDescArray.length; ++n) {
            this.SEDU[n] = DbValue.makeDbValue(dbColDescArray[n]);
        }
    }

    public RecordImpl(RecordModel recordModel) {
        int n;
        this.debug = recordModel;
        DbColDesc[] dbColDescArray = recordModel.getColDescs();
        this.cells = new DbValue[dbColDescArray.length];
        for (n = 0; n < dbColDescArray.length; ++n) {
            this.cells[n] = DbValue.makeDbValue(dbColDescArray[n]);
        }
        this.SEDU = new DbValue[dbColDescArray.length];
        for (n = 0; n < dbColDescArray.length; ++n) {
            this.SEDU[n] = DbValue.makeDbValue(dbColDescArray[n]);
        }
    }

    @Override
    public void setPosition(int n) {
        this.setRecordIndex(n);
    }

    @Override
    public void setRecordIndex(int n) {
        this.recordIndex = n;
    }

    @Override
    public int getPosition() {
        return this.recordIndex;
    }

    @Override
    public DbValue getCell(int n) {
        return this.cells[n];
    }

    @Override
    public DbValue getCell(DbColDesc dbColDesc) {
        if (dbColDesc.getColIndex() == -1) {
            String string = dbColDesc.getColName();
            dbColDesc.setColIndex(this.debug.indexOfCell(string));
        }
        return this.getCell(dbColDesc.getColIndex());
    }

    @Override
    public DbValue[] getValueArray() {
        return this.cells;
    }

    @Override
    public DbValue getCell(String string) {
        int n = this.$assertionsDisabled(string);
        return this.getCell(n);
    }

    private int $assertionsDisabled(String string) {
        for (int i = 0; i < this.cells.length; ++i) {
            String string2 = this.cells[i].getColDesc().getColName();
            if (string2 == null && string == null) {
                return 0;
            }
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            return i;
        }
        log.warn(6107, new Object[]{string});
        log.debug("Current RecordModel Column is:");
        return -1;
    }

    @Override
    public int columnCount() {
        return this.cells.length;
    }

    @Override
    public JRecordModel getRecordModel() {
        return this.debug;
    }

    @Override
    public JDbBufferCursor getDependCursor() {
        assert (false);
        return null;
    }

    @Override
    public void refresh() {
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].set(this.SEDU[i]);
        }
    }

    @Override
    public void refresh(boolean bl) {
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].set(this.SEDU[i]);
        }
    }

    @Override
    public void refresh(int n) {
        this.cells[n].set(this.SEDU[n]);
    }

    @Override
    public void refresh(String string) {
        int n = this.$assertionsDisabled(string);
        this.refresh(n);
    }

    @Override
    public void refresh(DbColDesc dbColDesc) {
        if (dbColDesc.getColIndex() == -1) {
            String string = dbColDesc.getColName();
            this.refresh(string);
        }
        this.refresh(dbColDesc.getColIndex());
    }

    @Override
    public void update() {
        for (int i = 0; i < this.cells.length; ++i) {
            this.SEDU[i].set(this.cells[i]);
        }
    }

    @Override
    public void update(int n) {
        this.SEDU[n].set(this.cells[n]);
    }

    @Override
    public void update(String string) {
        int n = this.$assertionsDisabled(string);
        this.update(n);
    }

    @Override
    public void update(DbColDesc dbColDesc) {
        if (dbColDesc.getColIndex() == -1) {
            String string = dbColDesc.getColName();
            this.update(string);
        } else {
            this.update(dbColDesc.getColIndex());
        }
    }

    @Override
    public int getRecordIndex() {
        return this.recordIndex;
    }

    @Override
    public int size() {
        return this.columnCount();
    }

    @Override
    public DbValueable getValue(int n) {
        return this.getCell(n);
    }

    @Override
    public DbValueable getValue(String string) {
        return this.getCell(string);
    }

    @Override
    public int indexOfCell(String string) {
        return this.debug.indexOfCell(string);
    }

    @Override
    public void setRowID(int n) throws DSException {
        assert (false);
    }

    @Override
    public int getRowID() throws DSException {
        assert (false);
        return 0;
    }
}

