/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.dbbuffer;

import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import java.math.BigInteger;
import jet.connect.DbColDesc;

public class RecordTool {
    public static final int BYTE = 1;
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int SHORT = 2;
    public static final int INT = 4;
    public static final int LONG = 8;
    public static final int FLOAT = 4;
    public static final int DOUBLE = 8;
    public static final int TIME = 8;
    public static final int TIMESTAMP = 12;
    private static final int SEDU = 255;

    public static int getRecordLen(DbColDesc[] dbColDescArray) {
        int n = 0;
        block15: for (int i = 0; i < dbColDescArray.length; ++i) {
            if (dbColDescArray[i].isGroupable() || dbColDescArray[i].isConstant() || dbColDescArray[i].isGroupLevel()) continue;
            if (dbColDescArray[i].isArray()) {
                n += 8;
                continue;
            }
            ++n;
            switch (dbColDescArray[i].getSqlType()) {
                case -6: {
                    ++n;
                    continue block15;
                }
                case 5: {
                    n += 2;
                    continue block15;
                }
                case 4: {
                    n += 4;
                    continue block15;
                }
                case -5: {
                    n += 8;
                    continue block15;
                }
                case 7: {
                    n += 8;
                    continue block15;
                }
                case 2: 
                case 3: {
                    dbColDescArray[i].bigDecimalLength = RecordTool.decimalNeedBytes(dbColDescArray[i].getPrecision() + dbColDescArray[i].getScale());
                    n += dbColDescArray[i].bigDecimalLength;
                    continue block15;
                }
                case 6: 
                case 8: {
                    n += 8;
                    continue block15;
                }
                case -7: {
                    n += 4;
                    continue block15;
                }
                case 91: {
                    n += 8;
                    continue block15;
                }
                case 92: {
                    n += 8;
                    continue block15;
                }
                case 93: {
                    n += 12;
                    continue block15;
                }
                case -3: 
                case -2: 
                case 1: 
                case 12: {
                    n += 4 + dbColDescArray[i].getPrecision() * 1;
                    continue block15;
                }
                case -4: 
                case -1: 
                case 2004: 
                case 2005: {
                    n += 8;
                    continue block15;
                }
                default: {
                    assert (false) : "unSupport type : " + dbColDescArray[i].getSqlType() + " of the column " + dbColDescArray[i].getColName();
                    continue block15;
                }
            }
        }
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public static int getRecordLen(JAttribute[] jAttributeArray) {
        int n = 0;
        block16: for (int i = 0; i < jAttributeArray.length; ++i) {
            ++n;
            switch (jAttributeArray[i].getDataType()) {
                case -6: {
                    ++n;
                    continue block16;
                }
                case 5: {
                    n += 2;
                    continue block16;
                }
                case 4: {
                    n += 4;
                    continue block16;
                }
                case -5: {
                    n += 8;
                    continue block16;
                }
                case 6: {
                    n += 8;
                    continue block16;
                }
                case 3: {
                    n += RecordTool.decimalNeedBytes(jAttributeArray[i].getPrecision() + jAttributeArray[i].getScale());
                    continue block16;
                }
                case 8: {
                    n += 8;
                    continue block16;
                }
                case -7: {
                    n += 4;
                    continue block16;
                }
                case 91: {
                    n += 8;
                    continue block16;
                }
                case 92: {
                    n += 8;
                    continue block16;
                }
                case 93: {
                    n += 12;
                    continue block16;
                }
                case -2: 
                case 12: {
                    n += 4 + jAttributeArray[i].getPrecision() * 1;
                    continue block16;
                }
                case 2004: 
                case 2005: {
                    n += 8;
                    continue block16;
                }
                case 2003: {
                    n += 8;
                }
                default: {
                    assert (false) : "unSupport type : " + jAttributeArray[i].getDataType() + " of the column " + jAttributeArray[i].getAttributeName();
                    continue block16;
                }
            }
        }
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public static int decimalNeedBytes(int n) {
        if (n > 255) {
            n = 255;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("9");
        }
        if (stringBuffer.length() < 1) {
            return 10;
        }
        BigInteger bigInteger = new BigInteger(stringBuffer.toString());
        byte[] byArray = bigInteger.toByteArray();
        return byArray.length;
    }
}

