/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.core;

import java.util.BitSet;
import jet.dataengine8.olap.core.BitKey;

abstract class AbstractBitKey
implements BitKey {
    private static final long serialVersionUID = 62019791022L;
    protected static final int ChunkBitCount = 6;
    protected static final int Mask = 63;
    protected static final long WORD_MASK = -1L;
    static final byte[] bitPositionTable = new byte[]{-1, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};

    AbstractBitKey() {
    }

    protected static long bit(int n) {
        return 1L << (n & 0x3F);
    }

    protected static int chunkPos(int n) {
        return n >> 6;
    }

    protected static int chunkCount(int n) {
        return n + 63 >> 6;
    }

    protected static int bitCount(long l) {
        l -= l >>> 1 & 0x5555555555555555L;
        l = (l & 0x3333333333333333L) + (l >>> 2 & 0x3333333333333333L);
        l = l + (l >>> 4) & 0xF0F0F0F0F0F0F0FL;
        l += l >>> 8;
        l += l >>> 16;
        l += l >>> 32;
        return (int)l & 0x7F;
    }

    @Override
    public final void set(int n, boolean bl) {
        if (bl) {
            this.set(n);
        } else {
            this.clear(n);
        }
    }

    protected static void copyFromByte(BitSet bitSet, int n, byte by) {
        if (by == 0) {
            return;
        }
        if ((by & 1) != 0) {
            bitSet.set(n, true);
        }
        ++n;
        if ((by & 2) != 0) {
            bitSet.set(n, true);
        }
        ++n;
        if ((by & 4) != 0) {
            bitSet.set(n, true);
        }
        ++n;
        if ((by & 8) != 0) {
            bitSet.set(n, true);
        }
        ++n;
        if ((by & 0x10) != 0) {
            bitSet.set(n, true);
        }
        ++n;
        if ((by & 0x20) != 0) {
            bitSet.set(n, true);
        }
        ++n;
        if ((by & 0x40) != 0) {
            bitSet.set(n, true);
        }
        ++n;
        if ((by & 0x80) != 0) {
            bitSet.set(n, true);
        }
    }

    protected static void copyFromLong(BitSet bitSet, int n, long l) {
        while (l != 0L) {
            AbstractBitKey.copyFromByte(bitSet, n, (byte)(l & 0xFFL));
            l >>>= 8;
            n += 8;
        }
    }

    protected IllegalArgumentException createException(BitKey bitKey) {
        String string = bitKey == null ? "Null BitKey" : "Bad BitKey type: " + bitKey.getClass().getName();
        return new IllegalArgumentException(string);
    }

    static int compareUnsignedArrays(long[] lArray, long[] lArray2) {
        int n = lArray.length - 1;
        int n2 = lArray2.length - 1;
        if (n > n2) {
            do {
                if (lArray[n] == 0L) continue;
                return 1;
            } while (--n > n2);
        } else if (n2 > n) {
            do {
                if (lArray2[n2] == 0L) continue;
                return -1;
            } while (--n2 > n);
        }
        assert (n == n2);
        while (n >= 0) {
            int n3 = AbstractBitKey.compareUnsigned(lArray[n], lArray2[n]);
            if (n3 != 0) {
                return n3;
            }
            --n;
        }
        return 0;
    }

    static int compareUnsigned(long l, long l2) {
        if (l == l2) {
            return 0;
        }
        if (l < 0L == l2 < 0L) {
            return l < l2 ? -1 : 1;
        }
        return l < l2 ? 1 : -1;
    }
}

