/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.core;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.Iterator;
import jet.dataengine8.olap.core.AbstractBitKey;
import jet.dataengine8.olap.core.BitKey;
import jet.dataengine8.olap.core.MiddleBitKey;
import jet.dataengine8.olap.core.SmallBitKey;

public class BigBitKey
extends AbstractBitKey {
    private static final long serialVersionUID = 62019791023L;
    protected long[] bits;

    public BigBitKey() {
    }

    BigBitKey(int n) {
        this.bits = new long[BigBitKey.chunkCount(n + 1)];
    }

    BigBitKey(BigBitKey bigBitKey) {
        this.bits = (long[])bigBitKey.bits.clone();
    }

    private int size() {
        return this.bits.length;
    }

    int effectiveSize() {
        int n;
        for (n = this.bits.length; n > 0 && this.bits[n - 1] == 0L; --n) {
        }
        return n;
    }

    @Override
    public void set(int n) {
        int n2 = BigBitKey.chunkPos(n);
        this.bits[n2] = this.bits[n2] | BigBitKey.bit(n);
    }

    @Override
    public boolean get(int n) {
        return (this.bits[BigBitKey.chunkPos(n)] & BigBitKey.bit(n)) != 0L;
    }

    @Override
    public void clear(int n) {
        int n2 = BigBitKey.chunkPos(n);
        this.bits[n2] = this.bits[n2] & (BigBitKey.bit(n) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = 0L;
        }
    }

    @Override
    public int cardinality() {
        int n = 0;
        for (int i = 0; i < this.bits.length; ++i) {
            n += BigBitKey.bitCount(this.bits[i]);
        }
        return n;
    }

    void or(long l) {
        this.bits[0] = this.bits[0] | l;
    }

    void or(long l, long l2) {
        this.bits[0] = this.bits[0] | l;
        this.bits[1] = this.bits[1] | l2;
    }

    void or(long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] | lArray[i];
        }
    }

    void orNot(long l) {
        this.bits[0] = this.bits[0] ^ l;
    }

    void orNot(long l, long l2) {
        this.bits[0] = this.bits[0] ^ l;
        this.bits[1] = this.bits[1] ^ l2;
    }

    private void SEDU(long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] ^ lArray[i];
        }
    }

    private void and(long[] lArray) {
        int n;
        int n2 = Math.min(lArray.length, this.bits.length);
        for (n = 0; n < n2; ++n) {
            int n3 = n;
            this.bits[n3] = this.bits[n3] & lArray[n];
        }
        for (n = lArray.length; n < this.bits.length; ++n) {
            this.bits[n] = 0L;
        }
    }

    @Override
    public BitKey or(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            BigBitKey bigBitKey = (BigBitKey)this.copy();
            bigBitKey.or(smallBitKey.bits);
            return bigBitKey;
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            BigBitKey bigBitKey = (BigBitKey)this.copy();
            bigBitKey.or(middleBitKey.bits0, middleBitKey.bits1);
            return bigBitKey;
        }
        if (bitKey instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            if (bigBitKey.size() > this.size()) {
                BigBitKey bigBitKey2 = (BigBitKey)bigBitKey.copy();
                bigBitKey2.or(this.bits);
                return bigBitKey2;
            }
            BigBitKey bigBitKey3 = (BigBitKey)this.copy();
            bigBitKey3.or(bigBitKey.bits);
            return bigBitKey3;
        }
        throw this.createException(bitKey);
    }

    @Override
    public BitKey orNot(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            BigBitKey bigBitKey = (BigBitKey)this.copy();
            bigBitKey.orNot(smallBitKey.bits);
            return bigBitKey;
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            BigBitKey bigBitKey = (BigBitKey)this.copy();
            bigBitKey.orNot(middleBitKey.bits0, middleBitKey.bits1);
            return bigBitKey;
        }
        if (bitKey instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            if (bigBitKey.size() > this.size()) {
                BigBitKey bigBitKey2 = (BigBitKey)bigBitKey.copy();
                bigBitKey2.SEDU(this.bits);
                return bigBitKey2;
            }
            BigBitKey bigBitKey3 = (BigBitKey)this.copy();
            bigBitKey3.SEDU(bigBitKey.bits);
            return bigBitKey3;
        }
        throw this.createException(bitKey);
    }

    @Override
    public BitKey and(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey.copy();
            smallBitKey.and(this.bits[0]);
            return smallBitKey;
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey.copy();
            middleBitKey.and(this.bits[0], this.bits[1]);
            return middleBitKey;
        }
        if (bitKey instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            if (bigBitKey.size() < this.size()) {
                BigBitKey bigBitKey2 = (BigBitKey)bigBitKey.copy();
                bigBitKey2.and(this.bits);
                return bigBitKey2;
            }
            BigBitKey bigBitKey3 = (BigBitKey)this.copy();
            bigBitKey3.and(bigBitKey.bits);
            return bigBitKey3;
        }
        throw this.createException(bitKey);
    }

    @Override
    public BitKey andNot(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            BigBitKey bigBitKey = (BigBitKey)this.copy();
            bigBitKey.bits(smallBitKey.bits);
            return bigBitKey;
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            BigBitKey bigBitKey = (BigBitKey)this.copy();
            bigBitKey.bit(middleBitKey.bits0, middleBitKey.bits1);
            return bigBitKey;
        }
        if (bitKey instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            BigBitKey bigBitKey2 = (BigBitKey)this.copy();
            bigBitKey2.append(bigBitKey.bits);
            return bigBitKey2;
        }
        throw this.createException(bitKey);
    }

    private void append(long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & (lArray[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    private void bit(long l, long l2) {
        this.bits[0] = this.bits[0] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        this.bits[1] = this.bits[1] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void bits(long l) {
        this.bits[0] = this.bits[0] & (l ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public boolean isSuperSetOf(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            return (this.bits[0] | smallBitKey.bits) == this.bits[0];
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            return (this.bits[0] | middleBitKey.bits0) == this.bits[0] && (this.bits[1] | middleBitKey.bits1) == this.bits[1];
        }
        if (bitKey instanceof BigBitKey) {
            int n;
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            int n2 = Math.min(this.bits.length, bigBitKey.bits.length);
            for (n = 0; n < n2; ++n) {
                if ((this.bits[n] | bigBitKey.bits[n]) == this.bits[n]) continue;
                return false;
            }
            if (bigBitKey.bits.length > this.bits.length) {
                for (n = n2; n < bigBitKey.bits.length; ++n) {
                    if (bigBitKey.bits[n] == 0L) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            return (this.bits[0] & smallBitKey.bits) != 0L;
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            return (this.bits[0] & middleBitKey.bits0) != 0L || (this.bits[1] & middleBitKey.bits1) != 0L;
        }
        if (bitKey instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            int n = Math.min(this.bits.length, bigBitKey.bits.length);
            for (int i = 0; i < n; ++i) {
                if ((this.bits[i] & bigBitKey.bits[i]) == 0L) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public BitSet toBitSet() {
        BitSet bitSet = new BitSet(64);
        int n = 0;
        for (int i = 0; i < this.bits.length; ++i) {
            BigBitKey.copyFromLong(bitSet, n, this.bits[i]);
            n += 64;
        }
        return bitSet;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            long[] varBits;
            int pos;
            int index;
            {
                this.varBits = (long[])BigBitKey.this.bits.clone();
                this.pos = -1;
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                long l;
                if (this.index >= this.varBits.length) {
                    return false;
                }
                if (this.pos < 0) {
                    while (this.varBits[this.index] == 0L) {
                        ++this.index;
                        if (this.index < this.varBits.length) continue;
                        return false;
                    }
                    this.pos = 64 * this.index - 1;
                }
                if ((l = this.varBits[this.index]) == 0L) {
                    while (this.varBits[this.index] == 0L) {
                        ++this.index;
                        if (this.index < this.varBits.length) continue;
                        return false;
                    }
                    this.pos = 64 * this.index - 1;
                    l = this.varBits[this.index];
                }
                if (l != 0L) {
                    if (l == Long.MIN_VALUE) {
                        this.pos = 64 * this.index + 63;
                        this.varBits[this.index] = 0L;
                        return true;
                    }
                    long l2 = l & -l;
                    int n = 0;
                    while (l2 >= 256L) {
                        l2 >>= 8;
                        n += 8;
                    }
                    int n2 = AbstractBitKey.bitPositionTable[(int)l2];
                    n2 = n2 >= 0 ? (n2 += n) : n;
                    this.pos = this.pos < 0 ? n2 : (n2 == 0 ? ++this.pos : (this.pos += n2 + 1));
                    this.varBits[this.index] = this.varBits[this.index] >>> n2 + 1;
                    return true;
                }
                return false;
            }

            public Integer next() {
                return this.pos;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    @Override
    public int nextSetBit(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        int n2 = BigBitKey.chunkPos(n);
        if (n2 >= this.bits.length) {
            return -1;
        }
        long l = this.bits[n2] & -1L << n;
        while (l == 0L) {
            if (++n2 == this.bits.length) {
                return -1;
            }
            l = this.bits[n2];
        }
        return n2 * 64 + Long.numberOfTrailingZeros(l);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)object;
            if (this.bits[0] != smallBitKey.bits) {
                return false;
            }
            for (int i = 1; i < this.bits.length; ++i) {
                if (this.bits[i] == 0L) continue;
                return false;
            }
            return true;
        }
        if (object instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)object;
            if (this.bits[0] != middleBitKey.bits0) {
                return false;
            }
            if (this.bits[1] != middleBitKey.bits1) {
                return false;
            }
            for (int i = 2; i < this.bits.length; ++i) {
                if (this.bits[i] == 0L) continue;
                return false;
            }
            return true;
        }
        if (object instanceof BigBitKey) {
            int n;
            BigBitKey bigBitKey = (BigBitKey)object;
            int n2 = Math.min(this.bits.length, bigBitKey.bits.length);
            for (n = 0; n < n2; ++n) {
                if (this.bits[n] == bigBitKey.bits[n]) continue;
                return false;
            }
            if (this.bits.length > bigBitKey.bits.length) {
                for (n = n2; n < this.bits.length; ++n) {
                    if (this.bits[n] == 0L) continue;
                    return false;
                }
            } else if (bigBitKey.bits.length > this.bits.length) {
                for (n = n2; n < bigBitKey.bits.length; ++n) {
                    if (bigBitKey.bits[n] == 0L) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        long l = 1234L;
        int n = this.bits.length;
        while (--n >= 0) {
            l ^= this.bits[n] * (long)(n + 1);
        }
        return (int)(l >> 32 ^ l);
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("0x");
        for (int i = n = this.bits.length * 64 - 1; i >= 0; --i) {
            stringBuilder.append(this.get(i) ? (char)'1' : '0');
        }
        return stringBuilder.toString();
    }

    @Override
    public BitKey copy() {
        return new BigBitKey(this);
    }

    @Override
    public BitKey emptyCopy() {
        return new BigBitKey(this.bits.length << 6);
    }

    @Override
    public boolean isEmpty() {
        for (long l : this.bits) {
            if (l == 0L) continue;
            return false;
        }
        return true;
    }

    public int compareTo(BitKey bitKey) {
        if (bitKey instanceof BigBitKey) {
            return BigBitKey.compareUnsignedArrays(this.bits, ((BigBitKey)bitKey).bits);
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            return -middleBitKey.compareToBig(this);
        }
        SmallBitKey smallBitKey = (SmallBitKey)bitKey;
        return -smallBitKey.compareToBig(this);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.bits = (long[])objectInput.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.bits);
    }
}

