/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.core;

import java.io.Externalizable;
import java.util.BitSet;
import java.util.Iterator;
import jet.dataengine8.olap.core.AbstractBitKey;
import jet.dataengine8.olap.core.BigBitKey;
import jet.dataengine8.olap.core.MiddleBitKey;
import jet.dataengine8.olap.core.SmallBitKey;

public interface BitKey
extends Externalizable,
Comparable,
Iterable {
    public static final BitKey EMPTY = Factory.makeBitKey(0);

    public void set(int var1, boolean var2);

    public void set(int var1);

    public boolean get(int var1);

    public void clear(int var1);

    public void clear();

    public boolean isSuperSetOf(BitKey var1);

    public BitKey or(BitKey var1);

    public BitKey orNot(BitKey var1);

    public BitKey and(BitKey var1);

    public BitKey andNot(BitKey var1);

    public BitKey copy();

    public BitKey emptyCopy();

    public boolean isEmpty();

    public boolean intersects(BitKey var1);

    public BitSet toBitSet();

    public Iterator iterator();

    public int nextSetBit(int var1);

    public int cardinality();

    public static abstract class Factory {
        public static BitKey makeBitKey(int n) {
            return Factory.makeBitKey(n, false);
        }

        public static BitKey makeBitKey(int n, boolean bl) {
            if (n < 0) {
                String string = "Negative size \"" + n + "\" not allowed";
                throw new IllegalArgumentException(string);
            }
            AbstractBitKey abstractBitKey = n < 64 ? new SmallBitKey() : (n < 128 ? new MiddleBitKey() : new BigBitKey(n));
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    abstractBitKey.set(i, bl);
                }
            }
            return abstractBitKey;
        }

        public static BitKey makeBitKey(BitSet bitSet) {
            BitKey bitKey = Factory.makeBitKey(bitSet.length());
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                bitKey.set(n);
                n = bitSet.nextSetBit(n + 1);
            }
            return bitKey;
        }
    }
}

