/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import jet.dataengine8.olap.core.BitKey;

public class BitKeyArray
implements Externalizable {
    private static final long serialVersionUID = 62019791021L;
    ArrayList keys = new ArrayList();
    int size = 0;

    public void append(int n, BitKey bitKey) {
        ((BitKey[])this.keys.get((int)(n >> 11)))[n & 0x7FF] = bitKey;
    }

    public void increaseCapacity() {
        this.keys.add(new BitKey[2048]);
    }

    public ArrayList getKeys() {
        return this.keys;
    }

    public BitKey getKey(int n) {
        return ((BitKey[])this.keys.get(n >> 11))[n & 0x7FF];
    }

    public void clearValueBlock(int n) {
        this.keys.set(n, null);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.size);
    }

    public void writeData(ObjectOutput objectOutput, int n, int n2) throws IOException {
        for (int i = n; i < n + n2; ++i) {
            objectOutput.writeObject(this.getKey(i));
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.size = objectInput.readInt();
    }

    public void readData(ObjectInput objectInput, int n, int n2) throws IOException, ClassNotFoundException {
        int n3;
        int n4 = n >> 11;
        int n5 = n + n2 >> 11;
        for (n3 = n4; n3 <= n5; ++n3) {
            if (n3 >= this.keys.size()) {
                this.increaseCapacity();
            }
            if (this.keys.get(n3) != null) continue;
            this.keys.set(n3, new BitKey[2048]);
        }
        for (n3 = n; n3 < n + n2; ++n3) {
            this.append(n3, (BitKey)objectInput.readObject());
        }
    }
}

