/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.core;

import java.util.List;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.AggregationKey;
import jet.dataengine.api.schema.olap.JCubeViewResultSet;
import jet.dataengine.api.schema.olap.metadata.JDimension;
import jet.dataengine.api.schema.olap.query.querycoremodel.CubeView;
import jet.dataengine.util.DSLog;
import jet.dataengine8.olap.core.BitKey;
import jet.dataengine8.olap.core.Cuboid;
import jet.dataengine8.olap.core.DimensionInstance;
import jet.dataengine8.olap.core.DimensionMember;
import jet.dataengine8.olap.core.ICubeViewResult;
import jet.formula.aggarray.BaseAggArray;

public class CubeViewResultSet
implements ICubeViewResult,
JCubeViewResultSet {
    private DSLog SEDU = DSLog.getDSLog(this.getClass().getName());
    private CubeView and;
    private Cuboid append;
    private int debug;
    private DimensionInstance[] equals;
    private DimensionInstance[] get;
    private BaseAggArray[] getAggFunctionType;

    public CubeViewResultSet(CubeView cubeView, Cuboid cuboid) {
        this.SEDU.debug("begin create CubeViewResultSet()" + this.hashCode());
        this.and = cubeView;
        this.append = cuboid;
        this.debug = 0;
        DimensionInstance[] dimensionInstanceArray = this.append.getDimensionInstances();
        List list = cubeView.getRowEdgeMetaData();
        this.equals = this.SEDU(list, dimensionInstanceArray);
        List list2 = cubeView.getColumnEdgeMetaData();
        this.get = this.SEDU(list2, dimensionInstanceArray);
        List list3 = this.and.getMeasureView();
        this.getAggFunctionType = new BaseAggArray[list3.size()];
        int n = list3.size();
        for (int i = 0; i < n; ++i) {
            AggregationKey aggregationKey = (AggregationKey)list3.get(i);
            if (aggregationKey.getAggFunctionType() == 1) {
                aggregationKey = new AggregationKey(1, "");
            }
            this.getAggFunctionType[i] = this.append.getCells().getBaseAggArray(aggregationKey);
        }
        this.SEDU.debug("end create CubeViewResultSet()" + this.hashCode());
    }

    private DimensionInstance[] SEDU(List list, DimensionInstance[] dimensionInstanceArray) {
        DimensionInstance[] dimensionInstanceArray2 = new DimensionInstance[list.size()];
        block0: for (int i = 0; i < list.size(); ++i) {
            JDimension jDimension = (JDimension)list.get(i);
            for (int j = 0; j < dimensionInstanceArray.length; ++j) {
                if (!jDimension.getName().equals(dimensionInstanceArray[j].getName())) continue;
                dimensionInstanceArray2[i] = dimensionInstanceArray[j];
                continue block0;
            }
        }
        return dimensionInstanceArray2;
    }

    public void close() {
        this.and = null;
        this.append = null;
        this.equals = null;
        this.get = null;
        this.SEDU.debug("Close CubeViewResultSet " + this.hashCode());
    }

    @Override
    public Object getValue(int n) throws DSException {
        return this.getAggFunctionType[n].getValue(this.debug);
    }

    @Override
    public Object getDimensionValueOnRow(int n) throws DSException {
        BitKey bitKey = this.append.getBitKeyArray().getKey(this.debug).and(this.equals[n].getMasks());
        DimensionMember dimensionMember = (DimensionMember)this.equals[n].getMemberMap().get(bitKey);
        return dimensionMember.getValue();
    }

    @Override
    public Object getDimensionValueOnColumn(int n) throws DSException {
        BitKey bitKey = this.append.getBitKeyArray().getKey(this.debug).and(this.get[n].getMasks());
        DimensionMember dimensionMember = (DimensionMember)this.get[n].getMemberMap().get(bitKey);
        return dimensionMember.getValue();
    }

    public CubeView getCubeView() {
        return this.and;
    }

    @Override
    public int getSize() {
        return this.append.getCells().size();
    }

    @Override
    public void setPosition(int n) throws DSException {
        this.debug = n;
    }

    @Override
    public boolean available() {
        return true;
    }
}

