/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.core;

import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.relational.Attribute;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.dataengine8.olap.core.BitKey;
import jet.dataengine8.olap.core.NullObject;
import jet.dataengine8.util.JBoolean;

public class DimensionMember
implements Comparable,
Externalizable {
    private static final long serialVersionUID = 62019791032L;
    private BitKey SEDU;
    private Object append;
    private Attribute booleanValue;
    private boolean byteValue = false;
    protected Object compareValue = null;

    public DimensionMember() {
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.booleanValue == null ? 0 : this.booleanValue.hashCode());
        n2 = 31 * n2 + (this.compareValue == null ? 0 : this.compareValue.hashCode());
        n2 = 31 * n2 + (this.SEDU == null ? 0 : this.SEDU.hashCode());
        n2 = 31 * n2 + (this.append == null ? 0 : this.append.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DimensionMember dimensionMember = (DimensionMember)object;
        return this.compareTo(dimensionMember) == 0;
    }

    public DimensionMember(BitKey bitKey) {
        this.SEDU = bitKey;
        this.append = new Object();
    }

    public DimensionMember(BitKey bitKey, Object object, JAttribute jAttribute) {
        this.SEDU = bitKey;
        this.append = object;
        this.booleanValue = (Attribute)jAttribute;
    }

    public DimensionMember(BitKey bitKey, Object object, JAttribute jAttribute, boolean bl) {
        this.SEDU = bitKey;
        this.append = object;
        this.booleanValue = (Attribute)jAttribute;
        this.byteValue = bl;
    }

    public BitKey getKey() {
        return this.SEDU;
    }

    public Object getValue() {
        return this.append;
    }

    public DbValue getDbValue() {
        DbColDesc dbColDesc = new DbColDesc(this.booleanValue.getAliasName(), this.booleanValue.getDataType(), this.booleanValue.getPrecision(), this.booleanValue.getScale(), this.booleanValue.isNullable(), this.booleanValue.isCurrency());
        DbValue dbValue = DbValue.makeDbValue(dbColDesc);
        if (!(this.append instanceof NullObject)) {
            dbValue.setValue(this.append.toString());
        }
        return dbValue;
    }

    public void setValue(Object object) {
        if (object instanceof JinfonetDate) {
            JinfonetDate jinfonetDate = (JinfonetDate)object;
            Date date = new Date(jinfonetDate.getTime());
            this.append = date;
        } else if (object instanceof JinfonetTime) {
            Time time2 = new Time(((JinfonetTime)object).getTime());
            this.append = time2;
        } else if (object instanceof JinfonetTimeStamp) {
            Timestamp timestamp = new Timestamp(((JinfonetTimeStamp)object).getTime());
            this.append = timestamp;
        } else if (object instanceof JBoolean) {
            Boolean bl = ((JBoolean)object).booleanValue();
            this.append = bl;
        } else {
            this.append = object;
        }
    }

    public JAttribute getAttribute() {
        return this.booleanValue;
    }

    public void setAttribute(JAttribute jAttribute) {
        this.booleanValue = (Attribute)jAttribute;
    }

    public boolean isMeasureMember() {
        return this.byteValue;
    }

    public DimensionMember copyWithoutCompareValue() {
        DimensionMember dimensionMember = new DimensionMember(this.SEDU, this.append, this.booleanValue, this.byteValue);
        return dimensionMember;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Key(").append(this.SEDU).append(") [");
        stringBuffer.append(this.booleanValue.toString()).append("]");
        return stringBuffer.toString();
    }

    public int compareTo(DimensionMember dimensionMember) {
        if (this.append instanceof NullObject) {
            if (dimensionMember.append instanceof NullObject) {
                return 0;
            }
            return -1;
        }
        if (dimensionMember.append instanceof NullObject) {
            return 1;
        }
        if (this.booleanValue == null) {
            if (dimensionMember.booleanValue == null) {
                return 0;
            }
            return -1;
        }
        if (dimensionMember.booleanValue == null) {
            return 1;
        }
        int n = this.booleanValue.getDataType();
        switch (n) {
            case -7: {
                Boolean bl = (Boolean)this.append;
                Boolean bl2 = (Boolean)dimensionMember.append;
                if (bl != bl2) {
                    if (!bl.booleanValue()) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
            case -6: {
                Byte by = (Byte)this.append;
                Byte by2 = (Byte)dimensionMember.append;
                if (by > by2) {
                    return 1;
                }
                if (by < by2) {
                    return -1;
                }
                return 0;
            }
            case 5: {
                Short s = (Short)this.append;
                Short s2 = (Short)dimensionMember.append;
                if (s > s2) {
                    return 1;
                }
                if (s < s2) {
                    return -1;
                }
                return 0;
            }
            case 4: {
                Integer n2 = (Integer)this.append;
                Integer n3 = (Integer)dimensionMember.append;
                if (n2 > n3) {
                    return 1;
                }
                if (n2 < n3) {
                    return -1;
                }
                return 0;
            }
            case -5: {
                Long l = (Long)this.append;
                Long l2 = (Long)dimensionMember.append;
                if (l > l2) {
                    return 1;
                }
                if (l < l2) {
                    return -1;
                }
                return 0;
            }
            case 6: {
                Float f = (Float)this.append;
                Float f2 = (Float)dimensionMember.append;
                if (f.floatValue() > f2.floatValue()) {
                    return 1;
                }
                if (f.floatValue() < f2.floatValue()) {
                    return -1;
                }
                return 0;
            }
            case 8: {
                Double d = (Double)this.append;
                Double d2 = (Double)dimensionMember.append;
                if (d > d2) {
                    return 1;
                }
                if (d < d2) {
                    return -1;
                }
                return 0;
            }
            case 93: {
                Timestamp timestamp = (Timestamp)this.append;
                Timestamp timestamp2 = (Timestamp)dimensionMember.append;
                return timestamp.compareTo(timestamp2);
            }
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)this.append;
                BigDecimal bigDecimal2 = (BigDecimal)dimensionMember.append;
                return bigDecimal.compareTo(bigDecimal2);
            }
            case 12: {
                String string = (String)this.append;
                String string2 = (String)dimensionMember.append;
                return string.compareTo(string2);
            }
            case 91: {
                Date date = (Date)this.append;
                Date date2 = (Date)dimensionMember.append;
                return date.compareTo(date2);
            }
            case 92: {
                Time time2 = (Time)this.append;
                Time time3 = (Time)dimensionMember.append;
                return time2.compareTo(time3);
            }
        }
        throw new UnsupportedOperationException();
    }

    public void changeKey(BitKey bitKey) {
        this.SEDU = bitKey;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.SEDU = (BitKey)objectInput.readObject();
        this.booleanValue = (Attribute)objectInput.readObject();
        boolean bl = objectInput.readBoolean();
        if (bl) {
            this.append = objectInput.readObject();
        } else {
            int n = this.booleanValue.getDataType();
            switch (n) {
                case -7: {
                    this.append = objectInput.readBoolean();
                    break;
                }
                case -6: {
                    this.append = objectInput.readByte();
                    break;
                }
                case 5: {
                    this.append = objectInput.readShort();
                    break;
                }
                case 4: {
                    this.append = objectInput.readInt();
                    break;
                }
                case -5: {
                    this.append = objectInput.readLong();
                    break;
                }
                case 6: {
                    this.append = Float.valueOf(objectInput.readFloat());
                    break;
                }
                case 8: {
                    this.append = objectInput.readDouble();
                    break;
                }
                case 3: 
                case 12: 
                case 91: 
                case 92: 
                case 93: {
                    this.append = objectInput.readObject();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.SEDU);
        objectOutput.writeObject(this.booleanValue);
        if (this.append instanceof NullObject) {
            objectOutput.writeBoolean(true);
            objectOutput.writeObject(this.append);
        } else {
            objectOutput.writeBoolean(false);
            int n = this.booleanValue.getDataType();
            switch (n) {
                case -7: {
                    objectOutput.writeBoolean((Boolean)this.append);
                    break;
                }
                case -6: {
                    objectOutput.writeByte(((Byte)this.append).byteValue());
                    break;
                }
                case 5: {
                    objectOutput.writeShort(((Short)this.append).shortValue());
                    break;
                }
                case 4: {
                    objectOutput.writeInt((Integer)this.append);
                    break;
                }
                case -5: {
                    objectOutput.writeLong((Long)this.append);
                    break;
                }
                case 6: {
                    objectOutput.writeFloat(((Float)this.append).floatValue());
                    break;
                }
                case 8: {
                    objectOutput.writeDouble((Double)this.append);
                    break;
                }
                case 3: 
                case 12: 
                case 91: 
                case 92: 
                case 93: {
                    objectOutput.writeObject(this.append);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }
}

