/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.core;

import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.expression.executor.conditiontools.TupleFilterTool;
import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.dataservice.relational.formulatool.IFormulaExecutor;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import jet.connect.Record;
import jet.dataengine.api.DSException;
import jet.dataengine.api.schema.olap.query.querycoremodel.CubeView;
import jet.dataengine.util.DSLog;
import jet.dataengine8.core.queryengine.impl.SimpleTuple;
import jet.dataengine8.olap.core.AbstractKeyFilter;
import jet.dataengine8.olap.core.BitKey;
import jet.dataengine8.olap.core.DimensionInstance;
import jet.dataengine8.olap.core.DimensionMember;
import jet.dataengine8.olap.core.NullObject;
import jet.dataengine8.olap.util.DataConverter;

public class KeyFilter
extends AbstractKeyFilter {
    private DSLog SEDU = DSLog.getDSLog(this.getClass().getName());
    DimensionInstance[] di;
    JRelationMetaData metaData;
    int[] map;
    Record rec;
    SimpleTuple simTuple;
    IFormulaExecutor formulaExecTool;
    TupleFilterTool tupleFilterTool;

    public KeyFilter(CubeView cubeView, DimensionInstance[] dimensionInstanceArray) throws DSException {
        this.di = dimensionInstanceArray;
        this.tupleFilterTool = cubeView.getOption().getTupleFilterTool();
        if (this.tupleFilterTool != null) {
            if (this.SEDU.isDebugEnabled()) {
                this.SEDU.debug("Do Filter: " + this.tupleFilterTool.toString());
            }
            this.formulaExecTool = cubeView.getOption().getFormulaExecTool();
            this.rec = cubeView.getOption().getRecord();
            this.metaData = cubeView.getOption().getMetaData();
            this.map = this.SEDU(this.metaData, dimensionInstanceArray);
            this.simTuple = new SimpleTuple(this.metaData);
        }
    }

    private int[] SEDU(JRelationMetaData jRelationMetaData, DimensionInstance[] dimensionInstanceArray) throws DSException {
        int n;
        int[] nArray = new int[jRelationMetaData.getColumnCount()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -1;
        }
        for (n = 0; n < dimensionInstanceArray.length; ++n) {
            int n2 = jRelationMetaData.findColumn(dimensionInstanceArray[n].getDimension().getDimensionKeyDescription().getMappingName());
            if (n2 == -1) continue;
            nArray[n2 - 1] = n;
        }
        return nArray;
    }

    private DimensionMember[] and(BitKey bitKey, DimensionInstance[] dimensionInstanceArray) {
        DimensionMember[] dimensionMemberArray = new DimensionMember[dimensionInstanceArray.length];
        for (int i = 0; i < dimensionInstanceArray.length; ++i) {
            BitKey bitKey2 = bitKey.and(dimensionInstanceArray[i].getMasks());
            dimensionMemberArray[i] = (DimensionMember)dimensionInstanceArray[i].getMemberMap().get(bitKey2);
        }
        return dimensionMemberArray;
    }

    private ITuple append(BitKey bitKey, DimensionInstance[] dimensionInstanceArray, SimpleTuple simpleTuple, int[] nArray) {
        DimensionMember[] dimensionMemberArray = this.and(bitKey, dimensionInstanceArray);
        block14: for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) {
                simpleTuple.putNull(0);
                continue;
            }
            int n = nArray[i];
            if (dimensionMemberArray[n] == null) continue;
            int n2 = dimensionMemberArray[n].getAttribute().getDataType();
            if (dimensionMemberArray[n].getValue() instanceof NullObject) {
                simpleTuple.putNull(n2);
                continue;
            }
            switch (n2) {
                case -7: {
                    simpleTuple.putBoolean((Boolean)dimensionMemberArray[n].getValue());
                    continue block14;
                }
                case -6: {
                    simpleTuple.putByte((Byte)dimensionMemberArray[n].getValue());
                    continue block14;
                }
                case 5: {
                    simpleTuple.putShort((Short)dimensionMemberArray[n].getValue());
                    continue block14;
                }
                case 4: {
                    simpleTuple.putInt((Integer)dimensionMemberArray[n].getValue());
                    continue block14;
                }
                case -5: {
                    simpleTuple.putLong((Long)dimensionMemberArray[n].getValue());
                    continue block14;
                }
                case 6: {
                    simpleTuple.putDouble(((Float)dimensionMemberArray[n].getValue()).doubleValue());
                    continue block14;
                }
                case 8: {
                    simpleTuple.putDouble((Double)dimensionMemberArray[n].getValue());
                    continue block14;
                }
                case 93: {
                    JinfonetTimeStamp jinfonetTimeStamp = new JinfonetTimeStamp(((Timestamp)dimensionMemberArray[n].getValue()).getTime());
                    simpleTuple.putTimeStamp(jinfonetTimeStamp);
                    continue block14;
                }
                case 3: {
                    simpleTuple.putBigDecimal((BigDecimal)dimensionMemberArray[n].getValue());
                    continue block14;
                }
                case 12: {
                    simpleTuple.putString((String)dimensionMemberArray[n].getValue());
                    continue block14;
                }
                case 91: {
                    JinfonetDate jinfonetDate = new JinfonetDate(((Date)dimensionMemberArray[n].getValue()).getTime());
                    simpleTuple.putDate(jinfonetDate);
                    continue block14;
                }
                case 92: {
                    JinfonetTime jinfonetTime = new JinfonetTime(((Time)dimensionMemberArray[n].getValue()).getTime());
                    simpleTuple.putTime(jinfonetTime);
                    continue block14;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return simpleTuple;
    }

    @Override
    public boolean filter(BitKey bitKey) throws DSException {
        if (this.tupleFilterTool == null) {
            return true;
        }
        if (this.formulaExecTool == null || this.rec == null) {
            this.simTuple.reset();
            return this.tupleFilterTool.filteTuple(this.append(bitKey, this.di, this.simTuple, this.map));
        }
        DimensionMember[] dimensionMemberArray = this.and(bitKey, this.di);
        for (int i = 1; i < this.map.length; ++i) {
            if (this.map[i] < 0) continue;
            DataConverter.setValue(this.rec.getCell(i - 1), dimensionMemberArray[this.map[i]].getValue());
        }
        this.formulaExecTool.exec();
        this.simTuple.reset();
        DataConverter.setTupleWithRecordInSameMetaData(this.simTuple, this.rec, this.metaData);
        return this.tupleFilterTool.filteTuple(this.simTuple);
    }
}

