/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.core;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.Iterator;
import jet.dataengine8.olap.core.AbstractBitKey;
import jet.dataengine8.olap.core.BigBitKey;
import jet.dataengine8.olap.core.BitKey;
import jet.dataengine8.olap.core.SmallBitKey;

public class MiddleBitKey
extends AbstractBitKey {
    private static final long serialVersionUID = 62019791024L;
    long bits0;
    long bits1;

    public MiddleBitKey() {
    }

    MiddleBitKey(MiddleBitKey middleBitKey) {
        this.bits0 = middleBitKey.bits0;
        this.bits1 = middleBitKey.bits1;
    }

    @Override
    public void set(int n) {
        if (n < 64) {
            this.bits0 |= MiddleBitKey.bit(n);
        } else if (n < 128) {
            this.bits1 |= MiddleBitKey.bit(n);
        } else {
            throw new IllegalArgumentException("pos " + n + " exceeds capacity 128");
        }
    }

    @Override
    public boolean get(int n) {
        if (n < 64) {
            return (this.bits0 & MiddleBitKey.bit(n)) != 0L;
        }
        if (n < 128) {
            return (this.bits1 & MiddleBitKey.bit(n)) != 0L;
        }
        return false;
    }

    @Override
    public void clear(int n) {
        if (n < 64) {
            this.bits0 &= MiddleBitKey.bit(n) ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (n < 128) {
            this.bits1 &= MiddleBitKey.bit(n) ^ 0xFFFFFFFFFFFFFFFFL;
        } else {
            throw new IndexOutOfBoundsException("pos " + n + " exceeds size " + 128);
        }
    }

    @Override
    public void clear() {
        this.bits0 = 0L;
        this.bits1 = 0L;
    }

    @Override
    public int cardinality() {
        return MiddleBitKey.bitCount(this.bits0) + MiddleBitKey.bitCount(this.bits1);
    }

    void or(long l, long l2) {
        this.bits0 |= l;
        this.bits1 |= l2;
    }

    void orNot(long l, long l2) {
        this.bits0 ^= l;
        this.bits1 ^= l2;
    }

    void and(long l, long l2) {
        this.bits0 &= l;
        this.bits1 &= l2;
    }

    @Override
    public BitKey or(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            MiddleBitKey middleBitKey = (MiddleBitKey)this.copy();
            middleBitKey.or(smallBitKey.bits, 0L);
            return middleBitKey;
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            MiddleBitKey middleBitKey2 = (MiddleBitKey)this.copy();
            middleBitKey2.or(middleBitKey.bits0, middleBitKey.bits1);
            return middleBitKey2;
        }
        if (bitKey instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            BigBitKey bigBitKey2 = (BigBitKey)bigBitKey.copy();
            bigBitKey2.or(this.bits0, this.bits1);
            return bigBitKey2;
        }
        throw this.createException(bitKey);
    }

    @Override
    public BitKey orNot(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            MiddleBitKey middleBitKey = (MiddleBitKey)this.copy();
            middleBitKey.orNot(smallBitKey.bits, 0L);
            return middleBitKey;
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            MiddleBitKey middleBitKey2 = (MiddleBitKey)this.copy();
            middleBitKey2.orNot(middleBitKey.bits0, middleBitKey.bits1);
            return middleBitKey2;
        }
        if (bitKey instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            BigBitKey bigBitKey2 = (BigBitKey)bigBitKey.copy();
            bigBitKey2.orNot(this.bits0, this.bits1);
            return bigBitKey2;
        }
        throw this.createException(bitKey);
    }

    @Override
    public BitKey and(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            MiddleBitKey middleBitKey = (MiddleBitKey)this.copy();
            middleBitKey.and(smallBitKey.bits, 0L);
            return middleBitKey;
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            MiddleBitKey middleBitKey2 = (MiddleBitKey)this.copy();
            middleBitKey2.and(middleBitKey.bits0, middleBitKey.bits1);
            return middleBitKey2;
        }
        if (bitKey instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            MiddleBitKey middleBitKey = (MiddleBitKey)this.copy();
            middleBitKey.and(bigBitKey.bits[0], bigBitKey.bits[1]);
            return middleBitKey;
        }
        throw this.createException(bitKey);
    }

    @Override
    public BitKey andNot(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            MiddleBitKey middleBitKey = (MiddleBitKey)this.copy();
            middleBitKey.SEDU(smallBitKey.bits, 0L);
            return middleBitKey;
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            MiddleBitKey middleBitKey2 = (MiddleBitKey)this.copy();
            middleBitKey2.SEDU(middleBitKey.bits0, middleBitKey.bits1);
            return middleBitKey2;
        }
        if (bitKey instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            MiddleBitKey middleBitKey = (MiddleBitKey)this.copy();
            middleBitKey.SEDU(bigBitKey.bits[0], bigBitKey.bits[1]);
            return middleBitKey;
        }
        throw this.createException(bitKey);
    }

    private void SEDU(long l, long l2) {
        this.bits0 &= l ^ 0xFFFFFFFFFFFFFFFFL;
        this.bits1 &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public boolean isSuperSetOf(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            return (this.bits0 | smallBitKey.bits) == this.bits0;
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            return (this.bits0 | middleBitKey.bits0) == this.bits0 && (this.bits1 | middleBitKey.bits1) == this.bits1;
        }
        if (bitKey instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            if ((this.bits0 | bigBitKey.bits[0]) != this.bits0) {
                return false;
            }
            if ((this.bits1 | bigBitKey.bits[1]) != this.bits1) {
                return false;
            }
            for (int i = 2; i < bigBitKey.bits.length; ++i) {
                if (bigBitKey.bits[i] == 0L) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            return (this.bits0 & smallBitKey.bits) != 0L;
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            return (this.bits0 & middleBitKey.bits0) != 0L || (this.bits1 & middleBitKey.bits1) != 0L;
        }
        if (bitKey instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            if ((this.bits0 & bigBitKey.bits[0]) != 0L) {
                return true;
            }
            return (this.bits1 & bigBitKey.bits[1]) != 0L;
        }
        return false;
    }

    @Override
    public BitSet toBitSet() {
        BitSet bitSet = new BitSet(128);
        MiddleBitKey.copyFromLong(bitSet, 0, this.bits0);
        MiddleBitKey.copyFromLong(bitSet, 64, this.bits1);
        return bitSet;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            long varBits0;
            long varBits1;
            int pos;
            {
                this.varBits0 = MiddleBitKey.this.bits0;
                this.varBits1 = MiddleBitKey.this.bits1;
                this.pos = -1;
            }

            @Override
            public boolean hasNext() {
                if (this.varBits0 != 0L) {
                    if (this.varBits0 == Long.MIN_VALUE) {
                        this.pos = 63;
                        this.varBits0 = 0L;
                        return true;
                    }
                    long l = this.varBits0 & -this.varBits0;
                    int n = 0;
                    while (l >= 256L) {
                        l >>= 8;
                        n += 8;
                    }
                    int n2 = AbstractBitKey.bitPositionTable[(int)l];
                    n2 = n2 >= 0 ? (n2 += n) : n;
                    this.pos = this.pos < 0 ? n2 : (n2 == 0 ? ++this.pos : (this.pos += n2 + 1));
                    this.varBits0 >>>= n2 + 1;
                    return true;
                }
                if (this.pos < 63) {
                    this.pos = 63;
                }
                if (this.varBits1 == Long.MIN_VALUE) {
                    this.pos = 127;
                    this.varBits1 = 0L;
                    return true;
                }
                long l = this.varBits1 & -this.varBits1;
                if (l == 0L) {
                    return false;
                }
                int n = 0;
                while (l >= 256L) {
                    l >>= 8;
                    n += 8;
                }
                int n3 = AbstractBitKey.bitPositionTable[(int)l];
                n3 = n3 >= 0 ? (n3 += n) : n;
                this.pos = this.pos < 0 ? n3 : (n3 == 63 ? ++this.pos : (this.pos += n3 + 1));
                this.varBits1 >>>= n3 + 1;
                return true;
            }

            public Integer next() {
                return this.pos;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    @Override
    public int nextSetBit(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        int n2 = n >> 6;
        switch (n2) {
            case 0: {
                long l = this.bits0 & -1L << n;
                if (l != 0L) {
                    return Long.numberOfTrailingZeros(l);
                }
                l = this.bits1;
                if (l != 0L) {
                    return 64 + Long.numberOfTrailingZeros(l);
                }
                return -1;
            }
            case 1: {
                long l = this.bits1 & -1L << n;
                if (l != 0L) {
                    return 64 + Long.numberOfTrailingZeros(l);
                }
                return -1;
            }
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)object;
            return this.bits0 == smallBitKey.bits && this.bits1 == 0L;
        }
        if (object instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)object;
            return this.bits0 == middleBitKey.bits0 && this.bits1 == middleBitKey.bits1;
        }
        if (object instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)object;
            if (this.bits0 != bigBitKey.bits[0]) {
                return false;
            }
            if (this.bits1 != bigBitKey.bits[1]) {
                return false;
            }
            for (int i = 2; i < bigBitKey.bits.length; ++i) {
                if (bigBitKey.bits[i] == 0L) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        long l = 1234L;
        l ^= this.bits0;
        return (int)((l ^= this.bits1 * 2L) >> 32 ^ l);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("0x");
        for (int i = 127; i >= 0; --i) {
            stringBuilder.append(this.get(i) ? (char)'1' : '0');
        }
        return stringBuilder.toString();
    }

    @Override
    public BitKey copy() {
        return new MiddleBitKey(this);
    }

    @Override
    public BitKey emptyCopy() {
        return new MiddleBitKey();
    }

    @Override
    public boolean isEmpty() {
        return this.bits0 == 0L && this.bits1 == 0L;
    }

    public int compareTo(BitKey bitKey) {
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            if (this.bits1 != middleBitKey.bits1) {
                return MiddleBitKey.compareUnsigned(this.bits1, middleBitKey.bits1);
            }
            return MiddleBitKey.compareUnsigned(this.bits0, middleBitKey.bits0);
        }
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            if (this.bits1 != 0L) {
                return 1;
            }
            return MiddleBitKey.compareUnsigned(this.bits0, smallBitKey.bits);
        }
        return this.compareToBig((BigBitKey)bitKey);
    }

    int compareToBig(BigBitKey bigBitKey) {
        int n = bigBitKey.effectiveSize();
        switch (n) {
            case 0: {
                return this.bits1 == 0L && this.bits0 == 0L ? 0 : 1;
            }
            case 1: {
                if (this.bits1 != 0L) {
                    return 1;
                }
                return MiddleBitKey.compareUnsigned(this.bits0, bigBitKey.bits[0]);
            }
            case 2: {
                if (this.bits1 != bigBitKey.bits[1]) {
                    return MiddleBitKey.compareUnsigned(this.bits1, bigBitKey.bits[1]);
                }
                return MiddleBitKey.compareUnsigned(this.bits0, bigBitKey.bits[0]);
            }
        }
        return -1;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.bits0 = objectInput.readLong();
        this.bits1 = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.bits0);
        objectOutput.writeLong(this.bits1);
    }
}

